<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * The footer loop
 * Displays 4 recent posts
 *
 * @package WooFramework
 * @subpackage Template
 */
?>

<?php if ( ! is_home() && ! is_archive() && ! is_page_template( 'template-blog.php' ) ) : ?>

<div class="footer-posts">

	<div class="posts-wrap">

		<?php

		// WP_Query arguments
		$args = array (
			'posts_per_page' => 4,
		);

		// The Query
		$query = new WP_Query( $args );

		if ( $query->have_posts() ) : $count = 0; ?>

			<?php while ( $query->have_posts() ) : $query->the_post(); $count++; ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to overload this in a child theme then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', 'footer' );
				?>

			<?php endwhile; ?>

		<?php else : ?>

		    <article <?php post_class(); ?>>

		        <p><?php _e( 'Sorry, no posts matched your criteria.', 'woothemes' ); ?></p>

		    </article><!-- /.post -->

		<?php endif; ?>

	</div><!-- /.posts-wrap -->

</div><!-- /.footer-posts -->

<?php endif; ?>