<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Integrates this theme with the Sensei plugin
 * http://www.woothemes.com/woocommerce/
 */

/**
 * General Setup
 */

if ( ! is_admin() ) {
	add_action( 'wp_enqueue_scripts', 'woo_wc_css', 10 );
}

add_action( 'wp', 'woo_wc_disable_css' );
add_action( 'after_setup_theme', 'woocommerce_support' );

/**
 * Layout
 * Replace WooCommerce wrappers with our own and filter the body class
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
add_action( 'woocommerce_before_main_content', 'woo_wc_before_content', 10 );
add_action( 'woocommerce_after_main_content', 'woo_wc_after_content', 20 );
add_filter( 'body_class','woo_wc_layout_body_class', 10 );

/**
 * Upsells
 * Replace WooCommerce upsells with our own function which adjusts display
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
add_action( 'woocommerce_after_single_product_summary', 'woo_wc_upsell_display', 15 );

/**
 * Related Products
 * Filters related products to adjust display
 */
add_filter( 'woocommerce_output_related_products_args', 'woo_wc_related_products' );

/**
 * Product Columns
 * Filters product columns to adjust display
 */
add_filter( 'loop_shop_columns', 'woo_wc_loop_columns', 98 );
add_filter( 'loop_shop_per_page', 'woo_wc_loop_per_page', 20 );

/**
 * Breadcrumbs
 * Remove the WooCommerce breadcrumb. The WooFramework breadcrumb is hooked in later.
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

/**
 * Sidebar
 * Replace the WooCommerce sidebar with our own.
 */
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
add_action( 'woocommerce_sidebar', 'woo_wc_get_sidebar', 10 );

/**
 * Pagination
 * Replace the WooCommerce pagination function with woo_pagination.
 */
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
add_action( 'woocommerce_after_shop_loop', 'woo_wc_pagination', 10 );

/**
 * Cart Fragments
 * Pieces of code to refresh via ajax when products are added to the cart
 */
add_filter( 'add_to_cart_fragments', 'woo_wc_header_add_to_cart_fragment' );