<?php

$query = wTestimonial::wp_query();
if (!$query)
	return;

//$section_title = get_the_title();
?>
<div>
	<?php if (!empty($section_title)) { ?>
		<h2><?php echo $section_title; ?></h2>
	<?php } ?>
	<div class="carousel_wrap testimonial-list-<?php echo $post_section_id; ?>">
		<div class="arrow_wrap">
			<span class="prev carousel-arrow"></span>
			<span class="next carousel-arrow"></span>
		</div>
		<?php if ($query->have_posts()) { ?>
			<div class="carousel">
				<?php while ($query->have_posts()) { $query->the_post(); ?>
					<?php
						$meta = wTestimonial::get_all_meta(get_the_ID());
						$title = get_the_title();
						$content = get_the_content();
						$job_title = @$meta['job_title'];
						$rating = @$meta['rating'];
					?>
					<div class="item">
						<div class="bottom_content">
							<?php if (!empty($rating)) { ?>
								<?php echo wTheme::part('rating', compact('rating')); ?>
							<?php } ?>
						</div>
						<?php if (!empty($content)) { ?>
							<div class="testimonial_content"><?php echo wTheme::truncate($content, 150); ?></div>
						<?php } ?>
						<?php if (!empty($title)) {
							echo '<h4>'.$title.'</h4>';
						} ?>
					</div>
				<?php } ?>
			</div>
			<?php wp_reset_postdata(); ?>
		<?php } ?>
	</div>
</div>
<script>
	wLoadDelayed(function () {
		var interval = setInterval(function() {
			if (!jQuery.fn || !jQuery.fn.slick)
				return;
			clearInterval(interval);
			var $testimonialList = jQuery('.testimonial-list-<?php echo $post_section_id; ?>');
			var	$carousel = jQuery('.carousel', $testimonialList);
			var	$prev_arrow = jQuery('.carousel-arrow.prev', $testimonialList);
			var	$next_arrow = jQuery('.carousel-arrow.next', $testimonialList);
			var	slick_options = {
				infinite: true,
				slidesToShow: 1,
				slidesToScroll: 1,
				centerMode: true,
				dots: false,
				prevArrow: $prev_arrow,
				nextArrow: $next_arrow,
				variableWidth: true,
				draggable: false
			};
			if ($carousel.find('.item').length < 3) {
				slick_options.arrows = false;
				jQuery('.carousel-arrow', $testimonialList).hide();
			}
			$carousel.slick(slick_options);
		}, 500);
	});
</script>

