<?php
if (empty($meta))
	return;
//var_dump($meta);

?>
<div>
	<?php
		$image_id = @$meta['image_id'];
		if (!empty($image_id)) {
			echo wp_get_attachment_image($image_id, 'full');
		}
	?>
	<div class="wrap">
		<?php if (!empty(get_the_title())) { ?>
			<h2><?php echo get_the_title(); ?></h2>
		<?php } ?>
		<div class="counters clear">
			<?php for ($i = 0; $i < 4; $i++) { ?>
				<?php
					$counterType = $meta['type_'.$i] ?? '0';
					$counterValue = $meta['counter_'.$i] ?? '';
					$counterLabel = $meta['counter_label_'.$i] ?? '';
					$counterValue2 = $meta['counter2_'.$i] ?? '';
					$counterLabel2 = $meta['counter_label2_'.$i] ?? '';
				?>
				<?php if ('' !== $counterValue) { ?>
					<div class="counter_wrap step_<?= $i; ?> type_<?= $counterType; ?>" data-animation-type="<?= $counterType; ?>">
						<?php if ('3' === $counterType) { ?>
							<div class="first" style="display: block;">
								<div class="counter" data-count-to="<?= $counterValue; ?>"><?= $counterValue; ?></div>
								<div class="label"><?= $counterLabel; ?></div>
							</div>
							<?php if ('' !== $counterValue2) { ?>
								<div class="second" style="display: none;">
									<div class="counter" data-count-to="<?= $counterValue2; ?>"><?= $counterValue2; ?></div>
									<div class="label"><?= $counterLabel2; ?></div>
								</div>
							<?php } ?>
						<?php } else { ?>
							<div class="counter" data-count-to="<?= $counterValue; ?>">
								<?php if ('1' === $counterType) { ?>
									<?= $counterValue; ?>
								<?php } elseif ('2' === $counterType) { ?>
									<?= date('Y'); ?>
								<?php } else { ?>
									0
								<?php } ?>
							</div>
							<div class="label"><?= $counterLabel; ?></div>
						<?php } ?>
					</div>
				<?php } ?>
			<?php } ?>
		</div>
	</div>
</div>
<script>
	function wtheme_counter_start() {
		var $counters = jQuery('.counters');
		if (0 === $counters.length)
			return;

		var scroll = jQuery(window).scrollTop();
		var wh = jQuery(window).outerHeight();
		var counter_height = $counters.outerHeight();
		var counter_top = $counters.offset().top - wh + (counter_height/2);
		var counter_bottom = $counters.offset().top;
		var $step0 = jQuery('.step_0 .counter', $counters);
		var $step1 = jQuery('.step_1 .counter', $counters);
		var $step2 = jQuery('.step_2 .counter', $counters);
		var $step3 = jQuery('.step_3 .counter', $counters);
		if (scroll >= counter_top && scroll <= counter_bottom) {
			//jQuery('.counter', $counters).css('opacity', '1');
			if (1 === $counters.not('.finish').length) {
				$counters.addClass('finish');
				setTimeout(function () {
					animation($step0, $step0.closest('.counter_wrap').data('animation-type'))
				}, 100);

				setTimeout(function () {
					animation($step1, $step1.closest('.counter_wrap').data('animation-type'))
				}, 1500);

				setTimeout(function () {
					animation($step2, $step2.closest('.counter_wrap').data('animation-type'))
				}, 3000);

				setTimeout(function () {
					animation($step3, $step3.closest('.counter_wrap').data('animation-type'))
				}, 4500);
			}
		}
		//'Value', 'Price', 'Year', 'Percentage'
		function animation(selector, type) {
			switch (type) {
				case 0:
					selector.not('.finish').each(function () {
						jQuery(this).addClass('finish');
						jQuery(this).prop('Counter', 0).animate({
							Counter: jQuery(this).data('countTo')
						}, {
							duration: 1500,
							easing: 'swing',
							step: function (now) {
								jQuery(this).text(Math.ceil(now).toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."));
							}
						});
					});
				break;
				case 1:
					selector.css('opacity', '1').addClass('animate');
				break;
				case 2:
					selector.not('.finish').each(function () {
						jQuery(this).addClass('finish');
						jQuery(this).prop('Counter', new Date().getFullYear()).animate({
							Counter: jQuery(this).data('countTo')
						}, {
							duration: 1500,
							easing: 'swing',
							step: function (now) {
								jQuery(this).text(Math.ceil(now).toString());
							}
						});
					});
				break;
				case 3:
					var $step_1 = selector.closest('.counter_wrap').find('.first', $counters);
					var $step_2 = selector.closest('.counter_wrap').find('.second', $counters);
					if (1 === $step_1.not('.finish').length && 1 === $step_2.length) {
						step_3_1();
					}
				function step_3_1() {
					$step_1.addClass('finish');
					$step_1.fadeOut(1800, function () {
						$step_2.fadeIn(300);
						step_3_2();
					});
				}
				function step_3_2() {
					$step_2.fadeOut(1800, function () {
						$step_1.fadeIn(300);
						step_3_1();
					});
				}
				break;
			}
		}
	}

	wLoad(function() {
		jQuery(window).scroll(function(){
			wtheme_counter_start();
		});
		wtheme_counter_start();
	});
</script>
