<?php
$ids = get_post_meta(get_the_ID(), 'recommended_product', true);
$ids = explode(",", $ids);
if (empty($ids))
	return false;

$args = array(
	'post_type' => wProduct::$post_type,
	'post__in' => $ids,
	'orderby' => 'post__in'
);
$post_query = new WP_Query($args);
if ($post_query->have_posts()) { ?>
	<aside id="recommended_product" class="widget recommended_product">
		<a href="#" class="recommended_product_responsive_close"><?php wTheme::_e('luk'); ?></a>
		<h3 class="widget_title"><?php wTheme::_e('We recommend'); ?></h3>
		<div class="textwidget">
		<?php while ($post_query->have_posts()) {
			$post_query->the_post(); ?>
			<article class="product">
				<?php if (has_post_thumbnail()) { ?>
					<div class="event_thumb"><span><?php the_post_thumbnail(wTheme::prefix('event_thumb_widget')); ?></span></div>
				<?php } ?>
				<div class="wrap">
					<header class="entry_header">
						<h2><span><span class="responsive_sub_title"><?php wTheme::_e('We recommend'); ?></span><?php echo wTheme::truncate(get_the_title(), 50); ?></span></h2>
					</header>
					<div class="entry_content_wrap">
<!--						--><?php //echo wTheme::truncate(wTheme::get_the_content(get_the_content(), false), 180); ?>
						<?php
						$external_link = get_post_meta(get_the_ID(), 'external_link', true);
						$read_more_label = wTheme::__('To store');
						$read_more_label_custom = get_post_meta(get_the_ID(), 'read_more', true);
						if ('' != $external_link) {
							if (!wtheme_is_affiliate_domains($external_link)) {
								?>
								<div class="read_more_wrap">
									<p><span class="read_more read_more_span"><?php echo $read_more_label; ?></span></p>
								</div>
								<a href="<?php echo $external_link; ?>" class="full_box_link" onclick="return !window.open(this.href);"></a>
								<?php
							} else {
								?>
								<div class="read_more_wrap">
									<p><span class="read_more read_more_span"><?php echo $read_more_label; ?></span></p>
								</div>
								<a href="#" class="full_box_link" onclick="return !window.open('<?php echo $external_link; ?>');" rel="nofollow"></a>
								<?php
							}
						}
						?>
					</div>
				</div>
			</article>
			<?php
		}
		?>
		</div>
	</aside>
<?php }
wp_reset_postdata();