<?php
	$url = home_url('/');
	$site_name = get_bloginfo('name', 'display');
	$alt = $title = $site_name;
	$slogan = '';

	if (!empty($type) && 'header' == $type) {
		$logo_image_filename = 'logo.png';
		$logo_options = wThemeSettings::get_option('Header.site_logo');
		$image_url = wp_get_attachment_image_url(@$logo_options['attachment_id'], 'full');
		$home_image_url = wp_get_attachment_image_url(@$logo_options['attachment_id_home'], 'full');
		if (is_front_page() && !empty($home_image_url))
			$image_url = $home_image_url;
	} else {
		$logo_image_filename = 'logo-footer.png';
		$logo_options = wThemeSettings::get_option('Footer.site_logo');
		$image_url = wp_get_attachment_image_url(@$logo_options['attachment_id'], 'full');
	}

	$src = get_template_directory_uri().'/images/'.$logo_image_filename;

	if (!empty($image_url))
		$src = $image_url;

	if (isset($logo_options['alt']) && '' !== $logo_options['alt'])
		$alt = $logo_options['alt'];

	if (isset($logo_options['slogan']) && '' !== $logo_options['slogan'])
		$slogan = $logo_options['slogan'];
?>
<a class="logo" href="<?php echo esc_url($url); ?>" title="<?php echo esc_attr($title); ?>" rel="home">
	<img src="<?php echo $src; ?>" alt="<?php echo esc_attr($alt); ?>" />
	<?php if ('' !== $slogan) { ?>
		<span class="slogan"><?php echo $slogan; ?></span>
	<?php } ?>
</a>