<?php
/**
 * Template Name: Page sections
 * Layout: full-width
 */

the_post();

$testimonial_box_script = false;

$args = array(
	'post_type' => wPageSection::$post_type,
	'post_status' => 'publish',
	'post_parent' => get_the_ID(),
	'orderby' => 'menu_order ID',
	'order' => 'ASC',
	'suppress_filters' => true,
	'posts_per_page' => -1,
);

$section_query = new WP_Query($args);
if(!$section_query->have_posts())
	return;

while ($section_query->have_posts()) { $section_query->the_post();
	$post_section_id = get_the_ID();
	$meta = wPageSection::get_all_meta($post_section_id);
	$layout = $meta['layout'];

	//settings from bg_color_settings()
	$bg_color = @$meta['background_color'];
	$is_parallax = @$meta['is_parallax'];
	$text_color = @$meta['text_color'];
	$bg_image = @$meta['bg_thumbnail_id'];
	$padding_top = @$meta['padding_top'];
	$padding_bottom = @$meta['padding_bottom'];
	$offset_top = @$meta['offset_top'];
	$offset_bottom = @$meta['offset_bottom'];

	$style = '';
	$fixed_bg = (!empty($is_parallax) && '1' == $is_parallax) ? ' fixed' : '';
	$bg = !empty($bg_image) ? ' url('.wp_get_attachment_url($bg_image).') no-repeat 50% 50% / cover'.$fixed_bg : '';

	if (!empty($bg_color) || !empty($bg))
		$style = 'background:'.$bg_color.$bg.';';

	if (!empty($text_color))
		$style .= 'color:'.$text_color.';';

	if (!empty($offset_top))
		$style .= "margin-top:{$offset_top}px;";

	if (!empty($offset_bottom))
		$style .= "margin-bottom:{$offset_bottom}px;";

	if (!empty($padding_top))
		$style .= "padding-top:{$padding_top}px;";

	if (!empty($padding_bottom))
		$style .= "padding-bottom:{$padding_bottom}px;";

	if (!empty($style))
		$style = 'style="'.$style.'"';

	?>
	<?php if ('default' == $layout) { ?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php echo wTheme::part('section/default', compact('meta')); ?>
		</article>
	<?php } else if ('category_box' == $layout) { ?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php echo wTheme::part('section/category_box', compact('meta')); ?>
		</article>
	<?php } else if ('news' == $layout) { ?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php echo wTheme::part('latest_posts'); ?>
		</article>
	<?php } else if ('newsletter' == $layout) { ?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php echo wTheme::part('newsletter'); ?>
		</article>
	<?php } else if ('image_and_description' == $layout) { ?>
		<?php echo wTheme::part('section/image_and_description', compact('meta', 'post_section_id', 'style')); ?>
	<?php } else if ('testimonial_box' == $layout) { ?>
		<article class="clear <?php echo $layout; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php $section_title = get_the_title(); ?>
			<?php echo wTheme::part('section/testimonial_box', compact('meta', 'style', 'post_section_id', 'section_title')); ?>
			<?php if (false == $testimonial_box_script) { ?>
				<?php wp_enqueue_script(wTheme::prefix('slick')); ?>
				<?php $testimonial_box_script = true; ?>
			<?php } ?>
		</article>
	<?php } ?>
<?php } ?>
<?php wp_reset_postdata(); ?>
