<?php get_header(); ?>
<?php if ((is_front_page() || is_page())) { ?>
	<?php if (is_singular('post') || is_single()) {
		the_post();
		$meta = wCustomPostType::get_all_meta(get_the_ID(), true);
		$overlayColor = !empty($meta['overlay_color']) ? @$meta['overlay_color'] : '#AC1049';
		$overlayValue = '0' !== @$meta['overlay_value'] ? ((int) @$meta['overlay_value'] / 100) : false;
	} ?>
	<div class="page_thumb_wrap">
		<div class="page_thumb">
			<?php if (!empty($overlayValue)) { ?>
				<span class="featured_overlay" style="background-color: <?= $overlayColor; ?>;opacity: <?= $overlayValue; ?>;"></span>
			<?php } ?>
			<span class="wrap_image">
				<span>
					<?php
					if (has_post_thumbnail()) {
						if (is_front_page()) {
							the_post_thumbnail(wTheme::prefix('page_thumb_home'));
						} else {
							the_post_thumbnail(wTheme::prefix('page_thumb'));
							wTheme::add_body_class('default_thumbnail');
						}
					} else {
						echo '<img src="' . get_template_directory_uri() . '/images/page_thumb.jpg" />';
					}
					?>
				</span>
			</span>
			<div>
				<div class="wrap_middle">
					<?php
					if (is_front_page()) {
						$before_title_label = get_post_meta(get_the_ID(), 'before_title_label', true);
						if ('' != $before_title_label) {
							echo '<div class="before_title_label">'.$before_title_label.'</div>';
						}
					} ?>
					<h1><?php the_title(); ?></h1>
					<?php
					if (is_front_page())
						get_search_form();

					echo wTheme::get_the_content(@get_post_meta(get_the_ID(), 'short_description', true), true);
					?>
				</div>
			</div>
			<?php if (is_front_page()) { ?>
				<a href="#" class="scroll_down"><span></span></a>
			<?php } ?>
		</div>
	</div>
<?php } elseif (is_category()) { ?>
	<div class="page_thumb_wrap">
		<div class="page_thumb">
			<span class="wrap_image">
				<span>
					<?php
						//$thumb_id = get_term_meta(get_queried_object_id(), 'thumbnail_id');
						//if (!empty($thumb_id[0])) {
						//	echo wp_get_attachment_image($thumb_id[0], wTheme::prefix('page_thumb'));
						//} else {
							//default image
							echo '<img src="'.get_template_directory_uri().'/images/page_thumb.jpg" />';
						//}
					?>
				</span>
			</span>
			<div>
				<div class="wrap_middle">
					<h1><?php echo get_queried_object()->cat_name; ?></h1>
				</div>
			</div>
		</div>
	</div>
<?php } ?>

<div class="main">
	<?php if (is_singular('post')) { ?>
	<div class="single_post_main_wrap"><?php //open single post main wrap ?>
		<?php wSidebar::show('left'); ?>
		<div class="sticky_parent">
			<?php } ?>
			<div class="content sticky_column">
				<?php echo $content_for_layout; ?>
			        <?php if (is_singular('post')) { ?>
			                <?php wp_enqueue_script(wTheme::prefix('slick')); //for sections and hardcode section bottom ?>
			                <?php echo wTheme::part('post_sections'); ?>
			        <?php } ?>
			</div>
			<?php if (!wp_is_mobile() && is_single()) { ?>
				<div class="reviewed_by_wrap">
					<?php echo wTheme::part('reviewed_by') ?>
				</div>
			<?php } ?>
			<?php if ('right-sidebar' == wTheme::$layout) {
				if (is_category()) {
					wSidebar::show('right_category');
				} else {
					wSidebar::show('right');
				}
				?>
			<?php } ?>
			<?php if (is_singular('post')) {
			echo wTheme::part('recommended_product');
			?>
		</div>
	</div><?php //close single post main wrap ?>
	<div class="meta">
		<div class="clear">
			<div class="author_meta">
				<?php $avatar = wAvatar::get_avatar(get_the_author_meta('ID'), wTheme::prefix('avatar')); ?>
				<?php if (!empty($avatar)) { ?>
					<div class="author_image"><?= $avatar; ?></div>
				<?php } ?>
				<h2><?php wTheme::_e('About the writer') ?></h2>
				<div class="description">
					<?php echo wTheme::get_the_content(get_the_author_meta('description'), false); ?>
				</div>
			</div>
			<div class="more_information">
				<h2><?php wTheme::_e('Find more information here') ?></h2>
				<?php
				$more_information = get_post_meta(get_the_ID(), 'more_information', true);
				if ('' == $more_information) {
					$more_information = wThemeSettings::get_option('General.more_information');
				}
				echo wTheme::get_the_content($more_information, false);
				?>
			</div>
		</div>
		<div class="reviews_box">
			<?php echo wTheme::part('review_list'); ?>
			<?php //echo wTheme::part('visitors_rating'); ?>
		</div>
	</div>
	<?php if (!is_singular(wPost::$post_type)) { ?>
	<div class="post_sections">
		<?php $post_section_id = 'testimonial_'.get_the_ID(); ?>
		<article class="clear testimonial_box" id="section-<?= $post_section_id; ?>">
			<?php echo wTheme::part('section/testimonial_box', compact('post_section_id')); ?>
		</article>
	</div>
	<?php } ?>
</div>
<?php } ?>
<?php
if (is_page()) {
	echo wTheme::part('schema_news-article');
}
?>
</div>
<?php wSidebar::show('before_footer'); ?>
<?php get_footer(); ?>
