/**
 * Version 1.1
 */

function getOffset(el) {
	"use strict";
	var rect = el.getBoundingClientRect();
	return {
		left: rect.left + window.pageXOffset,
		top: rect.top + window.pageYOffset
	};
}

function lazyload() {
	"use strict";
	var top = window.pageYOffset + window.innerHeight,
		items = document.querySelectorAll('img[data-src]'),
		i,
		el,
		t;

	for (i = 0; i < items.length; i += 1) {
		el = items[i];
		t = getOffset(el).top;
		if (t <= top) {
			el.src = el.getAttribute('data-src');
			el.removeAttribute('data-src');

			if (el.hasAttribute('data-srcset')) {
				el.srcset = el.getAttribute('data-srcset');
				el.removeAttribute('data-srcset');
			}
		}
	}

	items = document.querySelectorAll('iframe[data-src]');
	for (i = 0; i < items.length; i += 1) {
		el = items[i];
		t = getOffset(el).top;
		if (t <= top) {
			el.src = el.getAttribute('data-src');
			el.removeAttribute('data-src');
		}
	}

	items = document.querySelectorAll('[data-background-image]');
	for (i = 0; i < items.length; i += 1) {
		el = items[i];
		t = getOffset(el).top;
		if (t <= top) {
			el.style.backgroundImage = el.getAttribute('data-background-image');
			el.removeAttribute('data-background-image');
		}
	}
}
lazyload();
document.addEventListener('DOMContentLoaded', lazyload);
window.addEventListener('scroll', lazyload, false);