jQuery(function() {
	var $link_to_image = jQuery('a').filter(function() {
		var href = jQuery(this).attr('href');
		if(href)
			return href.match(/\.(jpg|png|gif|jpeg)/);
	});

	wtheme_initPrettyPhoto($link_to_image);

	jQuery('.entry_content .shortcode_hidecontent').click(function() {
		var $this = jQuery(this);
		$this.next().show();
		jQuery('.'+$this.attr('href').substr(1)).show();
		$this.hide();
		return false;
	});

	jQuery('.entry_content .shortcode_showcontent').click(function() {
		var $this = jQuery(this);
		jQuery('.'+$this.attr('href').substr(1)).hide();
		$this.hide();
		$this.prev().show();
		return false;
	});

	jQuery('.entry_content .shortcode_question').click(function() {
		var $this = jQuery(this);
		var $answer = $this.nextAll('.shortcode_answer:first');
		$answer.slideToggle(function() {
			$this.toggleClass('expand', $answer.is(":visible"));
		});
	});

	jQuery('.entry_content .shortcode_answer:visible').each(function() {
		jQuery(this).prevAll('.shortcode_question:first').addClass('expand');
	});

	var $main_menu = jQuery('nav.main_menu');

	$main_menu.find('> .menu_button').click(function() {
		jQuery(this).parent().toggleClass('active').find('> ul').slideToggle(500);
	});

	jQuery('.main_menu ul li').hover(
		function(){
			jQuery(this).find("> .sub-menu").stop(true,false).slideDown(300);
		}, function(){
			jQuery(this).find("> .sub-menu").delay(300).stop(true,true).slideUp(0);
		}
	);
	jQuery('.scroll_down').click(function(){
		jQuery('body, html').animate({scrollTop:jQuery('.page_thumb_wrap').outerHeight()+jQuery('.site_header').outerHeight()}, 300);
		return false;
	});

	jQuery(document).on('click', '.recommended_product_responsive_close', function () {
		jQuery(this).closest('.recommended_product').css('bottom', -104);
		return false;
	});
});

//Fix for top menu justify when minimized html
jQuery('.site_header .wrap li').after(' ');

jQuery(window).on('load', function() {
	jQuery('.main_menu').show();

	jQuery('#recommended_product').clone().appendTo('.sidebar.right');
	jQuery('.main .sticky_parent > #recommended_product').remove();

	var $h2_list = jQuery('.single .main .entry_content h2');
	if (0 == $h2_list.length) {
		jQuery('.widget_title_anchors').remove();
	}
	var h2_counter = 0;
	$h2_list.each(function(){
		h2_counter++;
		var $this = jQuery(this);
		$this.attr("id","h2anchor_"+h2_counter);
		var n=1*h2_counter;
		jQuery('.list_links').append('<li><span>'+n+'</span><a href="#'+$this.attr("id")+'">'+$this.html()+'</a></li>');
	});
	jQuery('.widget_title_anchors a').click(function() {
			if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
				var target = jQuery(this.hash);
				target = target.length ? target : jQuery('[name=' + this.hash.slice(1) +']');
				if (target.length) {
					jQuery('html, body').animate({
						scrollTop: target.offset().top
					}, 1000);
					return false;
				}
			}
		});

	wtheme_add_tables_wrap_fix();

/*--
	if (jQuery(window).width() > 1140) {
		var $reviewed_by_block = jQuery('.main .content .reviewed_by').detach();

		$reviewed_by_block.insertBefore(jQuery('.sidebar.right'));
		jQuery('.reviewed_by').wrap("<div class='reviewed_by_wrap'></div>");
	}
--*/

	jQuery(window).resize(function() {
		wtheme_responsiveMenu();
		wtheme_clickMenu();
		wtheme_home_sidebar_fix();
		wtheme_init_sticky();
		wthemeMoveRightSidebar();
		if (jQuery(window).width() < 1023) {
			var $recommendedProduct = jQuery('.widget.recommended_product');
			setTimeout(function () {
				$recommendedProduct.css('bottom', 0);
				var $image = $recommendedProduct.find('img');
				if (typeof $image.attr('data-src') !== typeof undefined && $image.attr('data-src') !== false) {
					$image.attr('src', $image.attr('data-src'));
					$image.removeAttr('data-src');
				}
				if (typeof $image.attr('data-srcset') !== typeof undefined && $image.attr('data-srcset') !== false) {
					$image.srcset = $image.attr('data-srcset');
					$image.removeAttr('data-srcset');
				}
			}, 9000);
		}
	}).trigger('resize');
});

function wtheme_initPrettyPhoto($list) {
	$list.prettyPhoto({social_tools: false});
}

function wtheme_responsiveMenu() {
	var existingWidth = jQuery(document).data('resize-width');
	var newWidth = jQuery(document).width();
	if (existingWidth != newWidth) {
		var $main_menu = jQuery('nav.main_menu');

		if (jQuery(window).width() < 1140) {
			$main_menu.removeClass('active').addClass('responsive').find('> ul').hide();
		} else {
			$main_menu.removeClass('responsive active').find('> ul').show();
		}

		//if (jQuery(window).width() <= 1140) {
		//	var $items = $main_menu.find('> ul > li');
		//	var max_width = $main_menu.width();
		//	var width = 0;
		//
		//	$items.each(function() {
		//		if (width + jQuery(this).outerWidth(true) >= max_width) {
		//			$main_menu.addClass('responsive').find('> ul').hide();
		//			return false;
		//		} else {
		//			$main_menu.removeClass('responsive active').find('> ul').show();
		//			width += jQuery(this).outerWidth(true);
		//		}
		//	});
		//}

		jQuery(document).data('resize-width', newWidth);
	}
}

function wtheme_clickMenu() {
	var is_touch = (('ontouchstart' in document.documentElement) || ('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0));
	if (is_touch && (!jQuery('.main_menu').hasClass('responsive'))) {
		jQuery('.main_menu .menu-item-has-children > a').click(function() {
			if (!jQuery(this).data('click')) {
				jQuery(this).data('click', 1).parent().addClass('active').siblings().removeClass('active').find('a').data('click', 0);
				jQuery(this).parent().siblings().find('.active').removeClass('active');
				return false;
			}
		});

		jQuery('body').click(function(e) {
			if (jQuery(e.target).parents('.main_menu').length === 0) {
				jQuery('.main_menu li').removeClass('active').find('a').data('click', 0);
			}
		});
	}
}

function wtheme_home_sidebar_fix() {
	var max_height = 0;
	var current_height = 0;
	jQuery('.sidebar.home .widget').each(function(){
		current_height = jQuery(this).find('.textwidget').outerHeight();
		if (current_height >= max_height) {
			max_height = current_height;
		}
	});
	jQuery('.sidebar.home .widget .textwidget').outerHeight(max_height);
}

function wtheme_init_sticky() {
	if (jQuery('body').hasClass('single-post')) {
		jQuery('.sticky_column').trigger("sticky_kit:detach");
		if (jQuery(window).width()> 1400) {
			jQuery('.sticky_parent .sidebar .widget:first').nextAll().wrapAll('<div class="sticky_column" />');
			jQuery('.sticky_column').stick_in_parent({parent: '.sticky_parent'});
			return function(e) {
				return jQuery(document.body).trigger("sticky_kit:recalc");
			};
		}
	}
}

function wtheme_add_tables_wrap_fix() {
	var $tables = jQuery('.entry_content table');
	$tables.each(function(){
		jQuery(this).wrap("<div style='overflow-x: auto;'></div>");
	});
}

function wthemeMoveRightSidebar() {
	if (jQuery(window).width() < 1140) {
		jQuery('.single_post_main_wrap #right_sidebar').appendTo('.main');
	} else {
		jQuery('.main > #right_sidebar').appendTo('.single_post_main_wrap .sticky_parent');
	}
}
