<?php

function wtheme_action_in_widget_form($wp_widget, $return, $instance) {
	$defaults = array('class'=>'');
	$instance = wp_parse_args((array) $instance, $defaults);
	$class = $instance['class'];
	?>
	<p>
		<label for="<?php echo $wp_widget->get_field_id('class'); ?>"><?php wTheme::_e('Class'); ?>:</label>
		<input class="widefat" id="<?php echo $wp_widget->get_field_id('class'); ?>" name="<?php echo $wp_widget->get_field_name('class'); ?>" type="text" value="<?php echo $class; ?>" />
	</p>
	<?php
	return array($wp_widget, $return, $instance);
}
add_action('in_widget_form', 'wtheme_action_in_widget_form', 10, 3);

function wtheme_filter_widget_update_callback($instance, $new_instance) {
	$instance['class'] = strip_tags($new_instance['class']);
	return $instance;
}
add_filter('widget_update_callback', 'wtheme_filter_widget_update_callback', 10, 2);

function wtheme_filter_dynamic_sidebar_params($params) {
	global $wp_registered_widgets;

	$sidebar_index = $params[0]['id'];
	$sidebars_widgets = wp_get_sidebars_widgets();
	if (!isset($sidebars_widgets[$sidebar_index]) || empty($sidebars_widgets[$sidebar_index]))
		return $params;

	$widget_id = $params[0]['widget_id'];
	$widget_obj = @$wp_registered_widgets[$widget_id];
	$widget_opt = get_option(@$widget_obj['callback'][0]->option_name);
	$widget_num = @$widget_obj['params'][0]['number'];
	$classes = array();
	if (!empty($widget_opt[$widget_num]['class']))
		$classes[] = $widget_opt[$widget_num]['class'];
	$widgets = $sidebars_widgets[$sidebar_index];

	$key = array_search($widget_id, $widgets);
	$count = count($widgets);
	if (false !== $key && $count > 1 && ($key + 1) == $count)
		$classes[] .= 'last';

	if (!empty($classes))
		$params[0]['before_widget'] = preg_replace('/(class\s*=\s*"|\')([^"|\']+)("|\')/i', '$1$2 '.implode(' ',  $classes).'$3', $params[0]['before_widget']);
	return $params;
}
add_filter('dynamic_sidebar_params', 'wtheme_filter_dynamic_sidebar_params');

class wTheme_Widget_Children_Pages extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_child_pages widget_nav_menu',
			'description' => wTheme::__('This widget will show children pages if any when standing on a parent page.'),
		);
		parent::__construct(wTheme::prefix('child_pages'), wTheme::__('Children pages'), $widget_ops);
	}

	function widget($args, $instance) {
		$page = get_queried_object();
		if (!is_page() || !$page || 'page' != $page->post_type)
			return;

		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
		$order_by = empty($instance['order_by']) ? 'menu_order' : $instance['order_by'];
		$show_siblings = $instance['show_siblings'];

		if (empty($title)) {
			$title = $page->post_title;
			if (!empty($page->ancestors)){
				$title = get_the_title($page->ancestors[count($page->ancestors)-1]);
			}
		}

		if ('menu_order' == $order_by)
			$order_by = 'menu_order, post_title';

		$pages_args = array('title_li'=>'', 'echo'=>0, 'sort_column'=>$order_by, 'child_of' => $page->ID, 'depth'=>1);
		$out = wp_list_pages(apply_filters('widget_pages_args', $pages_args));
		if (empty($out) && $show_siblings) {
			$pages_args['child_of'] = $page->post_parent;
			//$pages_args['exclude'] = $page->ID;
			$out = wp_list_pages(apply_filters('widget_pages_args', $pages_args));
		}

		if (!empty($out)) {
			echo $before_widget;
			if (!empty($title))
				echo $before_title.$title.$after_title;
			echo '<ul class="menu">'.$out.'</ul>';
			echo $after_widget;
		}
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['order_by'] = 'post_title';
		if (in_array($new_instance['order_by'], array('post_title', 'menu_order', 'ID'))) {
			$instance['order_by'] = $new_instance['order_by'];
		}
		$instance['show_siblings'] = $new_instance['show_siblings'];

		return $instance;
	}

	function form($instance) {
		$defaults = array('order_by'=>'post_title', 'title'=>'', 'show_siblings'=>'0');
		$instance = wp_parse_args((array) $instance, $defaults);
		$title = esc_attr($instance['title']);
		$show_siblings = $instance['show_siblings'];
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('order_by'); ?>"><?php _e('Sort by:'); ?></label>
			<select name="<?php echo $this->get_field_name('order_by'); ?>" id="<?php echo $this->get_field_id('order_by'); ?>" class="widefat">
				<option value="post_title" <?php selected($instance['order_by'], 'post_title'); ?>><?php _e('Page title'); ?></option>
				<option value="menu_order" <?php selected($instance['order_by'], 'menu_order'); ?>><?php _e('Page order'); ?></option>
				<option value="ID" <?php selected($instance['order_by'], 'ID'); ?>><?php _e('Page ID'); ?></option>
			</select>
		</p>
		<p>
			<input type="hidden" name="<?php echo $this->get_field_name('show_siblings'); ?>" value="0" />
			<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('show_siblings'); ?>" name="<?php echo $this->get_field_name('show_siblings'); ?>" <?php checked($show_siblings); ?> value="1" />
			<label for="<?php echo $this->get_field_id('show_siblings'); ?>"><?php wTheme::_e('Show page siblings if no childrens'); ?></label>
		</p>
		<?php
	}
}

class wTheme_Widget_Google_Map extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_google_map', 'description' => wTheme::__('Your location on the google map'));
		parent::__construct(wTheme::prefix('google_map'), wTheme::__('Google Map'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
		$latitude = empty($instance['latitude']) ? '' : $instance['latitude'];
		$longitude = empty($instance['longitude']) ? '' : $instance['longitude'];
		$zoom = empty($instance['zoom']) ? '' : $instance['zoom'];
		$info_window_title = empty($instance['info_window_title']) ? '' : $instance['info_window_title'];
		$info_window_description = empty($instance['info_window_description']) ? '' : $instance['info_window_description'];
		$info_window_width = empty($instance['info_window_width']) ? '' : $instance['info_window_width'];
		$info_window_height = empty($instance['info_window_height']) ? '' : $instance['info_window_height'];

		$api_key = wThemeSettings::get_option('Integrations.GoogleMaps.api_key');
		$map_params = array('v'=>'3.exp');
		if (!empty($api_key))
			$map_params['key'] = $api_key;
		$api_map_url = add_query_arg($map_params, 'https://maps.googleapis.com/maps/api/js?');

		if (!empty($latitude) && !empty($longitude)) {
			echo $before_widget;
			if (!empty($title)) {
				echo $before_title . $title . $after_title;
			}
			//todo send json for widget and init via widget id
			?>
			<div class="map"></div>
			<script src="<?php echo $api_map_url; ?>"></script>
			<script>
				jQuery(window).load(function(){
					function initialize() {
						var myLatlng = new google.maps.LatLng(<?php echo $latitude.', '.$longitude; ?>);
						var mapOptions = {
							zoom: <?php echo $zoom; ?>,
							center: myLatlng
						};

						var map = new google.maps.Map(jQuery('#<?php echo $widget_id; ?> .map').get(0), mapOptions);

						<?php if (!empty($info_window_width)) $info_window_width = 'style="width: '.$info_window_width.'px;"'; ?>
						<?php if (!empty($info_window_height)) $info_window_height = 'style="height: '.$info_window_height.'px;"'; ?>

						var contentString = '<div class="info_window" <?php echo $info_window_width; ?>>'+
							'<h1><?php echo $info_window_title; ?></h1>'+
							'<div <?php echo $info_window_height; ?>>'+
							'<?php echo $info_window_description; ?>'+
							'</div>'+
							'</div>';

						var infowindow = new google.maps.InfoWindow({
							content: contentString
						});

						var marker = new google.maps.Marker({
							position: myLatlng,
							map: map,
							title: '<?php echo $info_window_title; ?>'
						});

						<?php if (!empty($info_window_title)) { ?>
							google.maps.event.addListener(marker, 'click', function() {
								infowindow.open(map, marker);
							});
						<?php } ?>

					}

					initialize();
				});
			</script>
			<?php
			echo $after_widget;
		}
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['latitude'] = strip_tags($new_instance['latitude']);
		$instance['longitude'] = strip_tags($new_instance['longitude']);
		$instance['zoom'] = strip_tags($new_instance['zoom']);
		$instance['info_window_title'] = strip_tags($new_instance['info_window_title']);
		$instance['info_window_description'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['info_window_description'])));
		$instance['info_window_width'] = strip_tags($new_instance['info_window_width']);
		$instance['info_window_height'] = strip_tags($new_instance['info_window_height']);
		return $instance;
	}

	function form($instance) {
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'latitude' => '',
			'longitude' => '',
			'zoom' => '14',
			'info_window_title' => '',
			'info_window_description' => '',
			'info_window_width' => '',
			'info_window_height' => ''
		));
		$title = $instance['title'];
		$latitude = $instance['latitude'];
		$longitude = $instance['longitude'];
		$zoom = $instance['zoom'];
		$info_window_title = $instance['info_window_title'];
		$info_window_description = $instance['info_window_description'];
		$info_window_width = $instance['info_window_width'];
		$info_window_height = $instance['info_window_height'];
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<div style="overflow: hidden">
			<p style="float: left; width: 34%; margin: 0;">
				<label for="<?php echo $this->get_field_id('latitude'); ?>"><?php wTheme::_e('Latitude'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('latitude'); ?>" name="<?php echo $this->get_field_name('latitude'); ?>" type="text" value="<?php echo esc_attr($latitude); ?>" />
			</p>
			<p style="float: left; width: 34%; margin: 0 0 0 6%;">
				<label for="<?php echo $this->get_field_id('longitude'); ?>"><?php wTheme::_e('Longitude'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('longitude'); ?>" name="<?php echo $this->get_field_name('longitude'); ?>" type="text" value="<?php echo esc_attr($longitude); ?>" />
			</p>
			<p style="float: right; width: 20%; margin: 0;">
				<label for="<?php echo $this->get_field_id('zoom'); ?>"><?php wTheme::_e('Zoom'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('zoom'); ?>" name="<?php echo $this->get_field_name('zoom'); ?>" type="number" min="1" max="20" value="<?php echo esc_attr($zoom); ?>" />
			</p>
		</div>
		<p>
			<label for="<?php echo $this->get_field_id('info_window_title'); ?>"><?php wTheme::_e('Info window title'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('info_window_title'); ?>" name="<?php echo $this->get_field_name('info_window_title'); ?>" type="text" value="<?php echo esc_attr($info_window_title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('info_window_description'); ?>"><?php wTheme::_e('Info window description'); ?>:</label>
			<textarea class="widefat" rows="5" cols="20" id="<?php echo $this->get_field_id('info_window_description'); ?>" name="<?php echo $this->get_field_name('info_window_description'); ?>"><?php echo esc_textarea($info_window_description); ?></textarea>
		</p>
		<div style="overflow: hidden">
			<p style="float: left; width: 47%; margin: 0;">
				<label for="<?php echo $this->get_field_id('info_window_width'); ?>"><?php wTheme::_e('Info window width'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('info_window_width'); ?>" name="<?php echo $this->get_field_name('info_window_width'); ?>" type="number" min="0" value="<?php echo esc_attr($info_window_width); ?>" />
			</p>
			<p style="float: right; width: 47%; margin: 0;">
				<label for="<?php echo $this->get_field_id('info_window_height'); ?>"><?php wTheme::_e('Info window height'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('info_window_height'); ?>" name="<?php echo $this->get_field_name('info_window_height'); ?>" type="number" min="0" value="<?php echo esc_attr($info_window_height); ?>" />
			</p>
		</div>
		<?php
	}
}

class wTheme_Widget_Featured_Text extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_featured_text',
			'description' => wTheme::__('This widget can display text, image and link to pages you want to promote.'),
		);
		parent::__construct(wTheme::prefix('featured_text'), wTheme::__('Featured text'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
		$text = apply_filters('widget_text', empty($instance['text']) ? '' : $instance['text'], $instance);
		$img = wp_get_attachment_image($instance['attachment_id'], $instance['image_size']);

		echo $before_widget;
		if (!empty($title))
			echo $before_title.$title.$after_title;
		if ($img)
			echo '<div class="img_wrap"><div>'.$img.'</div></div>';
		?>
			<div class="textwidget"><?php echo !empty($instance['filter']) ? wpautop($text) : $text; ?></div>
		<?php
		if ('' != $instance['link_url']) {
			if ('' != $instance['link_text'])
				echo '<a href="'.$instance['link_url'].'" class="read_more">'.$instance['link_text'].'</a>';
			if ($instance['is_full_link'])
				echo '<a href="'.$instance['link_url'].'" class="full_link"></a>';
		}
		echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['attachment_id'] = intval($new_instance['attachment_id']);
		$instance['image_size'] = $new_instance['image_size'];
		if (current_user_can('unfiltered_html'))
			$instance['text'] =  $new_instance['text'];
		else
			$instance['text'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['text'])));
		$instance['filter'] = ! empty($new_instance['filter']);
		$instance['link_url'] = strip_tags($new_instance['link_url']);
		$instance['link_text'] = $new_instance['link_text'];
		$instance['is_full_link'] = (boolean) intval($new_instance['is_full_link']);
		return $instance;
	}

	function form($instance) {
		global $_wp_additional_image_sizes;

		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'attachment_id' => '',
			'image_size' => 'thumbnail',
			'text' => '',
			'link_url' => '',
			'link_text' => wTheme::__('Read more'),
			'is_full_link' => '1',
		));

		$image_sizes = array();
		$all_image_sizes = apply_filters('image_size_names_choose', array('full' => wTheme::__('Full size')));
		foreach($all_image_sizes as $size=>$label) {
			if (in_array($size, array('thumbnail', 'medium', 'large'))) {
				$width = get_option($size.'_size_w');
				$height = get_option($size.'_size_h');
				$image_sizes[$size] = "{$label} {$width} x {$height}";
			} else if (isset($_wp_additional_image_sizes[$size])) {
				$width = $_wp_additional_image_sizes[$size]['width'];
				$height = $_wp_additional_image_sizes[$size]['height'];
				$image_sizes[$size] = "{$label} {$width} x {$height}";
			} else if ('full' == $size) {
				$image_sizes[$size] = $label;
			}
		}

		$attachment_field_id = $this->get_field_id('attachment_id');
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<?php echo wTheme::get_media_popup_field($this->get_field_name('attachment_id'), @$instance['attachment_id'], wTheme::__('Image').':', array('id'=>$attachment_field_id)); ?>
		<?php if ('__i__' == $this->number) { //@hack after add new widget media dont init ?>
			<span class="widget_number_after_drop" rel="__i__" style="display: none;"></span>
			<script>
				jQuery(function() {
					var attachment_field_id = '<?php echo $attachment_field_id; ?>';
					var $span = jQuery('.widget-liquid-right .widget_number_after_drop');
					var widget_number = $span.attr('rel');
					if (widget_number && '__i__' != widget_number) {
						attachment_field_id = attachment_field_id.replace('__i__', widget_number);
						wtheme_media_popup_attachment_button(jQuery('#'+attachment_field_id+' .button-set'), jQuery('#'+attachment_field_id+' .button-remove'));
						$span.remove();
					}
				});
			</script>
		<?php } ?>
		<p>
			<label for="<?php echo $this->get_field_id('image_size'); ?>"><?php wTheme::_e('Image size'); ?>:</label>
			<select name="<?php echo $this->get_field_name('image_size'); ?>" id="<?php echo $this->get_field_id('image_size'); ?>">
				<?php foreach ($image_sizes as $k=>$label) { ?>
				<option value="<?php echo $k; ?>" <?php selected($instance['image_size'], $k); ?>><?php echo $label; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('text'); ?>"><?php wTheme::_e('Content'); ?>:</label>
			<textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo esc_textarea($instance['text']); ?></textarea>
		</p>
		<p><input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php _e('Automatically add paragraphs'); ?></label></p>
		<p>
			<label for="<?php echo $this->get_field_id('link_url'); ?>"><?php wTheme::_e('Link url'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('link_url'); ?>" name="<?php echo $this->get_field_name('link_url'); ?>" type="text" value="<?php echo esc_attr($instance['link_url']); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('link_text'); ?>"><?php wTheme::_e('Link text'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('link_text'); ?>" name="<?php echo $this->get_field_name('link_text'); ?>" type="text" value="<?php echo esc_attr($instance['link_text']); ?>" />
		</p>
		<p>
			<input type="hidden" name="<?php echo $this->get_field_name('is_full_link'); ?>" value="0" />
			<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('is_full_link'); ?>" name="<?php echo $this->get_field_name('is_full_link'); ?>" <?php checked(@$instance['is_full_link']); ?> value="1" />
			<label for="<?php echo $this->get_field_id('is_full_link'); ?>"><?php wTheme::_e('Make full box link'); ?></label>
		</p>
		<?php
	}
}

//widget with wpml plugin integration
class wTheme_Widget_Featured_Text_Icl extends wTheme_Widget_Featured_Text {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_featured_text_icl',
			'description' => wTheme::__('This widget can display text, image and link to pages you want to promote.'),
		);
		WP_Widget::__construct(wTheme::prefix('widget_featured_text_icl'), wTheme::__('Multi language featured text'), $widget_ops);
	}

	function widget($args, $instance) {
		if ($instance['icl_language'] != 'multilingual' && $instance['icl_language'] != ICL_LANGUAGE_CODE)
			return;
		parent::widget($args, $instance);
	}

	function update($new_instance, $old_instance) {
		$old_instance = parent::update($new_instance, $old_instance);
		$instance = $old_instance;

		if ($new_instance['icl_language'] == 'multilingual') {
			global $wpdb;
			$string = $wpdb->get_row($wpdb->prepare("SELECT id, value, status FROM {$wpdb->prefix}icl_strings WHERE context=%s AND name=%s", 'Widgets', 'widget body - ' . $this->id));
			if ($string) {
				icl_st_update_string_actions('Widgets', 'widget body - ' . $this->id, $old_instance['text'], $instance['text']);
			} else {
				icl_register_string('Widgets', 'widget body - ' . $this->id, $instance['text']);
			}
		}
		$instance['icl_language'] = $new_instance['icl_language'];
		return $instance;
	}

	function form($instance) {
		parent::form($instance);
		$instance = wp_parse_args((array) $instance, array(
			'icl_language' => 'multilingual',
		));
		$language = $instance['icl_language'];
		?>
		<p><?php icl_widget_text_language_selectbox($language, $this->get_field_name('icl_language')); ?></p>
		<?php
	}
}

class wTheme_Widget_Title_Anchors extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_title_anchors',
			'description' => wTheme::__('This widget can display links to h2 tags in content.'),
		);
		parent::__construct(wTheme::prefix('title_anchors'), wTheme::__('Title anchors'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		$title = empty($instance['title']) ? '' : $instance['title'];

		echo $before_widget;
		if (!empty($title))
			echo $before_title.$title.$after_title;
		?>
		<div class="textwidget">
			<ul class="list_links">
			</ul>
		</div>
		<?php
		echo $after_widget;
	}

	function form($instance) {
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
		));
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<?php
	}
}

class wTheme_Widget_Recent_Posts extends WP_Widget_Recent_Posts {

	function __construct() {
		$widget_ops = array('classname' => 'recent_posts', 'description' => __("The most recent posts on your site"));
		WP_Widget::__construct('recent-posts', __('Recent Posts'), $widget_ops);
		$this->alt_option_name = 'widget_recent_entries';
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_recent_posts', 'widget');

		if (!is_array($cache))
			$cache = array();

		if (! isset($args['widget_id']))
			$args['widget_id'] = $this->id;

		if (isset($cache[ $args['widget_id'] ])) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? __('Recent Posts') : $instance['title'], $instance, $this->id_base);
		if (empty($instance['number']) || ! $number = absint($instance['number']))
			$number = 10;
		$show_date = isset($instance['show_date']) ? $instance['show_date'] : false;
		$show_thumbnails = isset($instance['show_thumbnails']) ? $instance['show_thumbnails'] : false;

		$r = new WP_Query(apply_filters('widget_posts_args', array('posts_per_page' => $number, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true)));
		if ($r->have_posts()) {
			?>
			<?php echo $before_widget; ?>
			<?php if ($title) echo $before_title . $title . $after_title; ?>
			<?php
			$title_chars = 40;
			?>
			<div class="textwidget">
				<?php while ($r->have_posts()) { $r->the_post(); ?>
					<div class="post">
						<?php if ($show_thumbnails) { ?>
							<a class="post_thumb" href="<?php the_permalink() ?>">
								<?php if (has_post_thumbnail()) { ?>
									<?php the_post_thumbnail(wTheme::prefix('post_thumb_widget')); ?>
								<?php } ?>
							</a>
						<?php } ?>
						<div class="wrap">
							<h6><a href="<?php the_permalink() ?>"><?php echo wTheme::truncate(get_the_title(), $title_chars); ?></a></h6>
							<?php if ($show_date) { ?>
								<time datetime="<?php echo get_the_date('Y-m-d'); ?>"><?php echo get_the_date('d. F Y'); ?></time>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>
			<?php echo $after_widget; ?>
			<?php
			// Reset the global $the_post as this query will have stomped on it
			wp_reset_postdata();
		}

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_recent_posts', $cache, 'widget');
	}

	function form($instance) {
		parent::form($instance);
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'show_thumbnails' => false
		));
		$show_thumbnails = $instance['show_thumbnails'];
		?>
		<p>
			<input class="checkbox" type="checkbox"<?php checked($show_thumbnails); ?> id="<?php echo $this->get_field_id('show_thumbnails'); ?>" name="<?php echo $this->get_field_name('show_thumbnails'); ?>" />
			<label for="<?php echo $this->get_field_id('show_thumbnails'); ?>"><?php _e('Display thumbnails'); ?></label>
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = parent::update($new_instance, $old_instance);
		$instance['show_thumbnails'] = isset($new_instance['show_thumbnails']);
		return $instance;
	}
}

class wTheme_Widget_Categories_list extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_categories_list_custom',
			'description' => wTheme::__('A custom list of categories.'),
		);
		parent::__construct(wTheme::prefix('categories_list'), wTheme::__('Categories custom'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

		echo $before_widget;
		?>
		<?php if ($title) echo $before_title . $title . $after_title; ?>
		<ul class="categories">
			<?php
			$categories = get_categories(
				array(
					'parent' => 0,
					'hide_empty' => 0,
				)
			);
			foreach ($categories as $cat) { 
				if (in_array($cat->slug, array('diverse', 'ikke-kategoriseret', 'uncategorized')))
					continue;
			?>
				<li class="category	<?php if ($cat->cat_ID == get_queried_object_id()) echo 'current_cat'; if (get_queried_object()->parent == $cat->cat_ID) echo 'current_cat_ancestor' ?>">
					<a href="<?php echo get_category_link($cat->term_id); ?>"><?php echo $cat->name; ?></a>
					<?php
					$sub_categories = get_categories(
						array(
							'parent' => $cat->cat_ID,
							'hide_empty' => false
						)
					);
					if (!empty($sub_categories)) {
						echo '<ul class="sub-category">';
						foreach ($sub_categories as $sub_cat) {
							?>
							<li class="category sub-category <?php if ($sub_cat->cat_ID == get_queried_object_id()) echo 'current_cat'; ?>">
								<a href="<?php echo get_category_link($sub_cat->term_id); ?>"><?php echo $sub_cat->name; ?></a>
							</li>
							<?php
						}
						echo '</ul>';
					}
					?>
				</li>
			<?php }
			?>
		</ul>
		<script>
			jQuery(function() {
				jQuery('.widget_categories_list_custom .widget_link').click(function() {
					jQuery(this).parent().toggleClass('open');
					jQuery(this).next().stop(true, true).slideToggle(300);
					return false;
				});
			});
		</script>
		<?php
		echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		return $instance;
	}

	function form($instance) {
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
		));
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<?php
	}
}

class wTheme_Widget_Top_New_posts extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_top_new_posts',
			'description' => wTheme::__('List popular/new posts'),
		);
		parent::__construct(wTheme::prefix('top_new_posts'), wTheme::__('Top/New posts list'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		echo $before_widget;
		?>
		<div class="widget_title">
			<a class="open" id="tab1" href="#"><?php wTheme::_e('Popular news') ?></a>
			<a id="tab2" href="#"><?php wTheme::_e('New') ?></a>
		</div>
		<div class="posts_lists">
			<div class="top tab1 open">
				<?php
				$popular_posts_args = array(
					'meta_key' => 'post_views_count',
					'orderby' => 'meta_value_num',
					'posts_per_page' => 3
				);
				$popular_posts = new WP_Query($popular_posts_args);
				if ($popular_posts->have_posts()) {
					echo '<div>';
					while ($popular_posts->have_posts()) {
						$popular_posts->the_post();
						echo wTheme::part('content_widget');
					}
					echo '</div>';
				}
				?>
			</div>
			<div class="new tab2">
				<?php
				$latest_news_args = array(
					'posts_per_page' => 3
				);
				$latest_news = new WP_Query($latest_news_args);
				if ($latest_news->have_posts()) {
					echo '<div>';
					while ($latest_news->have_posts()) {
						$latest_news->the_post();
						echo wTheme::part('content_widget');
					}
					echo '</div>';
				}
				?>
			</div>
		</div>
		<script>
			jQuery(function() {
				jQuery('.widget_top_new_posts .widget_title a').click(function() {
					jQuery('.widget_top_new_posts .widget_title a').removeClass('open');
					jQuery(this).addClass('open');
					jQuery('.widget_top_new_posts .posts_lists > div').removeClass('open');
					jQuery('.widget_top_new_posts .posts_lists > div.'+jQuery(this).attr('id')).addClass('open');
					return false;
				});
			});
		</script>
		<?php
		echo $after_widget;
	}

}

class wTheme_Widget_Same_Category_Posts extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_same_category_posts',
			'description' => wTheme::__('A list same category posts.'),
		);
		parent::__construct(wTheme::prefix('same_category_posts'), wTheme::__('Same category posts'), $widget_ops);
	}

	function widget($args, $instance) {
		if (! isset($args['widget_id']))
			$args['widget_id'] = $this->id;

		ob_start();
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? __('Same category posts') : $instance['title'], $instance, $this->id_base);
		if (empty($instance['number']) || ! $number = absint($instance['number']))
			$number = 10;
		$show_date = isset($instance['show_date']) ? $instance['show_date'] : false;
		$show_thumbnails = isset($instance['show_thumbnails']) ? $instance['show_thumbnails'] : false;

		$postcat = wp_get_post_categories(get_the_ID());
		$r = new WP_Query(apply_filters('widget_posts_args',
			array(
				'cat' => $postcat,
				'posts_per_page' => $number,
				'no_found_rows' => true,
				'post_status' => 'publish',
				'ignore_sticky_posts' => true
			)
		));
		if ($r->have_posts()) {
			?>
			<?php echo $before_widget; ?>
			<?php if ($title) echo $before_title . $title . $after_title; ?>
			<div class="textwidget">
				<?php
					$title_chars = 40;
				?>
				<?php while ($r->have_posts()) { $r->the_post(); ?>
					<div class="post">
						<?php if ($show_thumbnails) { ?>
							<a class="post_thumb" href="<?php the_permalink() ?>">
								<?php if (has_post_thumbnail()) { ?>
									<?php the_post_thumbnail(wTheme::prefix('post_thumb_widget')); ?>
								<?php } ?>
							</a>
						<?php } ?>
						<div class="wrap">
							<h6><a href="<?php the_permalink() ?>"><?php echo wTheme::truncate(get_the_title(), $title_chars); ?></a></h6>
							<?php if ($show_date) { ?>
								<time datetime="<?php echo get_the_date('Y-m-d'); ?>"><?php echo get_the_date('d. F Y'); ?></time>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>
			<?php echo $after_widget; ?>
			<?php
			// Reset the global $the_post as this query will have stomped on it
			wp_reset_postdata();
		}
	}

	function form($instance) {
		parent::form($instance);
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'show_thumbnails' => false
		));
		$show_thumbnails = $instance['show_thumbnails'];
		$title     = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number    = isset($instance['number']) ? absint($instance['number']) : 5;
		$show_date = isset($instance['show_date']) ? (bool) $instance['show_date'] : false;
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of posts to show:'); ?></label>
			<input class="tiny-text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" /></p>

		<p><input class="checkbox" type="checkbox"<?php checked($show_date); ?> id="<?php echo $this->get_field_id('show_date'); ?>" name="<?php echo $this->get_field_name('show_date'); ?>" />
			<label for="<?php echo $this->get_field_id('show_date'); ?>"><?php _e('Display post date?'); ?></label></p>
		<p>
			<input class="checkbox" type="checkbox"<?php checked($show_thumbnails); ?> id="<?php echo $this->get_field_id('show_thumbnails'); ?>" name="<?php echo $this->get_field_name('show_thumbnails'); ?>" />
			<label for="<?php echo $this->get_field_id('show_thumbnails'); ?>"><?php _e('Display thumbnails'); ?></label>
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = parent::update($new_instance, $old_instance);
		$instance['show_thumbnails'] = isset($new_instance['show_thumbnails']);
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_date'] = isset($new_instance['show_date']) ? (bool) $new_instance['show_date'] : false;
		return $instance;
	}
}
