<?php

class wTestimonial extends wCustomPostType {

	static $post_type = '';

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Testimonial', 'Testimonials');
	}

	function register_post_type($args = array()) {
		parent::register_post_type(
			array(
				'public' => false,
				'supports' => array('title', 'editor', 'page-attributes'),
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box_additional_fields'), $this->post_type(), 'side', 'low');
	}

	function meta_box_additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<?php $field = 'job_title'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Job title'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'rating'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Rating'); ?></label><br />
			<input type="number" step="1" min="0" max="5" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="small-text" />
		</p>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

	private static function get_post_type() {
		return static::$post_type;
	}

	static function wp_query($args = array(), $settings = array()) {
		if (!isset($args['post_type'])) {
			$post_type = static::get_post_type();
		} else {
			$post_type = $args['post_type'];
		}

		$defaults = array(
			'post_type' => $post_type,
			'post_status' => 'publish',
			'posts_per_page' => -1,
		);

		$supports = get_all_post_type_supports($post_type);
		if (@$supports['page-attributes']) {
			$defaults['orderby'] = array('menu_order'=>'ASC', 'title' => 'ASC');
		}

		if (@$settings['use_pagination']) {
			$paged = get_query_var('paged');
			if (!empty($paged)) {
				$args['paged'] = $paged;
			}
		}

		$args = wp_parse_args($args, $defaults);
		return new WP_Query($args);
	}

}
