<?php

class wSchema {

	static $context = "https://schema.org/";

	static $options = '';

	static function construct() {
		$themeSettings = wThemeSettings::get_option('Schema');

		if (empty($themeSettings['is_show_schema']))
			return;

		if (class_exists('WPSEO_Schema'))
			add_filter('wpseo_json_ld_output', '__return_false');

		add_action('wp_head', [__CLASS__, 'action__wp_head']);

		self::$options = $themeSettings;
	}

	static function format_json_encode($data) {
		$flags = 0;
		if (version_compare( PHP_VERSION, '5.4', '>=')) {
			$flags = ($flags | JSON_UNESCAPED_SLASHES);
		}
		return wp_json_encode($data, $flags);
	}

	static function action__wp_head() {
		echo self::generateJSON();
	}

	static function generateJSON() {
		$schema = [
			"@context" => self::$context,
		];
		$data []= self::getWebSite();
		$data []= self::getWPHeader();
		$data []= self::getWPFooter();

		if (is_singular('post'))
			$data []= self::getArticleMarkup();

		if (is_front_page()) {
			$data []= self::getOrganizationMarkup();
		}

		if (is_page_template('page-templates/about.php')) {
			$data []= self::getOrganizationMarkupExtend();
		}

		if (is_singular('post')) {
			if (!empty(self::getProductMarkup(get_the_ID())))
				$data []= self::getProductMarkup(get_the_ID());
		}

		$schema["@graph"] = $data;

		return "<script type='application/ld+json'>".self::format_json_encode($schema)."</script>";
	}

	static function getWPHeader() {
		return [
			"@type" => "WPHeader",
			'@id' => home_url('#site_header'),
		];
	}

	static function getWPFooter() {
		return [
			"@type" => "WPFooter",
			'@id' => home_url('#site_footer'),
		];
	}

	static function getWebSite() {
	    return [
			"@type" => 'WebSite',
			"name" => get_bloginfo('name'),
			"url" => home_url(),
		    '@id' => home_url('#website')
		];
	}

	static function getOrganizationMarkup() {
		$options = self::$options['Organization'];
		$args = [
			"@type" => "Organization",
			"name" => get_bloginfo('name'),
			"logo" => [
  				"@type" => "ImageObject",
				'@id' => home_url().'#logo',
  				"url" => get_template_directory_uri().'/images/logo.png',
  				"name" => get_bloginfo('name'),
			],
			"url" => home_url(),
			'@id' => home_url().'#organization',
		];

		if (!empty($options['description']))
			$args["description"] = $options['description'];

		if (!empty($options['addressLocality']) && !empty($options['postalCode']) && !empty($options['streetAddress'])) {
			$args["address"] = [
				"@type" => "PostalAddress",
				"addressLocality" => $options['addressLocality'],
				"postalCode" => $options['postalCode'],
				"streetAddress" => $options['streetAddress']
			];
		}

		if (!empty($options['phone']))
			$args["telephone"] = $options['phone'];

		$brands = [];
		if (!empty($options['brand']))
			$brands []= $options['brand'];

		$args["brand"] = $brands;

		if (!empty($options['legal_name']))
			$args["legalName"] = $options['legal_name']?$options['legal_name']:get_bloginfo('name');

		if (!empty($options['alternate_name']))
			$args["alternateName"] = $options['alternate_name']?$options['alternate_name']:get_bloginfo('name');

		if (!empty($options['vat_id']))
			$args["vatID"] = $options['vat_id'];

		if (!empty($options['email']))
			$args["email"] = $options['email'];

		if (!empty($options['facebook']) && !empty($options['linkedin'])) {
			$args["sameAs"] = [
				$options['facebook'],
				$options['linkedin']
			];
		}

		return $args;
	}

	static function getOrganizationMarkupExtend() {
		$options = self::$options['Organization'];
		$founderOptions = self::$options['Founder'];

		$args = self::getOrganizationMarkup();

		if (!empty($options['foundingDate']))
			$args["foundingDate"] = $options['foundingDate'];

		if (!empty($options['awards']))
			$args["awards"] = $options['awards'];

		$founder = [
			"@type" => "Person",
		];

		if (!empty($founderOptions['image_id']))
			$founder['image'] = wp_get_attachment_url($founderOptions['image_id']);

		if (!empty($founderOptions['job_title']))
			$founder['jobTitle'] = $founderOptions['job_title'];

		if ('' !== $founderOptions['description'])
			$founder['description'] = $founderOptions['description'];

		if (!empty($founderOptions['phone']))
			$founder['telephone'] = $founderOptions['phone'];

		if (!empty($founderOptions['email']))
			$founder['email'] = $founderOptions['email'];

		if (!empty($founderOptions['knows_about']))
			$founder['knowsAbout'] = $founderOptions['knows_about'];

		if (!empty($founderOptions['given_name']))
			$founder['givenName'] = $founderOptions['given_name'];

		if (!empty($founderOptions['family_name']))
			$founder['familyName'] = $founderOptions['family_name'];

		if (!empty($founderOptions['additional_name']))
			$founder['additionalName'] = $founderOptions['additional_name'];

		if (!empty($founderOptions['gender']))
			$founder['gender'] = $founderOptions['gender'];

		if (!empty($founderOptions['linkedinUrl']))
			$founder['sameAs'] = $founderOptions['linkedinUrl'];

		if (!empty($founder))
			$args['founder'] = $founder;

		return $args;
	}

	static function getProductMarkup($id) {
		if (!isset($id))
			return [];

		$meta = wPost::get_all_meta($id, true);
		$meta = @$meta['product_schema_settings'];
		$isShowSchema = @$meta['use_product_schema'];
		$price = @$meta['price'];
		if (empty($isShowSchema) && empty($price))
			return [];

		$productImage = @$meta['product_image'];
		$productName = @$meta['product_name'];
		$productDescription = @$meta['product_description'];
		$productSKU = @$meta['product_sku'];
		$brand = @$meta['brand'];

		$args = [
			"@type" => "Product",
			'@id' => get_permalink($id)."#product-{$id}",
			"name" => $productName?$productName:get_the_title($id),
			"description" => $productDescription?$productDescription:'',
			"offers" => [
				"@type" => "Offer",
				"url" => get_the_permalink(),
				"availability" => "InStock",
				"price" => $price,
				"priceCurrency" => "DKK",
			]
		];

		if (!empty($productImage))
			$args["image"] = wp_get_attachment_url($productImage);

		if (!empty($productSKU))
			$args["sku"] = $productSKU;

		if (!empty($brand))
			$args["brand"] = $brand;


		$rating = $reviewItems = [];

		if (!empty($meta['review'])) {
			foreach ($meta['review'] as $review) {
				$rating []= (int) $review['rating'];
				$reviewItems []= [
					"@type" => "Review",
					"reviewBody" => $review['description'],
					"author" => [
						"@type" => "Person",
						"name" => $review['author_name'],
						"sameAs" => home_url()
					],
					"publisher" => self::getOrganizationMarkup(),
					"datePublished" => $review['date'],
					"reviewRating" => [
						"@type" => "Rating",
						"worstRating" => 0,
						"bestRating" => 5,
						"ratingValue" => (int) $review['rating']
					]
				];
			}
			$args["review"] = $reviewItems;
		}

		if (!empty($rating)) {
			$ratingValue = array_sum($rating)/count($rating);
			$args['aggregateRating'] = [
				"@type" => "AggregateRating",
				"worstRating" => "0",
				"bestRating" => "5",
				"ratingCount" => count($rating),
				"ratingValue" => $ratingValue
			];
		}

		return $args;
	}

	static function getArticleMarkup($post_id = null) {
		$postThumbnail = get_the_post_thumbnail_url();
		$idUrl = get_permalink($post_id);
		$args = [
			"@type" => "Article",
			'@id' => $idUrl.'#article',
			"mainEntityOfPage" => [
				"@type" => "WebPage",
				"@id" => $idUrl.'#webpage',
			],
			"name" => get_the_title(),
			"headline" => get_the_title(),
			"datePublished" => get_the_date('Y-m-d H:i'),
			"dateModified" => get_the_modified_date('c'),
			"image" => $postThumbnail?$postThumbnail:'',
			"inLanguage" => "Danish",
			"author" => [
				"name" => get_the_author()
			],
			"publisher" => self::getOrganizationMarkup()
		];

		return $args;
	}

}

wSchema::construct();