<?php

class wProduct extends wCustomPostType {

	static $post_type = '';

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Product', 'Products');
	}

	function register_post_type($args = array()) {
		parent::register_post_type(
			array(
				'public' => false,
				'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
				'exclude_from_search' => true,
				'publicly_queryable' => false,
				'rewrite' => false,
				'query_var' => false,
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box_additional_fields'), $this->post_type(), 'side', 'low');
		add_meta_box(wTheme::prefix('rating'), wTheme::__('Rating'), array($this, 'meta_box_rating'), $this->post_type(), 'side', 'low');
	}

	function meta_box_additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<?php for ($i = 1; $i <= 3; $i++) { ?>
			<p>
				<?php $field = "bullet_{$i}"; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Bullet'); ?> <?= $i ?></label><br />
				<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
			</p>
		<?php } ?>
		<p>
			<?php $field = 'price'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Price'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'members'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Members'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'external_link'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('External link'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'read_more'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Read more button label '); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'review_link'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Review link'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'review_label'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Review label'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
		$this->save_meta_data($post_id, wTheme::prefix('rating'));
	}

	function meta_box_rating($post) {
		$meta_key = wTheme::prefix('rating');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<?php $field = 'rating'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Rating'); ?></label><br />
			<input type="number" step="0.1" min="0" max="5" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="small-text" />
		</p>
		<?php
	}

	static function get_rate_format($rate) {
		return number_format($rate, 2, ',', '.');
	}
}
