<?php
/**
 * Version 1.19
 */
class wOptimization {

	protected static $isAdmin;
	protected static $userAgent;
	protected static $isIe8;
	protected static $isIe9;
	protected static $httpClientUserAgent = 'wOptimization';

	public static $isEnabled = false;
	public static $pixel = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';

	public static function construct() {
		static::$isAdmin = is_admin();
		static::$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
		static::$isIe8 = false !== strpos(static::$userAgent, 'MSIE 8');
		static::$isIe9 = false !== strpos(static::$userAgent, 'MSIE 9');

		if (static::$isAdmin)
			return;

		add_action('init', [__CLASS__, 'action__init']);
		add_action('wp_head', [__CLASS__, 'action__wp_head__all'], 1);
		add_filter('nav_menu_item_id', '__return_null');
		add_filter('nav_menu_css_class', [__CLASS__, 'filter__nav_menu_css_class'], 10, 2);
		add_filter('w3tc_footer_comment', '__return_empty_array');

		if (static::$isIe8 || static::$httpClientUserAgent === static::$userAgent)
			return;

		static::$isEnabled = true;

		add_filter('template_include',  [__CLASS__, 'filter__template_include']);
		add_filter('wp_headers', [__CLASS__, 'filter__wp_headers']);
		add_filter('script_loader_tag', [__CLASS__, 'filter__script_loader_tag'], 9999, 3);
		add_filter('style_loader_tag', [__CLASS__, 'filter__style_loader_tag'], 9999, 4);
		add_filter('wtheme_template_include', [__CLASS__, 'filter__wtheme_template_include'], 9999);
		add_action('wpcf7_enqueue_scripts', [__CLASS__, 'action__wpcf7_enqueue_scripts']);
	}

	public static function filter__wp_headers($headers) {
		$headers['X-FRAME-OPTIONS'] = 'sameorigin';
		$headers['X-XSS-Protection'] = '1; mode=block';
		return $headers;
	}

	public static function filter__template_include($template) {
		$suffix = SCRIPT_DEBUG ? '' : '.min';
		wp_enqueue_script(wTheme::prefix('optimization'), get_template_directory_uri()."/js/optimization{$suffix}.js");
		return $template;
	}

	public static function action__init() {
		global $wp_scripts;
		$wp_scripts->registered['jquery']->deps = array_diff($wp_scripts->registered['jquery']->deps, ['jquery-migrate']);
		static::disable_emoji();
	}

	public static function action__wp_head__all() {
		?>
		<script>
			function jQuery(cb) { var d=document; !d.addEventListener ? setTimeout(cb,1) : d.addEventListener('DOMContentLoaded', function(){cb(jQuery)}); }
			function wLoad(cb) { var w=window; !w.addEventListener||document.readyState==='complete' ? setTimeout(cb,1) : w.addEventListener('load', cb); }
			function wLoadDelayed(cb, timeout) { wLoad(function () {setTimeout(cb, timeout?timeout:3000)}); }
			function wLoadScript(url) { var d=document,e=d.createElement('script');e.src=url;e.defer=1;e.async=0;d.getElementsByTagName('head')[0].appendChild(e); }
		</script>
		<noscript><style>img[lazy] { display:none !important; }</style></noscript>
		<?php
	}

	public static function filter__script_loader_tag($tag, $handle, $url) {
		$tag = str_replace([" type='text/javascript'", " id='{$handle}-js'"], '', $tag);
		if (static::$isIe9) return $tag; //IE 9 has bugs with defer loading

		static $delayedScripts;
		if (!isset($delayedScripts)) {
			$delayedScripts = apply_filters('woptimization_delayed_scripts', [
				'contact-form-7',
				'google-recaptcha',
				'wpcf7-recaptcha',
			]);
		}

		if (in_array($handle, $delayedScripts, true)) {
			ob_start(); ?><script> wLoadDelayed(function() { wLoadScript('<?= htmlspecialchars_decode($url); ?>'); }); </script><?php
			return str_replace("<script src='{$url}'></script>", ob_get_clean(), $tag);
		}

		return str_replace("src=", "defer=\"defer\" src=", $tag);
	}

	public static function filter__style_loader_tag($tag, $handle, $href, $media) {
		if (SCRIPT_DEBUG)
			return $tag;

		static $bomMap = [
			"\xEF\xBB\xBF" => 'UTF-8',
			"\xFE\xFF" => 'UTF-16BE',
			"\xFF\xFE" => 'UTF-16LE',
			"\x00\x00\xFE\xFF" => 'UTF-32BE',
			"\xFF\xFE\x00\x00" => 'UTF-32LE',
			"\x2B\x2F\x76\x38" => 'UTF-7',
			"\x2B\x2F\x76\x39" => 'UTF-7',
			"\x2B\x2F\x76\x2B" => 'UTF-7',
			"\x2B\x2F\x76\x2F" => 'UTF-7',
			"\x2B\x2F\x76\x38\x2D" => 'UTF-7',
		];

		$path = dirname($href);
		$httpClientOptions = ['http'=>['header'=>['User-Agent: '.static::$httpClientUserAgent]]];
		$content = file_get_contents($href, false, stream_context_create($httpClientOptions));

		foreach ($bomMap as $bom=>$encoding) {
			if (strpos($content, $bom) === 0) {
				$content = mb_convert_encoding(substr($content, strlen($bom)), 'utf-8', $encoding);
				break;
			}
		}

		$content = preg_replace('=/\*#.+?\*/=', '', $content); //remove css source mapping and comments
		$content = preg_replace_callback('/url\([\'"]?(.+?)[\'"]?\)/i', function ($matches) use ($path, $httpClientOptions) {
			static $ignore = ['http://', 'https://', '//', 'data:'];
			foreach ($ignore as $pattern) {
				if (0 === strncmp($matches[1], $pattern, strlen($pattern)))
					return $matches[0];
			}

			$url = "{$path}/{$matches[1]}";

			if (false && mb_stripos($url, '.subset.woff2')) { //Font embed
				$url = 'data:font/woff2;base64,'.base64_encode(file_get_contents($url, false, stream_context_create($httpClientOptions)));
			}

			return "url({$url})";
		}, $content);
		//var_dump(compact('tag', 'handle', 'href', 'media'));
		return "<style>{$content}</style>";
	}

	public static function filter__wtheme_template_include($content) {
		$content = preg_replace_callback('/<img.* src=[\'"].+[\'"].*>/Ui', function ($matches) {
			$img = $matches[0];
			if (false !== strpos($img, 'no_lazy'))
				return $img;

			return str_replace(['<img ', ' src=', ' srcset='], ['<img lazy ', ' src="' . static::$pixel . '" data-src=', ' data-srcset='], $img) . "<noscript>{$img}</noscript>";
		}, $content);

		$content = preg_replace_callback('/<iframe.* src=[\'"].+[\'"].*>/Ui', function ($matches) {
			$iframe = $matches[0];
			if (false !== strpos($iframe, 'no_lazy'))
				return $iframe;

			return str_replace(' src=', ' lazy data-src=', $iframe);
		}, $content);

		return $content;
	}

	protected static function disable_emoji() {
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		remove_action('admin_print_scripts', 'print_emoji_detection_script');
		remove_action('wp_print_styles', 'print_emoji_styles');
		remove_action('admin_print_styles', 'print_emoji_styles');
		remove_filter('the_content_feed', 'wp_staticize_emoji');
		remove_filter('comment_text_rss', 'wp_staticize_emoji');
		remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
		add_filter( 'tiny_mce_plugins', function($plugins) { return array_diff($plugins, ['wpemoji']); });
	}

	public static function filter__nav_menu_css_class($classes, $item) {
		return array_diff($classes, ["menu-item-{$item->ID}", "menu-item-type-{$item->type}", "menu-item-object-{$item->object}", 'page_item', "page-item-{$item->object_id}", 'current_page_item', 'menu-item-home']);
	}

	public static function action__wpcf7_enqueue_scripts() {
		wp_add_inline_script('contact-form-7', '
	wpcf7.refill = function() {};
	wpcf7.initForm = function(form) {
		var interval = setInterval(function() {
			return !wpcf7.clearResponse ? 1 : clearInterval(interval) || wpcf7.initForm(form);
		}, 500);
	 }', 'before');
	}

	public static function noScriptStart($class='lazy') {
		if (static::$isEnabled)
			return "<noscript class='{$class}'>";
	}

	public static function noScriptEnd() {
		if (static::$isEnabled)
			return '</noscript>';
	}

	public static function addDeferOnScripts($content) {
		return preg_replace_callback("#<script\s.*src=.*[^>]*>#Uis", function ($matches) {
			if (false === strpos($matches[0], 'defer="defer"')) {
				$matches[0] = str_replace("src=", "defer=\"defer\" src=", $matches[0]);
			}

			return $matches[0];
		}, $content);
	}
}