<?php
/**
 * Version: 0.1.8
 */
class wSidebar extends wCustomPostType {

	static $post_type = '';

	static $default_sidebars = array();

	static $custom_sidebars = array();

	static $use_custom_sidebars = false;

	static $sidebar_options = array(
		'before' => '<div class="sidebar %s">',
		'after' => '</div>',
		'class' => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget_title">',
		'after_title' => '</h3>',
	);

	static $default_index = null;

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Sidebar', 'Sidebars');
	}

	function register_post_type($args = array()) {
		parent::register_post_type(array(
			'public' => false,
			'show_ui' => self::$use_custom_sidebars,
			'supports' => array('title', 'editor'),
			'menu_icon' => wTheme::$admin_dir_uri.'/images/icon-sidebar.png',
		));
	}

	function add_hooks() {
		parent::add_hooks();

		//hooks dynamic_sidebar_before, dynamic_sidebar_after works since wp version 3.9.0
		add_action('after_switch_theme', array(__CLASS__, 'action__after_switch_theme'));
		add_action('widgets_init', array(__CLASS__, 'action__widgets_init'));
		add_action('dynamic_sidebar_before', array(__CLASS__, 'action__dynamic_sidebar_before'), 10, 2);
		add_action('dynamic_sidebar_after', array(__CLASS__, 'action__dynamic_sidebar_after'), 10, 2);
		add_action('add_meta_boxes_page', array($this, 'action__add_meta_boxes_page'));
	}

	static function action__after_switch_theme() {
		self::create_default_sidebar();
	}

	static function create_default_sidebar() {
		$sidebars = get_posts(array('post_type'=>self::$post_type));
		if (empty($sidebars)) {
			$new_post = array(
				'post_content' => wTheme::__('Demo sidebar'),
				'post_title' => wTheme::__('Demo sidebar'),
				'post_type' => self::$post_type,
				'post_status' => 'publish',
			);
			wp_insert_post($new_post, false);
		}
	}

	function action__add_meta_boxes_page($post) {
		if (self::$use_custom_sidebars) {
			$post_type = 'page';
			$id = wTheme::prefix('custom_sidebars');
			add_meta_box($id, wTheme::__('Custom sidebars'), array($this, 'meta_box__custom_sidebars'), $post_type, 'side', 'core');
			add_filter("postbox_classes_{$post_type}_{$id}", array($this, 'filter__postbox_classes'));
		}
	}

	function meta_box__custom_sidebars($post, $options) {
		$meta_key = wTheme::prefix('custom_sidebars');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		$post_type = self::$post_type;
		$custom_sidebars = self::$custom_sidebars;
		$layout_options = wTheme::$layout_options;
		$page_templates_layouts = self::get_page_templates_layouts();
		$page_on_front = get_option('page_on_front');

		if (!empty($page_on_front) && $page_on_front == $post->ID) {
			$page_templates_layouts['default'] = 'front';
			$layout_options['front'] = array('sidebars' => false);
		}
		?>
		<?php if (!empty($custom_sidebars)) { ?>
			<?php array_unshift($custom_sidebars, array('post_id' => 0, 'name'=>wTheme::__('Default sidebar'))); ?>
			<?php foreach (self::$default_sidebars as $default_sidebar) { ?>
			<?php
				if (empty($default_sidebar['can_custom']))
					continue;
			?>
			<p class="sidebar <?php echo wTheme::remove_prefix($default_sidebar['id']); ?>">
				<label for="<?php $this->field_id($default_sidebar['id'], $meta_key); ?>"><?php echo $default_sidebar['name']; ?></label><br />
				<select name="<?php $this->field_name($default_sidebar['id'], $meta_key); ?>" id="<?php $this->field_id($default_sidebar['id'], $meta_key); ?>">
					<?php foreach ($custom_sidebars as $custom_sidebar) { ?>
					<option value="<?php echo $custom_sidebar['post_id']; ?>" <?php selected(@$data[$default_sidebar['id']], $custom_sidebar['post_id']) ?>><?php echo $custom_sidebar['name']; ?></option>
					<?php } ?>
				</select>
			</p>
			<?php } ?>
		<?php } else { ?>
			<p><?php wTheme::_e('No custom sidebars.'); ?></p>
		<?php } ?>
		<script>
			(function() {
				var page_templates_layouts = <?php echo json_encode($page_templates_layouts); ?>;
				var layout_options = <?php echo json_encode($layout_options); ?>;
				var $meta_box = jQuery('#<?php echo $options['id']; ?>');
				var $meta_box_sidebars = jQuery('.sidebar', $meta_box);

				jQuery('#page_template').change(function(){
					var $this = jQuery(this);
					var val = $this.val();
					var layout = page_templates_layouts[val];

					if (typeof layout === 'undefined')
						return;

					var sidebars = layout_options[layout].sidebars;

					if (sidebars) {
						$meta_box_sidebars.hide();
						jQuery.each(sidebars, function(i, s){
							$meta_box.find('.sidebar_'+s).show();
						});
						$meta_box.show();
					} else {
						$meta_box.hide();
					}
				}).change();
			})();
		</script>
		<!--TODO fields title&desc for create sidebar instantly here-->
		<p><a href="<?php echo admin_url("post-new.php?post_type={$post_type}"); ?>"><?php wTheme::_e('Add custom sidebar'); ?></a></p>
		<?php
	}

	function action__save_post($post_id) {
		parent::action__save_post($post_id);
		$this->save_meta_data($post_id, wTheme::prefix('custom_sidebars'), true, false);
	}

	function filter__postbox_classes($classes) {
		global $post;

		$page_template = get_post_meta($post->ID, '_wp_page_template', true);
		if (get_option('page_on_front')!=$post->ID && self::get_sidebars_by_page_template($page_template))
			$classes[] = 'hidden';

		return $classes;
	}

	static function get_sidebars_by_page_template($page_template) {
		$page_templates_layouts = self::get_page_templates_layouts();
		$layout = @$page_templates_layouts[$page_template];
		if (isset(wTheme::$layout_options[$layout], wTheme::$layout_options[$layout]['sidebars']))
			return wTheme::$layout_options[$layout]['sidebars'];

		return false;
	}

	static function get_page_templates_layouts() {
		$page_templates_layouts = array('default'=>wTheme::$layout);
		$page_templates = wp_get_theme()->get_page_templates();
		if (empty($page_templates))
			return $page_templates_layouts;

		foreach ($page_templates as $file => $title) {
			$full_path = get_template_directory().'/'.$file;
			if (!file_exists($full_path))
				continue;

			$content = file_get_contents($full_path);
			$layout = wTheme::$layout;
			if (preg_match('|Layout:(.*)$|mi', $content, $_layout)) {
				$_layout = _cleanup_header_comment($_layout[1]);
				if (isset(wTheme::$layout_options[$_layout]))
					$layout = $_layout;
			}
			$page_templates_layouts[$file] = $layout;
		}

		return $page_templates_layouts;
	}

	static function action__widgets_init() {
		if (self::$use_custom_sidebars)
			self::register_custom_sidebars();
	}

	static function register_custom_sidebars() {
		$sidebars = get_posts(array('post_type'=>self::$post_type, 'posts_per_page'=>'-1'));
		foreach ($sidebars as $sidebar) {
			$args = array(
				'post_id' => $sidebar->ID,
				'name' => $sidebar->post_title,
				'id' => wTheme::prefix("sidebar_{$sidebar->ID}"),
				'description' => $sidebar->post_content,
			);
			$sidebar_options = wp_parse_args($args, self::$sidebar_options);
			self::$custom_sidebars[$sidebar->ID] = $sidebar_options;
			register_sidebar($sidebar_options);
		}
	}

	static function register($args = array()) {
		$sidebar = wp_parse_args($args, self::$sidebar_options);
		if (isset($sidebar['id'])) {
			if (self::_can_custom($sidebar['id'])) {
				self::$use_custom_sidebars = true;
				$sidebar['can_custom'] = true;
			}
			$sidebar['class'] = trim($sidebar['id'].' '.$sidebar['class']);
			$sidebar['id'] = wTheme::prefix('sidebar_'.$sidebar['id']);
		}

		self::$default_sidebars[$sidebar['id']] = $sidebar;
		return register_sidebar($sidebar);
	}

	static function _can_custom($sidebar_id) {
		foreach (wTheme::$layout_options as $layout) {
			if (isset($layout['sidebars']) && is_array($layout['sidebars']) && in_array($sidebar_id, $layout['sidebars']))
				return true;
		}

		return false;
	}

	static function action__dynamic_sidebar_before($index, $has_widgets) {
		global $wp_registered_sidebars;

		if (!$has_widgets || is_admin())
			return;

		$default_index = self::$default_index;
		$sidebar = $wp_registered_sidebars[$index];
		if (!empty($default_index) && $default_index != $index) {
			$keys = array_flip(array_keys(self::$sidebar_options));
			$sidebar_params = array_intersect_key($wp_registered_sidebars[$default_index], $keys);
			$sidebar = wp_parse_args($sidebar_params, $sidebar);
		}
		$wp_registered_sidebars[$index] = $sidebar;
		printf(@$sidebar['before'], $sidebar['class']);
	}

	static function action__dynamic_sidebar_after($index, $has_widgets) {
		global $wp_registered_sidebars;

		if (!$has_widgets || is_admin())
			return;

		echo @$wp_registered_sidebars[$index]['after'];
	}

	static function show($index = 'left', $post_id = null) {
		$index = wTheme::prefix("sidebar_{$index}");
		self::$default_index = $index;
		if (!self::$use_custom_sidebars)
			return dynamic_sidebar($index);

		if (!$post_id && is_page())
			$post_id = get_the_ID();

		$custom_sidebar_post_id = get_post_meta($post_id, $index, true);
		if (!isset(self::$custom_sidebars[$custom_sidebar_post_id]))
			return dynamic_sidebar($index);

		if (!$did_one = dynamic_sidebar(self::$custom_sidebars[$custom_sidebar_post_id]['id']))
			return dynamic_sidebar($index);

		return $did_one;
	}
}