<?php
/**
 * Version: 0.1.5
 */
class wCustomTaxonomy {

	//static $taxonomy; //Must be defined in children to use

	protected $_taxonomy = '';

	protected $_post_type = '';

	private static $taxonomies = array();

	private static $internal_taxonomies = array('category', 'post_tag', 'nav_menu', 'link_category', 'post_format');

	public $supports = array();

	function __construct($taxonomy, $post_type = '') {
		if (empty($taxonomy))
			throw new Exception('Empty taxonomy');

		if (in_array($taxonomy, self::$taxonomies))
			throw new Exception("Taxonomy '{$taxonomy}' already registered");

		$this->taxonomy($taxonomy);
		$this->post_type($post_type);
		$this->add_hooks();
	}

	function add_hooks() {
		add_action('init', array($this, 'action__init'));
		add_filter('nav_menu_meta_box_object', array($this, 'filter__nav_menu_meta_box_object'));

		$taxonomy = $this->taxonomy();
		add_action("{$taxonomy}_add_form_fields", array($this, 'action__add_form_fields'));
		add_action("{$taxonomy}_edit_form_fields", array($this, 'action__edit_form_fields'));
		add_action("create_{$taxonomy}", array($this, 'action__create_taxonomy'));
		add_action("edit_{$taxonomy}", array($this, 'action__edit_taxonomy'));
		add_action("delete_{$taxonomy}", array($this, 'action__delete_taxonomy'), 10, 4);
	}

	function action__init() {
		if (!in_array($this->taxonomy(), self::$internal_taxonomies))
			$this->register_taxonomy();
	}

	function get_labels($singular = '', $plural = '') {
		if (!empty($singular) && !empty($plural)) {
			$singular = wTheme::__($singular);
			$plural = wTheme::__($plural);
		} else {
			$singular = _x('Category', 'taxonomy singular name');
			$plural = _x('Categories', 'taxonomy general name');
		}

		return array(
			'name' => $plural,
			'singular_name' => $singular,
			'add_new_item' => sprintf(wTheme::__('Add New %s'), $singular),
			'edit_item' => sprintf(wTheme::__('Edit %s'), $singular),
			'update_item' => sprintf(wTheme::__('Update %s'), $singular),
			'parent_item' => sprintf(wTheme::__('Parent %s'), $singular),
			'parent_item_colon' => sprintf(wTheme::__('Parent %s'), $singular) . ':',
			'new_item_name' => sprintf(wTheme::__('New %s Name'), $singular),
			'search_items' => sprintf(wTheme::__('Search %s'), $plural),
			'not_found' => sprintf(wTheme::__('No %s found.'), $plural),
			'all_items' => sprintf(wTheme::__('All %s'), $plural),
		);
	}

	function register_taxonomy($args = array()) {
		$taxonomy = $this->taxonomy();
		if (taxonomy_exists($taxonomy))
			throw new Exception("Taxonomy '{$taxonomy}' already registered");

		$defaults = array(
			'public' => true,
			'show_ui' => true,
			'hierarchical' => true,
			'rewrite' => false,
			'supports' => array('thumbnail', 'taxonomy-attributes'),
			'meta_box_cb' => null, //array($this, 'object_taxonomy_dropdown_meta_box')
		);
		if ($labels = $this->get_labels())
			$defaults['labels'] = $labels;

		$args = wp_parse_args($args, $defaults);
		if (false !== $args['rewrite'] && !isset($args['rewrite']['hierarchical']))
			$args['rewrite']['hierarchical'] = true;

		register_taxonomy($taxonomy, $this->post_type(), $args);
		$this->supports = $args['supports'];
	}

	function filter__nav_menu_meta_box_object($tax) {
		$taxonomy = $this->taxonomy();
		if ($tax && true===$tax->hierarchical && 'category'!==$taxonomy && $taxonomy===$tax->name) {
			$post_type = get_post_type_object($this->post_type());
			if ($post_type)
				$tax->labels->name = "{$post_type->labels->singular_name} {$tax->labels->name}";
		}

		return $tax;
	}

	function taxonomy($taxonomy = '') {
		if (!empty($taxonomy)) {
			$this->_taxonomy = $taxonomy;
			self::$taxonomies []= $taxonomy;

			if (property_exists(get_called_class(), 'taxonomy'))
				static::$taxonomy = $taxonomy;
		}

		return $this->_taxonomy;
	}

	function post_type($post_type = '') {
		if (!empty($post_type))
			$this->_post_type = $post_type;

		return $this->_post_type;
	}

	function set_additional_fields($term) {
		$term_id = $term->term_id;
		if (in_array('thumbnail', $this->supports))
			$term->thumbnail_id = get_term_meta($term_id, 'thumbnail_id', true);

		if (in_array('taxonomy-attributes', $this->supports))
			$term->order = get_term_meta($term_id, 'order', true);

		$term->url = $this->permalink($term_id);
	}

	function get_term($term, $output = OBJECT, $filter = 'raw') {
		$term = get_term($term, $this->taxonomy(), $output, $filter);
		if (empty($term) || is_wp_error($term))
			return null;

		$this->set_additional_fields($term);
		return $term;
	}

	function get_terms($args = array()) {
		if (!isset($args['taxonomy']))
			$args['taxonomy'] = $this->taxonomy();

		if (!isset($args['orderby']) && in_array('taxonomy-attributes', $this->supports)) {
			$args['orderby'] = 'meta_value_num';
			$args['meta_query'] = array(array('key'=>'order'));
		}

		$terms = get_terms($args);
		if ($terms && !isset($args['fields'])) {
			foreach ($terms as $k=>$term)
				$this->set_additional_fields($term);
		}

		return $terms;
	}

	/**
	 * @param \WP_Term $term
	 * @return string
	 */
	function get_form_meta_fields($term = null) {
		$term_id = @$term->term_id;
		$meta_key = $this->taxonomy();
		ob_start(); ?>

		<?php if (in_array('thumbnail', $this->supports)) { ?>
			<tr class="form-field">
				<?php $field = 'thumbnail_id'; $value = get_term_meta($term_id, $field, true); ?>
				<th scope="row" valign="top"><label for="<?php $this->field_id($field, $meta_key); ?>"><?php _e('Featured Image'); ?></label></th>
				<td><?php echo wTheme::get_media_popup_field($this->field_name($field, $meta_key, true), $value, false); ?></td>
			</tr>
		<?php } ?>
		<?php if (in_array('taxonomy-attributes', $this->supports)) { ?>
			<tr class="form-field">
				<?php $field = 'order'; $value = get_term_meta($term_id, $field, true); ?>
				<th scope="row" valign="top"><label for="<?php $this->field_id($field, $meta_key); ?>"><?php _e('Order'); ?></label></th>
				<td>
					<input type="number" step="1" min="0" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(intval($value)); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 70px;" />
				</td>
			</tr>
		<?php } ?>
		<?php

		return ob_get_clean();
	}

	function action__add_form_fields() {
		$form_fields = $this->get_form_meta_fields();
		echo self::convert_form_fields_for_add_method($form_fields);
	}

	function action__edit_form_fields($term) {
		echo $this->get_form_meta_fields($term);
	}

	static function convert_form_fields_for_add_method($form) {
		$search = array('<tr ', '</tr>', '<th scope="row" valign="top">', '<th valign="top">', '</th>', '<td>', '</td>');
		$replace = array('<div ', '</div>', '', '', '', '', '');

		return str_replace($search, $replace, $form);
	}

	function action__create_taxonomy($term_id) {
		$this->save_taxonomy($term_id);
	}

	function action__edit_taxonomy($term_id) {
		$this->save_taxonomy($term_id);
	}

	function action__delete_taxonomy($term_id, $tt_id, $deleted_term, $object_ids) {
	}

	function save_taxonomy($term_id) {
		$this->save_default_meta_fields($term_id);
	}

	function save_default_meta_fields($term_id) {
		$meta_key = $this->taxonomy();
		if (isset($_POST['data'][$meta_key])) {
			$data = &$_POST['data'][$meta_key];

			if (in_array('thumbnail', $this->supports)) {
				$attachment = get_post((int) $data['thumbnail_id']);
				if (!$attachment || 'attachment' !== $attachment->post_type)
					$data['thumbnail_id'] = '';
			}

			if (in_array('taxonomy-attributes', $this->supports))
				$data['order'] = (int) $data['order'];

			unset($data);
			$this->save_meta_fields($term_id, $meta_key);
		}
	}

	function save_meta_fields($term_id, $meta_key, $save_in_multiple = true, $use_prefix = false) {
		$data = stripslashes_deep($_POST['data'][$meta_key]);
		if ($save_in_multiple) {
			foreach ($data as $field=>$value)
				update_term_meta($term_id, $use_prefix ? wTheme::prefix($field) : $field, $value);
		} else {
			update_term_meta($term_id, $use_prefix ? $meta_key : wTheme::remove_prefix($meta_key), $data);
		}

		return true;
	}

	function field_name($field_name, $meta_key, $return = false) {
		$field_name = str_replace('.', '][', $field_name);
		$field = "data[{$meta_key}][{$field_name}]";
		if (!$return)
			echo $field;

		return $field;
	}

	function field_id($field_name, $meta_key, $return = false) {
		$field = "{$meta_key}_{$field_name}";
		if (!$return)
			echo $field;

		return $field;
	}

	function permalink($term_id) {
		$link = get_term_link((int) $term_id, $this->taxonomy());
		if (is_wp_error($link))
			$link = '#';

		return $link;
	}

	function object_taxonomy_dropdown_meta_box($post, $box) {
		$taxonomy = $this->taxonomy();
		$hierarchical = get_taxonomy($taxonomy)->hierarchical;
		$name = "tax_input[{$taxonomy}]";
		$term_obj = wp_get_object_terms($post->ID, $taxonomy);
		$selected = @$term_obj[0]->term_id;
		?><div id="taxonomy-<?php echo $taxonomy; ?>" class="categorydiv"><?php
			wp_dropdown_categories(array('taxonomy'=>$taxonomy, 'hide_empty'=>0, 'hierarchical'=>$hierarchical, 'name'=>"{$name}[]", 'selected'=>$selected, 'orderby'=>'name', 'show_option_none'=>'&mdash;'));
		?></div><?php
	}

	static function get_all_meta($term_id, $is_remove_prefix = false, $single = true) {
		$data = array();
		$meta_data = get_term_meta($term_id, '', $single);
		if (empty($meta_data))
			return $data;

		foreach ($meta_data as $meta_key=>$meta_value) {
			if ($is_remove_prefix)
				$meta_key = wTheme::remove_prefix($meta_key);
			if ($single)
				$data[$meta_key] = maybe_unserialize($meta_value[0]);
			else
				$data[$meta_key] = array_map('maybe_unserialize', $meta_value);
		}

		return $data;
	}
}