<?php

class wHooks {

	static function construct() {
		add_action('show_user_profile', array(__CLASS__, 'action_show_extra_profile_fields'));
		add_action('edit_user_profile', array(__CLASS__, 'action_show_extra_profile_fields'));
		add_action('personal_options_update', array(__CLASS__, 'action_save_extra_profile_fields'));
		add_action('edit_user_profile_update', array(__CLASS__, 'action_save_extra_profile_fields'));
	}

	static function action_show_extra_profile_fields($user) {
		$meta_key = wTheme::prefix('fields');
		$avatar_image_id = get_user_meta($user->ID, wTheme::prefix('avatar_image_id'), true);
		$profile_info = get_user_meta($user->ID, wTheme::prefix('bio_2'), true);
		?>
		<table class="form-table">
			<tr>
				<th><?php wTheme::_e('Avatar'); ?></th>
				<td><?php echo wTheme::get_media_popup_field("data[{$meta_key}][avatar_image_id]", $avatar_image_id); ?></td>
			</tr>
			<tr>
				<th><?php wTheme::_e('Author Bio 2'); ?></th>
				<td>
					<?php wp_editor($profile_info, 'bio2', array('textarea_name'=>"data[{$meta_key}][bio_2]")); ?>
				</td>
			</tr>
		</table>
		<?php
	}

	static function action_save_extra_profile_fields($user_id) {
		$meta_key = wTheme::prefix('fields');
		if (isset($_POST['data'][$meta_key])) {
			$data = stripslashes_deep($_POST['data'][$meta_key]);
			update_user_meta($user_id, wTheme::prefix('avatar_image_id'), $data['avatar_image_id']);
			update_user_meta($user_id, wTheme::prefix('bio_2'), $data['bio_2']);
		}
	}
}
wHooks::construct();