<?php
$inc_dir = get_template_directory().'/inc';
$wLib_dir = "{$inc_dir}/wLib";

require_once "{$wLib_dir}/wTheme.php";
require_once "{$wLib_dir}/wCustomPostType.php";
require_once "{$wLib_dir}/wCustomTaxonomy.php";
require_once "{$wLib_dir}/wSidebar.php";
require_once "{$wLib_dir}/wThemeSettings.php";
require_once "{$wLib_dir}/wAvatar.php";
require_once "{$wLib_dir}/wDatePicker.php";

require_once "{$inc_dir}/widgets.php";
require_once "{$inc_dir}/wPage.php";
require_once "{$inc_dir}/wPost.php";
require_once "{$inc_dir}/wPostCategory.php";
require_once "{$inc_dir}/wProduct.php";
require_once "{$inc_dir}/wHooks.php";
require_once "{$inc_dir}/wTestimonial.php";
require_once "{$inc_dir}/wPageSection.php";
require_once "{$inc_dir}/wPostSection.php";
require_once "{$inc_dir}/wOptimization.php";
require_once "{$inc_dir}/wSchema.php";

wTheme::$layout_options = array(
	'full-width' => array('sidebars' => false),
	'right-sidebar' => array('sidebars' => array('right')),
//	'right-sidebar' => array('sidebars' => array('right')),
//	'two-sidebars' => array('sidebars' => array('left', 'right')),
);

wTheme::$layout = 'right-sidebar';

$wSidebar = new wSidebar(wTheme::prefix('sidebar'));
$wPage = new wPage('page');
$wPost = new wPost('post');
$wProduct = new wProduct(wTheme::prefix('product'));
$wPostCategory = new wPostCategory('category', 'post');

$wTestimonial = new wTestimonial(wTheme::prefix('testimonial'));
$wPageSection = new wPageSection(wTheme::prefix('page_section'));
$wPostSection = new wPostSection(wTheme::prefix('post_section'));

wDatePicker::datepicker(['post']);
wOptimization::construct();
