<?php

function wtheme_setup() {

	wp_get_theme()->load_textdomain();

	add_theme_support('html5', array('search-form', 'comment-form', 'comment-list'));

	register_nav_menu('main_menu', wTheme::__('Main Menu'));

	add_theme_support('post-thumbnails');

	wTheme::add_image_size('page_thumb_home', 1920, 510, true);
	wTheme::add_image_size('page_thumb', 1920, 470, true);
        wTheme::add_image_size('post_thumb', 680, 9999, false);
	wTheme::add_image_size('post_thumb_list', 164, 111, true);
	wTheme::add_image_size('post_thumb_list2', 450, 300, true);
	wTheme::add_image_size('event_thumb', 250, 9999, false);
	wTheme::add_image_size('event_thumb_widget', 9999, 113, false);
	wTheme::add_image_size('event_thumb_3', 300, 300, true);
	wTheme::add_image_size('post_thumb_widget', 106, 80, true);
	wTheme::add_image_size('avatar', 120, 120, true);
	wTheme::add_image_size('post_thumb_small', 80, 80, true);
	wTheme::add_image_size('product_thumb_columns', 230, 230, false);
	wTheme::add_image_size('image_and_description_thumb', 500, 395, true);
}
add_action('after_setup_theme', 'wtheme_setup');

function wtheme_wp_title($title, $sep) {
	global $paged, $page;

	if (is_feed())
		return $title;

	// Add the site name.
	$title .= get_bloginfo('name');

	// Add the site description for the home/front page.
	$site_description = get_bloginfo('description', 'display');
	if ($site_description && (is_home() || is_front_page()))
		$title = "$title $sep $site_description";

	// Add a page number if necessary.
	if ($paged >= 2 || $page >= 2)
		$title = "$title $sep ".sprintf(wTheme::__('Page %s'), max($paged, $page));

	return $title;
}
add_filter('wp_title', 'wtheme_wp_title', 10, 2);

function wtheme_scripts_styles() {
	$template_directory_uri = get_template_directory_uri();
	$js_directory_uri = "{$template_directory_uri}/js/";

	wp_enqueue_style(wTheme::prefix('main-style'), $template_directory_uri.'/css/style.css');
	wp_enqueue_style(wTheme::prefix('prettyPhoto_style'), $js_directory_uri . 'prettyPhoto/prettyPhoto.min.css');

	wp_enqueue_script('jquery');
	wp_enqueue_script(wTheme::prefix('prettyPhoto'), $js_directory_uri . 'prettyPhoto/jquery.prettyPhoto.min.js', array('jquery'));
	wp_enqueue_script(wTheme::prefix('functions'), $js_directory_uri . 'functions.min.js', array('jquery'));
	wp_register_script(wTheme::prefix('sticky-kit'), $js_directory_uri . 'jquery.sticky-kit.js', array('jquery'));
	if (is_singular('post'))
		wp_enqueue_script(wTheme::prefix('sticky-kit'));
	wp_register_script(wTheme::prefix('slick'), $js_directory_uri . "slick.min.js", array('jquery'));

	add_filter('woptimization_delayed_scripts', function ($handles) {
		//$handles []= wTheme::prefix('slick');
		$handles []= wTheme::prefix('recaptcha');

		return $handles;
	});
}

function wtheme_widgets_init() {
	register_widget('wTheme_Widget_Children_Pages');
	register_widget('wTheme_Widget_Google_Map');
	register_widget('wTheme_Widget_Featured_Text');
	register_widget('wTheme_Widget_Title_Anchors');
	unregister_widget('WP_Widget_Recent_Posts');
	register_widget('wTheme_Widget_Recent_Posts');
	register_widget('wTheme_Widget_Categories_list');
	register_widget('wTheme_Widget_Top_New_posts');
	register_widget('wTheme_Widget_Same_Category_Posts');

	if (defined('ICL_SITEPRESS_VERSION') && defined('ICL_PLUGIN_INACTIVE') && !ICL_PLUGIN_INACTIVE)
		register_widget('wTheme_Widget_Featured_Text_Icl');

	$before = '<div class="sidebar %s" id="%s" itemscope itemtype="http://schema.org/WPSideBar">';
	wSidebar::register(array('name'=>wTheme::__('Right sidebar'), 'id'=>'right', 'before'=>sprintf($before, '%s', 'right_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Category Right sidebar'), 'id'=>'right_category', 'before'=>sprintf($before, '%s', 'right_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Footer sidebar'), 'id'=>'footer', 'before'=>sprintf($before, '%s', 'footer_sidebar'), 'before_title'=>'<h4 class="widget_title"><span>', 'after_title'=>'</span></h4>'));
	wSidebar::register(array('name'=>wTheme::__('Home sidebar'), 'id'=>'home', 'before'=>sprintf($before, '%s', 'home_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Before footer sidebar'), 'id'=>'before_footer', 'before'=>sprintf($before, '%s', 'before_footer_sidebar')));
	wSidebar::register(array('name'=>wTheme::__('Left sidebar'), 'id'=>'left', 'before'=>sprintf($before, '%s', 'left_sidebar')));
}
add_action('widgets_init', 'wtheme_widgets_init');

function wtheme_custom_caption_shortcode($nothing, $attr, $content = null) {
	extract(shortcode_atts(array('id'=>'', 'align'=>'alignnone', 'width'=>'', 'caption'=>''), $attr));

	if (1 > (int) $width || empty($caption))
		return $content;

	if ($id) $id = 'id="'.esc_attr($id).'" ';

	return '<dl '.$id.'class="wp_caption '.esc_attr($align).'" style="width: '.((int) $width).'px"><dt>'
			.do_shortcode($content).'</dt><dd class="wp_caption_text">'.$caption.'</dd></dl>';
}
add_filter('img_caption_shortcode', 'wtheme_custom_caption_shortcode', 10, 3);

function wtheme_regenerate_attachment_thumbnails($attachment_id) {
	if (!wp_attachment_is_image($attachment_id))
		return;

	if (!function_exists('media_handle_sideload')) {
		require_once(ABSPATH.'wp-admin'.'/includes/image.php');
		require_once(ABSPATH.'wp-admin'.'/includes/file.php');
		require_once(ABSPATH.'wp-admin'.'/includes/media.php');
	}

	$file_path = get_attached_file($attachment_id, true);
	$metadata = wp_generate_attachment_metadata($attachment_id, $file_path);

	if (!is_wp_error($metadata) && !empty($metadata))
		wp_update_attachment_metadata($attachment_id, $metadata);
}

function wtheme_filter_wp_get_attachment_link($link) {
	return str_replace('<a ', '<a rel="prettyPhoto['.wTheme::prefix('gallery').']" ', $link);
}
add_filter('wp_get_attachment_link', 'wtheme_filter_wp_get_attachment_link');

function wtheme_page_class($classes) {
	if (is_front_page()) {
		if ($index = array_search('page', $classes))
			unset($classes[$index]);
	}
	if (is_page() && is_page_template()) {
		$page_template = get_page_template_slug(get_queried_object_id());
		$classes[] = sanitize_html_class(str_replace(array('.', '-'), '_', basename($page_template, '.php')));
	}
	if (is_single()) {
		$item = get_queried_object();
		$classes[] = 'single_'.str_replace('-', '_', wTheme::remove_prefix($item->post_type));
	}
	if (wTheme::$layout)
		$classes[] = sanitize_html_class(str_replace(array('.', '-'), '_', 'layout-'.wTheme::$layout));

	return $classes;
}
add_filter('body_class', 'wtheme_page_class');

function wtheme_filter_page_template_column($columns) {
	return array_merge($columns, array('page_template'=>wTheme::__('Page Template')));
}
add_filter('manage_pages_columns', 'wtheme_filter_page_template_column');

function wtheme_action_page_template_column_value($column_name, $post_id) {
	if ('page_template' === $column_name) {
		$template_name = __('Default Template');
		$templates = get_page_templates($post_id);
		$template = get_post_meta($post_id, '_wp_page_template', true);
		if ($_template_name = array_search($template, $templates)) {
			$template_name = $_template_name;
			if (WP_DEBUG)
				$template_name .= '<br /><span class="description">'.str_replace('page-templates/', '', $template).'</span>';
		}
		echo $template_name;
	}
}
add_action('manage_pages_custom_column', 'wtheme_action_page_template_column_value', 10, 2);

function wtheme_filter_previous_posts_link_attributes($attr) {
	return 'class="previous"';
}
add_filter('previous_posts_link_attributes', 'wtheme_filter_previous_posts_link_attributes');

function wtheme_filter_next_posts_link_attributes($attr) {
	return 'class="next"';
}
add_filter('next_posts_link_attributes', 'wtheme_filter_next_posts_link_attributes');

if (function_exists('wpcf7')) {
	function wtheme_wpcf7_form_class_attr($class) {
		$search = 'use-floating-validation-tip';
		if (false ===strpos($class, $search))
			$class .= ' '.$search;
		return $class;
	}
	add_filter('wpcf7_form_class_attr', 'wtheme_wpcf7_form_class_attr');
}

// Fix with insert media to editor and don't auto bind to post
function wp_ajax_wtheme_wp_ajax_send_attachment_to_editor() {
	$attachment = wp_unslash($_POST['attachment']);
	$post = get_post(intval($attachment['id']));
	if ($post && isset($_POST['post_id'])) {
		$_POST['post_id'] = $post->post_parent;
	}
}
add_action('wp_ajax_send-attachment-to-editor', 'wp_ajax_wtheme_wp_ajax_send_attachment_to_editor', 0);

function wtheme_hidecontent($atts, $content='') {
	$key = wTheme::prefix('shortcode_hidecontent');
	$GLOBALS[$key] = isset($GLOBALS[$key]) ? $GLOBALS[$key] + 1 : 1;
	$content = wpautop(trim(do_shortcode($content)));
	$out = ' <a href="#shortcode_hidecontent_'.$GLOBALS[$key].'" class="shortcode_hidecontent">'.wTheme::__("Read more").'</a>';
	$out .= ' <a href="#shortcode_hidecontent_'.$GLOBALS[$key].'" class="shortcode_showcontent" style="display: none;">'.wTheme::__("Hide content").'</a>';
	return $out.'<div class="shortcode_hidecontent_'.$GLOBALS[$key].'" style="display: none;">'.$content.'</div>';
}
add_shortcode('hidecontent', 'wtheme_hidecontent');

function wtheme_question($atts, $content='') {
	return '<div class="shortcode_question">'.do_shortcode($content).'</div>';
}
add_shortcode('question', 'wtheme_question');


function wtheme_user($atts, $content='') {
	$moderator_id = get_post_meta(get_the_ID(), 'moderator_id', true);
	if (0 == $moderator_id)
		return false;
	$user_name = get_userdata($moderator_id)->display_name;
	return '<span class="shortcode_user">'.$user_name.'</span>';
}
add_shortcode('user', 'wtheme_user');

function wtheme_answer($atts, $content='') {
	$style = isset($atts['expand']) ? '' : 'style="display: none;"';
	$content = wpautop(trim(do_shortcode($content)));
	return '<div class="shortcode_answer" '.$style.'>'.$content.'</div>';
}
add_shortcode('answer', 'wtheme_answer');

function wtheme_shortcode_paragraph_fix($content) {
	return strtr($content, array('<p>['=>'[', ']</p>'=>']', ']<br />'=>']'));
}
add_filter('the_content', 'wtheme_shortcode_paragraph_fix');

function wtheme_split($atts, $content) {
	return '[split]';
}
add_shortcode('split', 'wtheme_split');

function wtheme_render_columns($content, $columns) {
	remove_filter('the_content', 'wtheme_filter_the_content_cols', 1);
	remove_filter('the_content', 'wtheme_media_wrapper', 9);
	add_filter('the_content', 'wtheme_filter_the_content', 11);
	if (false !== strpos($content, '[split]')) {
		$columns_content = '';
		foreach (explode('[split]', $content) as $c)
			$columns_content .= wTheme::get_the_content($c, false);
		add_filter('the_content', 'wtheme_filter_the_content_cols', 1);
		remove_filter('the_content', 'wtheme_filter_the_content', 11);
		add_filter('the_content', 'wtheme_media_wrapper', 9);
		return '<div class="columns_'.$columns.' clear">'.$columns_content.'</div>';
	}

	add_filter('the_content', 'wtheme_filter_the_content_cols', 1);
	remove_filter('the_content', 'wtheme_filter_the_content', 11);
	add_filter('the_content', 'wtheme_media_wrapper', 9);
	$content = wTheme::get_the_content($content, false);
	return '<div class="columns_'.$columns.' entry_content clear">'.$content.'</div>';
}

function wtheme_columns_2($atts, $content) {
	return wtheme_render_columns($content, 2);
}
add_shortcode('column2', 'wtheme_columns_2');

function wtheme_columns_3($atts, $content) {
	return wtheme_render_columns($content, 3);
}
add_shortcode('column3', 'wtheme_columns_3');

function wtheme_columns_4($atts, $content) {
	return wtheme_render_columns($content, 4);
}
add_shortcode('column4', 'wtheme_columns_4');

function wtheme_filter_the_content($content) {
	return '<div class="entry_content clear">'.$content.'</div>';
}

function wtheme_filter_the_content_cols($content) {
	for ($i=2; $i<=5; $i++)
		$content = str_replace(array("[column{$i}]", "[/column{$i}]"), array("</div>[column{$i}]", "[/column{$i}]".'<div class="entry_content clear">'."\n\r"), $content);
	return '<div class="entry_content clear">'."\n\r".$content.'</div>';
}
add_filter('the_content', 'wtheme_filter_the_content_cols', 1);

function wtheme_filter_the_content_clean($content) {
	return str_replace('<div class="entry_content clear">
</div>', '', $content);
}
add_filter('the_content', 'wtheme_filter_the_content_clean', 11);

function wtheme_action_wp_head_ie_js_includes() {
	?>
	<!--[if lt IE 9]>
	<script src="<?= get_template_directory_uri(); ?>/js/html5.min.js" type="text/javascript"></script>
	<![endif]-->
	<?php
	if (!is_singular())
		return;

	$content = get_the_content();
	$has_shortcode = false;
	for ($i=2; $i<=5; $i++)
		if (has_shortcode($content, 'column'.$i))
			$has_shortcode = true;

	if (!$has_shortcode)
		return false;

	?>
	<!--[if lt IE 10]>
	<script src="<?= get_template_directory_uri(); ?>/js/css3-multi-column.min.js" type="text/javascript"></script>
	<![endif]-->
	<?php
}
add_action('wp_head' , 'wtheme_action_wp_head_ie_js_includes');

function wtheme_media_wrapper($content) {
	preg_match_all('~<iframe.*</iframe>|<embed.*</embed>|<object.*</object>~', $content, $matches);

	foreach ($matches[0] as $i=>$match) {
		$replace = "[%REPLACE-MEDIA-{$i}%]";
		if (strpos($content, $match) !== false)
			$content = substr_replace($content, $replace, strpos($content, $match), strlen($match));
	}

	foreach ($matches[0] as $i=>$match) {
		$wrap = '<div class="media_wrap">'.$match.'</div>';
		preg_match('/ *width *= *["\']?([^"\']*)/i', $match, $width);
		if (!empty($width[1])) {
			$max_width = trim($width[1]);
			if ('%' !== substr($max_width, -1))
				$max_width .= 'px';

			$wrap = '<div style="max-width: '.$max_width.';">'.$wrap.'</div>';
		}

		$replace = "[%REPLACE-MEDIA-{$i}%]";
		$content = str_replace($replace, $wrap, $content);
	}
	return $content;
}
add_filter('the_content', 'wtheme_media_wrapper', 9);
add_filter('widget_text', 'wtheme_media_wrapper', 9);

function wtheme_general_button($atts, $content = null) {
	extract(shortcode_atts(array('url'=>'#', 'external'=>false), $atts));
	$external = $external ? 'onclick="this.target=\'_blank\'"' : '';
	return '<a class="general_button" href="'.$url.'" '.$external.'>'.$content.'</a>';
}
add_shortcode('button', 'wtheme_general_button');
add_filter('widget_text', 'do_shortcode');

function wtheme_filter_widget_title_allow_tags($title) {
	$title = str_replace(array('[', ']'), array('<', '>'), $title);
	$title = strip_tags($title, '<a><br><span>');
	return $title;
}
add_filter('widget_title', 'wtheme_filter_widget_title_allow_tags');

function wtheme_activate_theme() {
	if (get_page_by_path('sample-page')) {
		$page = get_page_by_path('sample-page');
		wp_update_post(array('ID'=>$page->ID, 'post_content'=>wTheme::part('sample-page')));
	} else {
		$new_post = array(
			'post_content' => wTheme::part('sample-page'),
			'post_title' => 'Sample page',
			'post_type' => 'page',
			'post_status' => 'publish'
		);
		wp_insert_post($new_post, false);
	}

	if (!get_page_by_path('contact')) {
		$new_post = array(
			'post_content' => '[contact-form-7 title="Contact form 1"]',
			'post_title' => 'Contact',
			'post_type' => 'page',
			'post_status' => 'publish'
		);
		wp_insert_post($new_post, false);
	}
}
add_action('after_switch_theme', 'wtheme_activate_theme');

function wtheme_hide_update_notice() {
	remove_action('admin_notices', 'update_nag', 3);
	remove_action('network_admin_notices', 'update_nag', 3);
}
add_action('admin_notices', 'wtheme_hide_update_notice', 1);

function wtheme_filter_image_size_names_choose($sizes) {
	$new_sizes = array();
	$added_sizes = get_intermediate_image_sizes();
	foreach ($added_sizes as $key=>$size_name) {
		if (0 === strpos($size_name, wTheme::prefix('')) && '_2x' == substr($size_name, -3))
			continue;

		$label = wTheme::remove_prefix($size_name);
		$label = str_replace(array('_', '-'), ' ', $label);
		$new_sizes[$size_name] = ucfirst($label);
	}

	return array_merge($sizes, $new_sizes);
}
add_filter('image_size_names_choose', 'wtheme_filter_image_size_names_choose', 11, 1);

function wtheme_filter_wp_calculate_image_srcset($sources, $size_array) {
	list($width, $height) = $size_array;

	if (!isset($sources[$width]))
		return $sources;

	$new_sources = array();
	$new_sources[$width] = $sources[$width];
	$retina_width = $width * 2;

	if (isset($sources[$retina_width]))
		$new_sources[$retina_width] = $sources[$retina_width];

	if (1 == count($new_sources)) {
		$max_width = $width;
		foreach ($sources as $w=>$source)
			if ($w > $max_width)
				$max_width = $w;
		$new_sources[$max_width] = $sources[$max_width];
	}

	return $new_sources;
}
add_filter('wp_calculate_image_srcset', 'wtheme_filter_wp_calculate_image_srcset', 99, 2);

function wtheme__filter_tiny_mce_before_init($init) {
	$init['valid_elements'] = '*[*]';
	$init['extended_valid_elements'] = '*[*]';

	return $init;
}
add_filter('tiny_mce_before_init', 'wtheme__filter_tiny_mce_before_init');

function wtheme_template_include($file_template) {
	wtheme_scripts_styles();

	if (is_front_page() && is_page_template('default')) {
		wTheme::$layout = null;
	} elseif (is_page()) {
		$template = get_post_meta(get_queried_object_id(), '_wp_page_template', true);
		$templates = wSidebar::get_page_templates_layouts();
		if (isset($templates[$template]))
			wTheme::$layout = $templates[$template];
	} elseif (is_404()) {
		wTheme::$layout = 'full-width';
	}

	ob_start();
	require $file_template;
	$content_for_layout = ob_get_clean();

	if (false === wTheme::$layout)
		$content = $content_for_layout;
	else
		$content = wTheme::part('layout', compact('content_for_layout'), '');

	echo apply_filters('wtheme_template_include', $content);

	exit(0);
}
add_filter('template_include', 'wtheme_template_include', 999);

require_once get_template_directory().'/inc/init.php';

function setPostViews($postID) {
	if (is_user_logged_in())
		return;
	$countKey = 'post_views_count';
	$count = get_post_meta($postID, $countKey, true);
	if ('' == $count){
		$count = 0;
		delete_post_meta($postID, $countKey);
		add_post_meta($postID, $countKey, '0');
	} else {
		$count++;
		update_post_meta($postID, $countKey, $count);
	}
}

function wtheme_get_search_form() {
	$html = '<form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">
				<label>
					<span class="screen-reader-text">' . _x( 'Search for:', 'label' ) . '</span>
					<input type="search" class="search-field" placeholder="' . wtheme::__('Search after dating websites', 'wtheme' ) . '" value="' . get_search_query() . '" name="s" />
				</label>
				<input type="submit" class="search-submit" value="'. esc_attr_x( 'Search', 'submit button' ) .'" />
			</form>';
	return $html;
}
add_filter('get_search_form', 'wtheme_get_search_form');

function wtheme_divider($atts) {
	return '<div class="shortcode_divider"><span></span><div><h2>'.$atts["title"].'</h2><h3>'.$atts["subtitle"].'</h3></div></div>';
}
add_shortcode('divider', 'wtheme_divider');

function wtheme_shortcode_product($atts) {
	$ids = explode(",", $atts["id"]);
	$products_count =  count($ids);
	$s = isset($atts["s"]) ? $atts["s"] : '';
	if ($s) {
		$type = 'type_'.$s;
	} else {
		$type = NULL;
	}
	if (empty($ids))
		return false;

	ob_start();
	$args = [
		'post_type' => wProduct::$post_type,
		'post__in' => $ids,
		'orderby' => 'post__in',
		'posts_per_page' => $products_count,
	];
	$post_query = new WP_Query($args);
	if ($post_query->have_posts()) { ?>
		<div class="products_list">
			<?php while ($post_query->have_posts()) {$post_query->the_post(); ?>
				<?php
				$meta = wProduct::get_all_meta(get_the_ID());
				$price = $meta['price'] ?? '';
				$members = $meta['members'] ?? '';
				$external_link = $meta['external_link'] ?? '';
				$read_more_label = $meta['read_more'] ?? '';
				$review_link = $meta['review_link'] ?? '';
				$review_link_label = $meta['review_label'] ?? '';
				if ('' === $read_more_label)
					$read_more_label = wTheme::__('Visit the site');

				if ('' === $review_link_label)
					$review_link_label = wTheme::__('Review');
				?>
				<div class="product">
					<div class="thumb_box">
						<div class="thumb">
							<?php if (has_post_thumbnail()) { ?>
								<?php the_post_thumbnail(wTheme::prefix('product_thumb_columns')); ?>
							<?php } ?>
						</div>
					</div>
					<div class="info">
						<div class="price_box">
							<?php if ('' !== $price) { ?>
								<div class="price">
									<span><?= wTheme::__('Price'); ?></span>
									<?= $price; ?>
								</div>
							<?php } ?>
							<?php if ('' !== $members) { ?>
								<div class="members">
									<span><?= wTheme::__('Members'); ?></span>
									<?= $members; ?>
								</div>
							<?php } ?>
						</div>
						<ul class="bullets">
							<?php for ($i = 1; $i <= 3; $i++) { ?>
								<?php $bullet = $meta["bullet_{$i}"] ?? ''; ?>
								<?php if ('' !== $bullet) { ?>
									<li><?= $bullet; ?></li>
								<?php } ?>
							<?php } ?>
						</ul>
					</div>
					<div class="buttons">
						<?= wTheme::part('ratings'); ?>
						<?php if ('' !== $external_link) { ?>
							<?php if (!wtheme_is_affiliate_domains($external_link)) { ?>
								<a href="<?= $external_link; ?>" class="read_more" onclick="return !window.open(this.href);"><?= $read_more_label; ?></a>
							<?php } else { ?>
								<a href="#" class="read_more" onclick="return !window.open('<?= $external_link; ?>');" rel="nofollow"><?= $read_more_label; ?></a>
							<?php } ?>
						<?php } ?>
						<?php if ('' !== $review_link) { ?>
							<a href="<?= $review_link; ?>" class="review_link"><?= $review_link_label; ?></a>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</div>
	<?php }
	wp_reset_postdata();

	return ob_get_clean();
}
add_shortcode('product', 'wtheme_shortcode_product');

remove_filter('pre_user_description', 'wp_filter_kses');
add_filter( 'pre_user_description', 'wp_filter_post_kses');

function wtheme_mailchimp_subscribe($data) {
	$settings = wThemeSettings::get_option('Integrations.Mailchimp');
	if (empty($settings['api_key']) || empty($settings['list_id']))
		return wTheme::__('MailChimp settings error. Please contact to support.');

	$api_key = $settings['api_key'];
	$list_id = $settings['list_id'];
	$md5_email = md5($data['email']);
	$base_url = 'https://<dc>.api.mailchimp.com/3.0';
	$dc = substr($api_key, strpos($api_key, '-') + 1);
	$base_url = str_replace('<dc>', $dc, $base_url);
	$url = $base_url."/lists/{$list_id}/members/{$md5_email}";

	$body = json_encode(array(
		'email_address' => $data['email'],
		'status' => 'subscribed',
	));

	$ch = curl_init($url);

	curl_setopt($ch, CURLOPT_USERPWD, 'user:'.$api_key);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

	$response = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);

	$response = @json_decode($response, true);

	if (200 !== $httpCode && isset($response['detail']))
		return $response['detail'];

	$redirect_location = "Location:". home_url('/').'tak/';
	header($redirect_location);
//	die();
	return true;
}

function wtheme_is_affiliate_domains($url) {
	$affiliate_domains = wThemeSettings::get_option('Special.affiliate_domains');
	if ('' !== $affiliate_domains) {
		$affiliate_domains = explode(',', trim($affiliate_domains, ','));
		$affiliate_domains = array_map('trim', $affiliate_domains);

		$href_result = parse_url($url);
		foreach ($affiliate_domains as $affiliate_domain) {
			if ($href_result['host'] === $affiliate_domain || false !== strpos($url, $affiliate_domain))
				return true;
		}
	}
	return false;
}

function wtheme_auto_nofollow_callback($matches) {
	$link = $matches[0];
	if (empty($matches[1]))
		return $link;

	$site_url = get_bloginfo('url');
	$site_url_result = parse_url($site_url);
	$href = $matches[1];
	$href_result = parse_url($href);
	if (empty($href_result['host']) || $site_url_result['host']===$href_result['host'])
		return $link;

	if (!wtheme_is_affiliate_domains($href)) {
		$link = preg_replace('/(rel|onclick)\s*=\s*[\'"][^\'"]*[\'"]/i', '', $link);
		return preg_replace('/href\s*=\s*[\'"][^\'"]*[\'"]/i', 'href="'.$href.'" onclick="return !window.open(this.href);"', $link);
	} else {
		$link = preg_replace('/(rel|onclick)\s*=\s*[\'"][^\'"]*[\'"]/i', '', $link);
		return preg_replace('/href\s*=\s*[\'"][^\'"]*[\'"]/i', 'href="#" onclick="return !window.open(\''.$href.'\');" rel="nofollow"', $link);
	}
//	$rel = false===strpos($href, 'partner-ads.com') ? '' : ' rel="nofollow"';
//	$link = preg_replace('/(rel|onclick\s*=\s*[\'"]([^\'"]*)[\'"])/i', '', $link);
//	return preg_replace('/(href\s*=\s*[\'"]([^\'"]*)[\'"])/i', 'href="#" onclick="return !window.open(\''.$href.'\');"'.$rel, $link);
}

function wtheme_filter__the_content__nofollow($content) {
	return preg_replace_callback('/<a\s[^>]*?href\s*=\s*[\'"]([^\'"]*)[\'"]+[^>]*>/is', 'wtheme_auto_nofollow_callback', $content);
}
add_filter('widget_text', 'wtheme_filter__the_content__nofollow', 99);
add_filter('the_content', 'wtheme_filter__the_content__nofollow', 99);

function lavEnh2Liste($atts) {
	//global $post;
	//preg_match_all( '|<h[2^>]+>(.*)</h[2^>]+>|iU', $post->post_content, $headings );
	//$i=1;

	$output = '<ul class="list_links">';

	//foreach ($headings[0] as $heading) {
	//	$output .= '<li><span>'.$i.'</span><a href="#h2anchor_'.$i.'">'.str_replace(array('<h2>', '</h2>'),'', $heading).'</a></li>';
	//	$i++;
	//}
	$output .= '</ul>';
	return $output;
}
add_shortcode('h2liste', 'lavEnh2Liste');
