<?php
class wCase extends wCustomPostType {

	static $post_type;

	static $ajax_posts_per_page = -1;

	static $order_options = array(
		'date__DESC' => 'Newest in top',
		'date__ASC' => 'Oldest in top',
		'title__ASC' => 'Alfabetical A-Z',
		'title__DESC' => 'Alfabetical Z-A',
		'is_open_case' => 'Only open cases',
		'not_is_open_case' => 'No open cases',
	);

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Case', 'Cases');
	}

	function register_post_type($args = array()) {
		$slug = 'case';
		if ($page = wTheme::get_page_by_template('cases-list'))
			$slug = $page->post_name;

		parent::register_post_type(
			array(
				'exclude_from_search' => true,
				'rewrite' => array('slug'=>$slug, 'with_front'=>false),
			)
		);
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('partners'), wTheme::__('Case partners'), array($this, 'meta_box__partners'), $post->post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('contact'), wTheme::__('Case contact'), array($this, 'meta_box__contact'), $post->post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('resume'), wTheme::__('Case resume'), array($this, 'meta_box__resume'), $post->post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('result'), wTheme::__('Case result'), array($this, 'meta_box__result'), $post->post_type, 'advanced', 'low');
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box__additional_fields'), $post->post_type, 'side', 'low');
	}

	function meta_box__partners($post) {
		$name = 'partners_content';
		$meta_key = wTheme::prefix($name);
		$content = get_post_meta($post->ID, $name, true);
		$this->nonce_field($meta_key);
		wp_editor($content, $name, array('textarea_name'=>$this->field_name($name, $meta_key, true), 'textarea_rows'=>'7'));
	}

	function meta_box__contact($post) {
		$name = 'contact_content';
		$meta_key = wTheme::prefix($name);
		$content = get_post_meta($post->ID, $name, true);
		$this->nonce_field($meta_key);
		wp_editor($content, $name, array('textarea_name'=>$this->field_name($name, $meta_key, true), 'textarea_rows'=>'7'));
	}

	function meta_box__resume($post) {
		$name = 'resume_content';
		$meta_key = wTheme::prefix($name);
		$content = get_post_meta($post->ID, $name, true);
		$this->nonce_field($meta_key);
		wp_editor($content, $name, array('textarea_name'=>$this->field_name($name, $meta_key, true)));
	}

	function meta_box__result($post) {
		$name = 'result_content';
		$meta_key = wTheme::prefix($name);
		$content = get_post_meta($post->ID, $name, true);
		$this->nonce_field($meta_key);
		wp_editor($content, $name, array('textarea_name'=>$this->field_name($name, $meta_key, true)));
	}

	function meta_box__additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<input type="hidden" name="<?php $this->field_name('is_open_case', $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name('is_open_case', $meta_key); ?>" value="1" <?php checked(@$data['is_open_case']); ?> id="is_open_case" /> <?php wTheme::_e('Open case'); ?></label>
		</p>
		<?php
	}

	function action__save_post($post_id) {
		parent::action__save_post($post_id);
		$this->save_meta_data($post_id, wTheme::prefix('partners_content'));
		$this->save_meta_data($post_id, wTheme::prefix('contact_content'));
		$this->save_meta_data($post_id, wTheme::prefix('resume_content'));
		$this->save_meta_data($post_id, wTheme::prefix('result_content'));
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

	static function ajax_wp_query($args = array()) {
		$defaults = array(
			'orderby' => 'date',
			'order' => 'DESC',
			'posts_per_page' => self::$ajax_posts_per_page,
		);

		$args = wp_parse_args($args, $defaults);

		$filters = null;
		if (!empty($_REQUEST)) {
			$filters = @$_REQUEST;
			if (!session_id())
				session_start();
			$session_key = self::$post_type.'-filters';
			$_SESSION[$session_key] = $filters;
		}
		if (empty($filters))
			return self::wp_query($args);

		$meta_query = array();
		$tax_query = array();

		if ('' !== @$filters['search']) {
			$args['s'] = $filters['search'];
		}

		if (!empty($filters['term_ids'])) {
			$tax_query[] = array(
				'taxonomy' => wCaseCategory::$taxonomy,
				'field' => 'term_id',
				'terms' => $filters['term_ids'],
			);
		}

		if (!empty($filters['order'])) {
			$r = explode('__', $filters['order']);
			if (count($r) > 1) {
				$args['orderby'] = $r[0];
				$args['order'] = $r[1];
			} else if ('is_open_case' === $filters['order']) {
				$meta_query[] = array(
					'key' => 'is_open_case',
					'value' => '1',
				);
			} else if ('not_is_open_case' === $filters['order']) {
				$meta_query[] = array(
					'key' => 'is_open_case',
					'value' => '0',
				);
			}
		}

		if (isset($filters['is_load_more'])) {
			$args['posts_per_page'] = self::$ajax_posts_per_page;
			$args['offset'] = $filters['is_load_more'];
		}

		if (!empty($args['meta_query'])) {
			$args['meta_query'][] = $meta_query;
		} else if (!empty($meta_query)) {
			$meta_query['relation'] = 'AND';
			$args['meta_query'] = $meta_query;
		}

		if (!empty($args['tax_query'])) {
			$args['tax_query'][] = $tax_query;
		} else if (!empty($tax_query)) {
			$tax_query['relation'] = 'AND';
			$args['tax_query'] = $tax_query;
		}

		//var_dump($args);die;
		return self::wp_query($args);
	}

	static function get_items_response($query_args = array()) {
		$posts_query = self::ajax_wp_query($query_args);
		$found_items_text = wTheme::__('Recent cases');
		$response = array();
		$response['request'] = $_REQUEST;
		if($posts_query->have_posts()) {
			if ('1' === @$_REQUEST['is_changed']) {
				$found_replace = sprintf(_n('%d case', '%d cases', $posts_query->found_posts, wTheme::$domain), $posts_query->found_posts);
				$found_items_text = wTheme::__('Result: %s matches your search...', '<span>'.$found_replace.'</span>');
			}
			while ($posts_query->have_posts()) { $posts_query->the_post();
				$response['items'][] = wTheme::part('case');
			}
			wp_reset_postdata();
		} else {
			$found_items_text = wTheme::__('Nothing found');
		}
		/*else {
			$response['items'][] = wTheme::part('food_box/no_items');
		}*/
		$response['found_items_text'] = $found_items_text;

		return $response;
	}

	static function is_ajax() {
		return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
	}
}