<?php
/**
 * $settings = wThemeSettings::get_option('Header');
 * Version: 1.0.0
 */

class wThemeSettings {

	static $options = array();

	static $option_key = 'settings';

	static $favicon_intermediate_sizes = array(
		'desktop_favicon' => array(16, 16, true),
		'tablet_favicon' => array(72, 72, true),
		'mobile_favicon' => array(57, 57, true),
	);

	static $contacts = array(
		'skype' => 'Skype',
		'email' => 'E-mail',
		'phone' => 'Phone',
		'phone2' => 'Phone 2',
	);

	static $share_on_sites = array(
		'facebook' => 'Facebook',
		'twitter' => 'Twitter',
		'google_plus' => 'Google+',
		'linkedin' => 'LinkedIn',
		//'pinterest' => 'Pinterest',
	);

	static $social_urls = array(
		'facebook' => 'Facebook',
		'twitter' => 'Twitter',
		'google_plus' => 'Google+',
		'linkedin' => 'LinkedIn',
		'instagram' => 'Instagram',
		'youtube' => 'YouTube',
		'vimeo' => 'Vimeo',
		'pinterest' => 'Pinterest',
		'bloglovin' => 'Bloglovin',
	);

	static function construct() {
		add_action('after_switch_theme', array(__CLASS__, 'action__after_switch_theme'));
		add_action('admin_menu', array(__CLASS__, 'action__admin_menu'));
		add_action('wp_head', array(__CLASS__, 'action__wp_head'));
		add_action('wp_footer', array(__CLASS__, 'action__wp_footer'));

		$remove_query_strings = self::get_option('Optimization.remove_query_strings');
		if ('1' === $remove_query_strings && !is_admin()) {
			add_filter('script_loader_src', array(__CLASS__, 'filter_loader_src_remove_query_ver'), 999);
			add_filter('style_loader_src', array(__CLASS__, 'filter_loader_src_remove_query_ver'), 999);
		}

		$move_js_css_to_footer = self::get_option('Optimization.move_js_css_to_footer');
		if ('1' === $move_js_css_to_footer && !is_admin()) {
			remove_action('wp_head', 'wp_print_styles', 8);
			remove_action('wp_footer', 'wp_print_styles', 1);
			add_action('wp_head', array(__CLASS__, 'action__wp_head__move_js_to_footer'), 1);
		}
	}

	static function action__after_switch_theme() {
		$settings = self::get_option('all');
		if(!empty($settings))
			return $settings;

		self::update_option(self::$option_key, self::get_default_settings());
	}

	static function get_default_settings() {
		return array(
			'General' => array(
				'favicon_attachment_id' => '',
				'custom_css' => '',
				'Body' => array(
					'top_custom_code' => '',
					'bottom_custom_code' => '',
					'background_attachment_id' => '',
					'responsive_background_attachment_id' => '',
				)
			),
			'Header' => array(
				'site_logo' => array(
					'attachment_id' => '',
					'alt' => '',
					'slogan' => '',
				),
				'content' => '',
				'custom_code' => '',
			),
			'Footer' => array(
				'content' => '',
			),
			'Optimization' => array(
				'remove_query_strings' => '',
				'move_js_css_to_footer' => '',
			),
  			'Integrations' => array(
				'GoogleMaps' => array(
					'api_key' => '',
				)
			),
		);
	}

	static function apply_substitutions($content) {
		preg_match_all('/\[([\w_-]+)\]/U', $content, $res);
		$shortcodes = array_unique($res[1]);

		$substitutions = array();
		foreach ($shortcodes as $shortcode) {
			switch ($shortcode) {
				case 'site_name':
					$substitutions["[{$shortcode}]"] = get_bloginfo('name');
					break;
				case 'current_year':
					$substitutions["[{$shortcode}]"] = current_time('Y');
					break;
			}
		}

		return str_replace(array_keys($substitutions), array_values($substitutions), $content);
	}

	static function get_option($option_name, $default = false) {
		$option = self::$options;
		if (0 === count(self::$options))
			$option = get_option(wTheme::prefix(self::$option_key), $default);

		if ('all' === $option_name)
			return $option;

		if (isset($option['Footer']['content']))
			$option['Footer']['content'] = self::apply_substitutions($option['Footer']['content']);

		$names = explode('.', $option_name);
		if (count($names) > 1) {
			foreach ($names as $name) {
				if (!isset($option[$name]))
					return $default;
				$option = $option[$name];
			}
		} else {
			$option = @$option[$option_name];
		}

		return $option;
	}

	static function update_option($option, $new_value) {
		return update_option(wTheme::prefix($option), $new_value);
	}

	static function show_option($option_name, $default = false) {
		$value = self::get_option($option_name, $default);
		if (!empty($value))
			echo $value;
	}

	static function action__admin_menu() {
		$title = wTheme::__('Theme settings');
		$page = add_theme_page($title, $title, 'manage_options', wTheme::prefix('settings'), array(__CLASS__, 'settings'));
		add_action("load-{$page}", array(__CLASS__, 'check_theme_support'));
		add_action("admin_print_scripts-{$page}", array(__CLASS__, 'action__admin_print_scripts'));
		add_action("admin_print_styles-{$page}", array(__CLASS__, 'action__admin_print_styles'));

		$title = wTheme::__('Theme support');
		$menu_slug = wTheme::prefix('support');
		add_theme_page($title, $title, 'manage_options', $menu_slug, array(__CLASS__, 'support'));
		remove_submenu_page('themes.php', $menu_slug);
	}

	static function action__admin_print_scripts() {
		wp_enqueue_script('jquery-ui-tabs', false, array('jquery'));
		wp_enqueue_script(wTheme::prefix('functions'), wTheme::$admin_dir_uri.'/js/functions.js', array('jquery'));
	}

	static function action__admin_print_styles() {
		wp_enqueue_style(wTheme::prefix('style'),  wTheme::$admin_dir_uri.'/style.css');
	}

	static function add_favicon_sizes() {
		foreach (self::$favicon_intermediate_sizes as $name=>$size)
			wTheme::add_image_size($name, $size[0], $size[1], $size[2]);
	}

	static function check_theme_support() {
		$theme_support = get_option(wTheme::prefix('theme_support'));
		if (empty($theme_support)) {
			wp_redirect(admin_url('themes.php?page='.wTheme::prefix('support')));
			exit(0);
		}
	}

	static function settings() {
		global $title;
		$saved = false;

		if (!empty($_POST['data'])) {
			$data = stripslashes_deep($_POST['data']);

			if (!empty($data['Social']['URL'])) {
				$urls = &$data['Social']['URL'];
				foreach ($urls as $key=>$url) {
					if ('' !== $url && '#' !== $url && false === strpos($url, '://') && false === strpos($url, 'javascript:'))
						$urls[$key] = "https://{$url}";
				}
			}

			$favicon_attachment_id = self::get_option('General.favicon_attachment_id');
			if ($favicon_attachment_id != $data['General']['favicon_attachment_id']) {
				self::add_favicon_sizes();
				wtheme_regenerate_attachment_thumbnails($data['General']['favicon_attachment_id']);
			}

			self::update_option(self::$option_key, $data);
			self::$options = array();
			$data = self::get_option('all');
			$saved = true;
		} else {
			$data = self::get_option('all');
		}

		$theme_support = get_option(wTheme::prefix('theme_support'));
		wp_enqueue_media();
		?>
		<?php if ($saved) { ?>
			<div id="message" class="updated"><p><strong><?php wTheme::_e('Settings saved.'); ?></strong></p></div>
		<?php } ?>
		<div class="wrap" id="wtheme-settings">
			<h2><?php echo $title; ?></h2>
			<script>
				jQuery(function() {
					var $form = jQuery('.settings');
					var $ul_tabs = jQuery('.nav-tabs-wrapper ul');

					jQuery(".nav-tabs-wrapper").tabs({
						activate: function( event, ui ) {
							var hash = jQuery(ui.newTab.get(0)).find('a').attr('href');
							$form.attr('action', hash);
							window.location.hash = hash;
							window.scrollTo(0, 0);
							$ul_tabs.hide();
						}
					});

					jQuery('.nav-tabs_wrap > div').click(function(){
						$ul_tabs.toggle();
					});

					jQuery('body').click(function(e){
						if (jQuery(e.target).parents('.nav-tabs_wrap').length === 0){
							$ul_tabs.hide();
						}
					});
				});
			</script>
			<form action="" method="post" class="settings">
				<div class="nav-tabs-wrapper">
					<div class="nav-tabs_wrap">
						<div><?php wTheme::_e('Menu'); ?></div>
						<ul class="nav-tabs">
							<li class="nav-tab"><a href="#general"><?php wTheme::_e('General'); ?></a></li>
							<li class="nav-tab"><a href="#header"><?php wTheme::_e('Header'); ?></a></li>
							<li class="nav-tab"><a href="#footer"><?php wTheme::_e('Footer'); ?></a></li>
							<?php if ('1' === @$theme_support['Slider']['settings']) { ?>
								<li class="nav-tab"><a href="#slider"><?php wTheme::_e('Slider'); ?></a></li>
							<?php } ?>
							<?php if ('1' === @$theme_support['Home']['settings']) { ?>
								<li class="nav-tab"><a href="#home"><?php wTheme::_e('Home'); ?></a></li>
							<?php } ?>
							<?php if ('1' === @$theme_support['Contacts']['settings']) { ?>
								<li class="nav-tab"><a href="#contacts"><?php _ex('Contact', 'theme_settings', wTheme::$domain); ?></a></li>
							<?php } ?>
							<?php if ('1' === @$theme_support['Social']['settings']) { ?>
								<li class="nav-tab"><a href="#social"><?php wTheme::_e('Social'); ?></a></li>
							<?php } ?>
							<li class="nav-tab"><a href="#optimization"><?php wTheme::_e('Optimization'); ?></a></li>
							<li class="nav-tab"><a href="#integrations"><?php wTheme::_e('Integrations'); ?></a></li>
							<?php if ('1' === @$theme_support['Special']['settings']) { ?>
								<li class="nav-tab"><a href="#special_features"><?php wTheme::_e('Special features'); ?></a></li>
							<?php } ?>
						</ul>
					</div>
					<div class="nav-fields-wrap">
						<div id="general">
							<?php $section = 'General'; ?>
							<h2 class="title"><?php wTheme::_e('General settings'); ?></h2>
							<table class="form-table">
								<tr valign="top">
									<?php $field = 'favicon_attachment_id'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Favicon'); ?></label></th>
									<td>
										<?php echo wTheme::get_media_popup_field("data[{$section}][{$field}]", @$data[$section][$field], false, array('id'=>$id)); ?>
										<p class="description"><?php wTheme::_e('Must be .png 256 x 256 px'); ?></p>
									</td>
								</tr>
								<tr valign="top">
									<?php $field = 'custom_css'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Custom styles code'); ?></label></th>
									<td>
										<textarea name="<?php echo "data[{$section}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data[$section][$field]); ?></textarea>
										<p class="description"><?php wTheme::_e('Paste custom CSS code here.'); ?></p>
									</td>
								</tr>
								<?php $meta_key = 'Body'; ?>
								<tr valign="top">
									<?php $field = 'top_custom_code'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Custom code'); ?></label></th>
									<td>
										<p class="example"><?php wTheme::_e('Insert custom code after open "&lt;body&gt;" tag.'); ?></p>
										<textarea name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data[$section][$meta_key][$field]); ?></textarea>
										<p class="description"><?php wTheme::_e('Paste Facebook or other code.'); ?></p>
									</td>
								</tr>
								<tr valign="top">
									<?php $field = 'bottom_custom_code'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Custom code'); ?></label></th>
									<td>
										<p class="example"><?php wTheme::_e('Insert custom code before closing "&lt;/body&gt;" tag.'); ?></p>
										<textarea name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data[$section][$meta_key][$field]); ?></textarea>
									</td>
								</tr>
								<tr valign="top">
									<th colspan="2"><label><?php wTheme::_e('Landscape'); ?></label></th>
								</tr>
								<tr valign="top">
									<?php $field = 'background_attachment_id'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Background image'); ?></label></th>
									<td>
										<?php
											$before_image = '<span class="example">'.wTheme::__('For desktop and tablets in landscape mode (usually 769 px and more in device-width)').'</span>';
											$args = array('id'=>$id, 'before_image'=>$before_image);
											echo wTheme::get_media_popup_field("data[{$section}][{$meta_key}][{$field}]", @$data[$section][$meta_key][$field], false, $args);
										?>
									</td>
								</tr>
								<tr valign="top">
									<th colspan="2"><label><?php wTheme::_e('Portrait'); ?></label></th>
								</tr>
								<tr valign="top">
									<?php $field = 'responsive_background_attachment_id'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Background image'); ?></label></th>
									<td>
										<?php
											$before_image = '<span class="example">'.wTheme::__('For smartphones and tablets in portrait mode (usually 768 px and less in device-width)').'</span>';
											$args = array('id'=>$id, 'before_image'=>$before_image);
											echo wTheme::get_media_popup_field("data[{$section}][{$meta_key}][{$field}]", @$data[$section][$meta_key][$field], false, $args);
										?>
										<p class="description"><?php wTheme::_e('NOTE: If no portrait image selected, your landscape image will be used in both modes.'); ?></p>
									</td>
								</tr>
							</table>
						</div>
						<div id="header">
							<?php $section = 'Header'; ?>
							<h2 class="title"><?php wTheme::_e('Header'); ?></h2>
							<table class="form-table">
								<?php $meta_key = 'site_logo'; ?>
								<tr valign="top">
									<?php $field = 'attachment_id'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo'); ?></label></th>
									<td>
										<div style="width: 250px;">
											<?php echo wTheme::get_media_popup_field("data[{$section}][{$meta_key}][{$field}]", @$data[$section][$meta_key][$field], false, array('id'=>$id)); ?>
										</div>
									</td>
								</tr>
								<tr valign="top">
									<?php $field = 'alt'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo alt text'); ?></label></th>
									<td><input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" /></td>
								</tr>
								<tr valign="top">
									<?php $field = 'slogan'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo slogan'); ?></label></th>
									<td><input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" /></td>
								</tr>
								<tr valign="top">
									<?php $field = 'content'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Content'); ?></label></th>
									<td><textarea name="<?php echo "data[{$section}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="5"><?php echo esc_textarea(@$data[$section][$field]); ?></textarea></td>
								</tr>
								<tr valign="top">
									<?php $field = 'custom_code'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Custom code'); ?></label></th>
									<td>
										<p class="example"><?php wTheme::_e('Insert custom code before closing "&lt;/head&gt;" tag.'); ?></p>
										<textarea name="<?php echo "data[{$section}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data[$section][$field]); ?></textarea>
										<p class="description"><?php wTheme::_e('Paste Google Analytics or other tracking, meta tags or javascripts.'); ?></p>
									</td>
								</tr>
							</table>
						</div>
						<div id="footer">
							<?php $section = 'Footer'; ?>
							<h2 class="title"><?php wTheme::_e('Footer'); ?></h2>
							<table class="form-table">
								<?php $meta_key = 'site_logo'; ?>
								<?php if ('1' === @$theme_support['Footer']['site_logo']) { ?>
								<tr valign="top">
									<?php $field = 'attachment_id'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo'); ?></label></th>
									<td>
										<div style="width: 250px;">
											<?php echo wTheme::get_media_popup_field("data[{$section}][{$meta_key}][{$field}]", @$data[$section][$meta_key][$field], false, array('id'=>$id)); ?>
										</div>
									</td>
								</tr>
								<tr valign="top">
									<?php $field = 'alt'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo alt text'); ?></label></th>
									<td><input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" /></td>
								</tr>
								<tr valign="top">
									<?php $field = 'slogan'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo slogan'); ?></label></th>
									<td><input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" /></td>
								</tr>
								<?php } ?>
								<tr valign="top">
									<?php $field = 'content'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Content'); ?></label></th>
									<td>
										<h5><?php wTheme::_e('Shortcodes'); ?></h5>
										<table class="widefat shortcodes" cellspacing="0">
											<?php
												$shortcodes = array(
													'site_name'  => array(
														'title' => 'Site Name',
														'example' => get_bloginfo('name'),
													),
													'current_year' => array(
														'title' => 'Current Year',
														'example' => current_time('Y'),
													),
												);
												$k = 0;
											?>
											<?php foreach ($shortcodes as $shortcode=>$info) { ?>
												<tr <?php if (0 === $k++ % 2) echo 'class="alternate"'; ?>>
													<td><?php wTheme::_e($info['title']); ?></td>
													<td class="shortcode">[<?php echo $shortcode; ?>]</td>
													<td><span class="description"><?php echo $info['example']; ?></span></td>
												</tr>
											<?php } ?>
										</table><br />
										<textarea name="<?php echo "data[{$section}][{$field}]"; ?>" id="<?php echo $id; ?>" class="code" cols="80" rows="3"><?php echo esc_textarea(@$data[$section][$field]); ?></textarea>
										<p class="description"><?php wTheme::_e('Enter website contact details (text/html) allowed.'); ?></p>
										<style>
											.widefat.shortcodes {
												max-width: 670px;
											}
											.widefat.shortcodes tr:hover td {
												color: red;
											}
											.widefat.shortcodes td {
												padding: 4px 7px;
												cursor: pointer;
											}
										</style>
										<script>
											var last_element;

											jQuery('#Footer_content').focus(function() {
												last_element = this;
											});
											jQuery('.shortcodes tr').click(function() {
												if (!last_element)
													return;
												var shortcode = jQuery(this).find('td.shortcode').text();

												(function () {
													if (document.selection) {
														//For browsers like Internet Explorer
														this.focus();
														document.selection.createRange().text = shortcode;
														this.focus();
													}
													else if (this.selectionStart || this.selectionStart == '0') {
														//For browsers like Firefox and Webkit based
														var startPos = this.selectionStart;
														var endPos = this.selectionEnd;
														var scrollTop = this.scrollTop;
														this.value = this.value.substring(0, startPos)+shortcode+this.value.substring(endPos,this.value.length);
														this.focus();
														this.selectionStart = this.selectionEnd = startPos + shortcode.length;
														this.scrollTop = scrollTop;
													} else {
														this.value += shortcode;
														this.focus();
													}
												}).call(last_element);

												return false;
											});
										</script>
									</td>
								</tr>
							</table>
						</div>
						<?php if ('1' === @$theme_support['Slider']['settings']) { ?>
							<div id="slider">
								<?php
								$section = 'Slider';
								$meta_key = 'settings';
								$transitions = array(
									'fade' => 'Fade',
									'fadeout' => 'Fade Out',
									'scrollHorz' => 'Slide Horizontal',
									'scrollVert' => 'Slide Vertical',
									'tile' => 'Slide Tile',
									'blind' =>' Slide Blind'
								);
								if (!isset($data['Slider']['settings']['speed']))
									$data['Slider']['settings']['speed'] = '600';
								if (!isset($data['Slider']['settings']['timeout']))
									$data['Slider']['settings']['timeout'] = '0';
								if (!isset($data['Slider']['settings']['tile_count']))
									$data['Slider']['settings']['tile_count'] = '12';
								?>
								<h2 class="title"><?php wTheme::_e('Slider'); ?></h2>
								<table class="form-table">
									<tr valign="top">
										<th scope="row"><label><?php wTheme::_e('Slider size'); ?></label></th>
										<td>
											<?php $field = 'width'; $id = "{$section}_{$field}"; ?>
											<label for="<?php echo $id; ?>"><?php wTheme::_e('Width'); ?></label>
											<input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" class="small-text" value="<?php echo esc_attr(@$data[$section][$meta_key]['width']); ?>" id="<?php echo $id; ?>" />

											<?php $field = 'height'; $id = "{$section}_{$field}"; ?>
											<label for="<?php echo $id; ?>"><?php wTheme::_e('Height'); ?></label>
											<input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" class="small-text" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" /><br />

											<?php $field = 'crop'; $id = "{$section}_{$field}"; ?>
											<input type="hidden" name="data[crop]" value="0" /><br />
											<label for="<?php echo $id; ?>"><input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" /> <?php wTheme::_e("Use \"crop\" function for upload images"); ?></label>
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'transition'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="transition"><?php wTheme::_e('Transition effect'); ?></label></th>
										<td>
											<select name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" id="<?php echo $id; ?>">
												<?php foreach ($transitions as $transition=>$label) { ?>
													<option value="<?php echo $transition; ?>" <?php selected(@$data[$section][$meta_key][$field], $transition); ?>><?php echo $label; ?></option>
												<?php } ?>
											</select>
											<span class="description"><?php wTheme::_e("Effect between slide images."); ?></span>
											<span style="display:none;" id="tile_count_wrap">
												<br /><br />
												<?php $field = 'tile_count'; ?>
												<label for="tile_count"><?php wTheme::_e('Tile count'); ?></label><br />
												<input type="number" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" class="small-text" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="tile_count" />
											</span>
										</td>
										<script>
											jQuery(function(){
												jQuery('#<?php echo $id; ?>').change(function () {
													jQuery('#tile_count_wrap').toggle('tile' == jQuery(this).val() || 'blind' == jQuery(this).val());
												}).change();
											});
										</script>
									</tr>
									<tr valign="top">
										<?php $field = 'speed'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Speed (ms)'); ?></label></th>
										<td>
											<input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" class="small-text" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" />
											<span class="description"><?php wTheme::_e("Speed of the transition (any valid fx speed value)."); ?></span>
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'timeout'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Timeout (ms)'); ?></label></th>
										<td>
											<input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" class="small-text" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" />
											<span class="description"><?php wTheme::_e("Milliseconds between slide transitions (0 to disable auto advance)."); ?></span>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row"><label><?php wTheme::_e('Order slides by'); ?></label></th>
										<td>
											<?php $field = 'order_field'; $id = "{$section}_{$field}"; ?>
											<?php $order_fields = array('menu_order'=>"Order number", 'post_date'=>'Date', 'rand'=>'Random'); ?>
											<select name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" id="order">
												<?php foreach ($order_fields as $key=>$label) { ?>
													<option value="<?php echo $key; ?>" <?php selected(@$data[$section][$meta_key][$field], $key); ?>><?php wTheme::_e($label); ?></option>
												<?php } ?>
											</select>
											<?php $field = 'order_direction'; $id = "{$section}_{$field}"; ?>
											<select name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" id="order_direction">
												<option value="asc" <?php selected(@$data[$section][$meta_key][$field], 'asc'); ?>><?php wTheme::_e('Ascending'); ?></option>
												<option value="desc" <?php selected(@$data[$section][$meta_key][$field], 'desc'); ?>><?php wTheme::_e('Descending'); ?></option>
											</select>
											<script>
												jQuery(function(){
													jQuery('#order').change(function () {
														jQuery('#order_direction').toggle('rand' != jQuery(this).val());
													}).change();
												});
											</script>
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'show_slide_text'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Show slide text'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'show_pagination'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Show pagination'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'show_navigation'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Show navigation'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
											<span class="description"><?php wTheme::_e("Show Previous/Next buttons."); ?></span>
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'show_navigation_menu'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Show navigation menu'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'pause'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Pause on hover'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
										</td>
									</tr>
									<tr valign="top">
										<?php $field = 'use_swipe'; $id = "{$section}_{$field}"; ?>
										<th scope="row"><label for="<?php echo $id; ?>"><?php wTheme::_e('Use swipe'); ?></label></th>
										<td>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="0" />
											<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="1" <?php checked(esc_attr(@$data[$section][$meta_key][$field])); ?> id="<?php echo $id; ?>" />
											<span class="description"><?php wTheme::_e("This effect only works for mobile devices."); ?></span>
										</td>
									</tr>
								</table>
							</div>
						<?php } ?>
						<?php if ('1' === @$theme_support['Home']['settings']) { ?>
						<div id="home">
							<h2 class="title"><?php wTheme::_e('Home'); ?></h2>
						</div>
						<?php } ?>
						<?php if ('1' === @$theme_support['Contacts']['settings']) { ?>
						<div id="contacts">
							<?php $section = 'Contacts'; ?>
							<h2 class="title"><?php wTheme::_e('Contact'); ?></h2>
							<table class="form-table">
								<?php foreach (self::$contacts as $field=>$label) { ?>
									<tr valign="top">
										<?php $id = "{$section}_{$field}"; ?>
										<th><label for="<?php echo $id; ?>"><?php wTheme::_e($label); ?></label></th>
										<td>
											<span class="icon <?php echo $field ?>">
												<input type="text" name="<?php echo "data[{$section}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$field]); ?>" id="<?php echo $id ?>" class="regular-text" />
											</span>
										</td>
									</tr>
									<?php if ('email' === $field) { ?>
										<tr valign="top">
											<?php $field = 'email_subject'; $id = "{$section}_{$field}"; ?>
											<th><label for="<?php echo $id; ?>"><?php wTheme::_e('E-mail subject'); ?></label></th>
											<td>
											<span class="icon <?php echo $field; ?>">
												<input type="text" name="<?php echo "data[{$section}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" />
											</span>
											<p class="description"><?php wTheme::_e('Share on email "subject" text'); ?></p>
											</td>
										</tr>
									<?php } ?>
								<?php } ?>
							</table>
						</div>
						<?php } ?>
						<?php if ('1' === @$theme_support['Social']['settings']) { ?>
						<div id="social">
							<?php $section = 'Social'; ?>
							<h2 class="title"><?php wTheme::_e('Social'); ?></h2>
							<?php if ('1' === @$theme_support['Social']['share']) { ?>
							<h3><?php wTheme::_e('Share buttons'); ?></h3>
							<table class="form-table">
								<?php $meta_key = 'Share'; ?>
								<tr valign="top">
									<th><label><?php wTheme::_e('Use share buttons'); ?></label></th>
									<td class="share_buttons">
										<?php $field = 'is_use'; $id = "{$section}_{$meta_key}_{$field}"; ?>
										<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo @$data[$section][$meta_key][$field]; ?>" id="<?php echo $id; ?>" />
										<?php foreach (self::$share_on_sites as $field=>$title) { ?>
										<p>
											<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][buttons][{$field}]"; ?>" value="0" />
											<label>
												<input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][buttons][{$field}]"; ?>" <?php checked(@$data[$section][$meta_key]['buttons'][$field], '1'); ?> value="1" />
												<?php wTheme::_e($title); ?>
											</label>
										</p>
										<?php } ?>
									</td>
								</tr>
								<?php foreach (array('post', 'page') as $post_type) { ?>
									<tr valign="top" class="post_options disabled">
										<th><label><?php printf(wTheme::__('Use for %s'), _x(ucfirst($post_type), 'theme_settings_share', wTheme::$domain)); ?></label></th>
										<td>
											<p>
												<?php $field = 'before_content'; ?>
												<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][post_types][{$post_type}][{$field}]"; ?>" value="0" />
												<label><input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][post_types][{$post_type}][{$field}]"; ?>" <?php checked(@$data[$section][$meta_key]['post_types'][$post_type][$field], '1'); ?> value="1" /> <?php wTheme::_e('Before content'); ?></label>
											</p>
											<p>
												<?php $field = 'after_content'; ?>
												<input type="hidden" name="<?php echo "data[{$section}][{$meta_key}][post_types][{$post_type}][{$field}]"; ?>" value="0" />
												<label><input type="checkbox" name="<?php echo "data[{$section}][{$meta_key}][post_types][{$post_type}][{$field}]"; ?>" <?php checked(@$data[$section][$meta_key]['post_types'][$post_type][$field], '1'); ?> value="1" /> <?php wTheme::_e('After content'); ?></label>
											</p>
										</td>
									</tr>
								<?php } ?>
							</table>
							<script>
								jQuery(function () {
									var $social_is_use_share = jQuery('#Social_Share_is_use');
									var is_use = false;
									var $share_checkboxes = jQuery('#social .share_buttons input:checkbox');
									var $post_options = jQuery('#social .post_options');
									$share_checkboxes.change(function () {
										is_use = $share_checkboxes.is(':checked');
										$social_is_use_share.val(is_use ? '1' : '0');
										$post_options.toggleClass('disabled', !is_use);
									}).change();
								});
							</script>
							<?php } ?>
							<?php if ('1' === @$theme_support['Social']['urls']) { ?>
							<hr />
							<h3><?php wTheme::_e("Social media account url's"); ?></h3>
							<table class="form-table">
								<?php $meta_key = 'URL'; ?>
								<?php foreach (self::$social_urls as $field=>$label) { ?>
									<tr valign="top">
										<?php $id = "{$section}_{$meta_key}_{$field}"; ?>
										<th><label for="<?php echo $id; ?>"><?php wTheme::_e($label); ?></label></th>
										<td>
											<span class="icon <?php echo $field ?>">
												<input type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" id="<?php echo $id; ?>" class="regular-text" />
											</span>
										</td>
									</tr>
								<?php } ?>
							</table>
							<?php } ?>
						</div>
						<?php } ?>
						<div id="optimization">
							<?php $section = 'Optimization'; ?>
							<h2 class="title"><?php wTheme::_e('Optimization'); ?></h2>
							<table class="form-table">
								<tr valign="top">
									<?php $field = 'remove_query_strings'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Remove "query strings"'); ?></label></th>
									<td>
										<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
										<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
										<span class="description"><?php wTheme::_e('Remove "query strings" from static resources like CSS & JS files.'); ?></span>
									</td>
								</tr>
								<tr valign="top">
									<?php $field = 'move_js_css_to_footer'; $id = "{$section}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Move JS and CSS includes to footer'); ?></label></th>
									<td>
										<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
										<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
									</td>
								</tr>
							</table>
						</div>
						<div id="integrations">
							<?php $section = 'Integrations'; ?>
							<h2 class="title"><?php wTheme::_e('Integrations'); ?></h2>

							<h3><?php wTheme::_e('Google maps'); ?></h3>
							<table class="form-table">
								<?php $meta_key = 'GoogleMaps'; ?>
								<tr valign="top">
									<?php $field = 'api_key'; $id = "{$section}_{$meta_key}_{$field}"; ?>
									<th><label for="<?php echo $id; ?>"><?php wTheme::_e('API key'); ?></label></th>
									<td><input id="<?php echo $id; ?>" type="text" name="<?php echo "data[{$section}][{$meta_key}][{$field}]"; ?>" value="<?php echo esc_attr(@$data[$section][$meta_key][$field]); ?>" class="regular-text" /></td>
								</tr>
							</table>
						</div>
						<?php if ('1' === @$theme_support['Special']['settings']) { ?>
						<div id="special_features">
							<h2 class="title"><?php wTheme::_e('Special features'); ?></h2>
						</div>
						<?php } ?>
					</div>
				</div>
				<?php submit_button(wTheme::__('Save settings')); ?>
			</form>
			<p class="description">
				<?php
					$webcoders_link = '<a href="https://webcoders.dk/" onclick="this.target=\'_blank\';">WebCoders.dk</a>';
					$theme_version = wp_get_theme()->get('Version');
					printf(wTheme::__('Theme made by %s | Version %s'), $webcoders_link, $theme_version);
				?>
			</p>
		</div>
		<?php
	}

	static function support() {
		$saved = false;

		if (!empty($_POST['data'])) {
			$data = stripslashes_deep($_POST['data']);

			self::update_option('theme_support', $data);
			self::$options = array();
			$data = get_option(wTheme::prefix('theme_support'));
			$saved = true;
		} else {
			$data = get_option(wTheme::prefix('theme_support'));
		}
		?>
		<?php if ($saved) { ?>
			<div id="message" class="updated"><p><strong><?php wTheme::_e('Settings saved.'); ?></strong></p></div>
		<?php } ?>
		<div class="wrap" id="wtheme-support">
			<h2><?php wTheme::_e('Theme support'); ?></h2>
			<form action="" method="post" class="support">
				<table class="form-table">
					<?php $section = 'Slider'; ?>
					<tr valign="top">
						<?php $field = 'settings'; $id = "{$section}_{$field}"; ?>
						<th><h3 style="margin: 0;"><label for="<?php echo $id; ?>"><?php wTheme::_e('Slider'); ?></label></h3></th>
						<td>
							<label>
								<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
								<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
								<span class="description"> <?php wTheme::_e('Use slider on site'); ?></span>
							</label>
						</td>
					</tr>
				</table>
				<hr />
				<table class="form-table">
					<?php $section = 'Footer'; ?>
					<tr valign="top">
						<th colspan="2"><h3 style="margin: 0;"><?php wTheme::_e('Footer'); ?></h3></th>
					</tr>
					<tr valign="top">
						<?php $field = 'site_logo'; $id = "{$section}_{$field}"; ?>
						<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Logo'); ?></label></th>
						<td>
							<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
							<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
						</td>
					</tr>
				</table>
				<hr />
				<table class="form-table">
					<?php $section = 'Home'; ?>
					<tr valign="top">
						<?php $field = 'settings'; $id = "{$section}_{$field}"; ?>
						<th><h3 style="margin: 0;"><label for="<?php echo $id; ?>"><?php wTheme::_e('Home'); ?></label></h3></th>
						<td>
							<label>
								<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
								<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
								<span class="description"> <?php wTheme::_e('Use section settings'); ?></span>
							</label>
						</td>
					</tr>
				</table>
				<hr />
				<table class="form-table">
					<?php $section = 'Contacts'; ?>
					<tr valign="top">
						<?php $field = 'settings'; $id = "{$section}_{$field}"; ?>
						<th><h3 style="margin: 0;"><label for="<?php echo $id; ?>"><?php wTheme::_e('Contact'); ?></label></h3></th>
						<td>
							<label>
								<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
								<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
								<span class="description"> <?php wTheme::_e('Use section settings'); ?></span>
							</label>
						</td>
					</tr>
				</table>
				<hr />
				<table class="form-table">
					<?php $section = 'Social'; ?>
					<tr valign="top">
						<?php $field = 'settings'; $id = "{$section}_{$field}"; ?>
						<th><h3 style="margin: 0;"><label for="<?php echo $id; ?>"><?php wTheme::_e('Social'); ?></label></h3></th>
						<td>
							<label>
								<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
								<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
								<span class="description"> <?php wTheme::_e('Use section settings'); ?></span>
							</label>
						</td>
					</tr>
					<tr valign="top">
						<?php $field = 'share'; $id = "{$section}_{$field}"; ?>
						<th><label for="<?php echo $id; ?>"><?php wTheme::_e('Use social share'); ?></label></th>
						<td>
							<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
							<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
						</td>
					</tr>
					<tr valign="top">
						<?php $field = 'urls'; $id = "{$section}_{$field}"; ?>
						<th><label for="<?php echo $id; ?>"><?php wTheme::_e("Use social media account url's"); ?></label></th>
						<td>
							<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
							<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
						</td>
					</tr>
				</table>
				<hr />
				<table class="form-table">
					<?php $section = 'Special'; ?>
					<tr valign="top">
						<?php $field = 'settings'; $id = "{$section}_{$field}"; ?>
						<th><h3 style="margin: 0;"><label for="<?php echo $id; ?>"><?php wTheme::_e('Special features'); ?></label></h3></th>
						<td>
							<label>
								<input type="hidden" name="<?php echo "data[{$section}][{$field}]"; ?>" value="0" />
								<input type="checkbox" name="<?php echo "data[{$section}][{$field}]"; ?>" <?php checked(@$data[$section][$field], '1'); ?> value="1" id="<?php echo $id; ?>" />
								<span class="description"> <?php wTheme::_e('Use section settings'); ?></span>
							</label>
						</td>
					</tr>
				</table>
				<?php submit_button(wTheme::__('Save settings')); ?>
			</form>
		</div>
		<?php
	}

	static function action__wp_head() {
		$settings = self::get_option('all');
		$general = $settings['General'];

		$favicon_attachment_id = intval(@$general['favicon_attachment_id']);
		$favicon_url = wp_get_attachment_image_url($favicon_attachment_id, wTheme::prefix('desktop_favicon_2x'));
		if ($favicon_url) {
			echo '<link rel="shortcut icon" href="'.$favicon_url.'" />';
			self::add_favicon_sizes();
			foreach (self::$favicon_intermediate_sizes as $intermediate_name=>$size) {
				foreach (array($intermediate_name, $intermediate_name.'_2x') as $name) {
					list($src, $width, $height, $is_intermediate) = wp_get_attachment_image_src($favicon_attachment_id, wTheme::prefix($name));
					if ($is_intermediate)
						echo '<link rel="apple-touch-icon" sizes="'.$width.'x'.$height.'" href="'.$src.'" />';
				}
			}
		}

		if (!empty($general['custom_css']))
			echo "<style>{$general['custom_css']}</style>";

		$header = $settings['Header'];
		if (!empty($header['custom_code']))
			echo $header['custom_code'];

		$body = $general['Body'];

		$body_background_url = wp_get_attachment_image_url(@$body['background_attachment_id'], 'full');
		if (!empty($body_background_url))
			echo '<style> body { background: url("'.$body_background_url.'") no-repeat 50% 0 fixed; } </style>';

		$body_responsive_background_url = wp_get_attachment_image_url(@$body['responsive_background_attachment_id'], 'full');
		if (!empty($body_responsive_background_url))
			echo '<style>
 				@media screen and (max-width: 768px) {
					body { background: url("'.$body_responsive_background_url.'") no-repeat 50% 0 fixed; }
			    }
			</style>';
	}

	static function action__wp_footer() {
		$settings = self::get_option('General.Body');
		if (!empty($settings['bottom_custom_code']))
			echo $settings['bottom_custom_code'];
	}

	static function filter_loader_src_remove_query_ver($src) {
		$url = parse_url($src);
		if (isset($url['host']) && $_SERVER['SERVER_NAME'] === $url['host'] && false !== strpos($src, 'ver=')) {
			$src = str_replace(array('&amp;ver=', '&#038;ver=', '#038;ver='), '&ver=', $src);
			$src = remove_query_arg('ver', $src);
		}
		return $src;
	}

	static function action__wp_head__move_js_to_footer() {
		global $wp_scripts;

		foreach ($wp_scripts->registered as $handle => $data)
			if ('jquery' !== $handle)
				$wp_scripts->registered[$handle]->extra['group'] = 1;
	}
}
wThemeSettings::construct();