<?php
$inc_dir = get_template_directory().'/inc';
$wLib_dir = "{$inc_dir}/wLib";
$wLibApp_dir = "{$inc_dir}/wLibApp";

require_once "{$wLib_dir}/wTheme.php";
require_once "{$wLib_dir}/wCustomPostType.php";
require_once "{$wLib_dir}/wCustomTaxonomy.php";
require_once "{$wLib_dir}/wSidebar.php";
require_once "{$wLib_dir}/wThemeSettings.php";
require_once "{$wLib_dir}/wGoogleMaps.php";
require_once "{$wLib_dir}/wSlider.php";

require_once "{$inc_dir}/widgets.php";

require_once "{$wLibApp_dir}/wPage.php";
require_once "{$wLibApp_dir}/wCase.php";
require_once "{$wLibApp_dir}/wCaseCategory.php";
require_once "{$wLibApp_dir}/wEvent.php";

wTheme::$layout_options = array(
	'full-width' => array('sidebars' => false),
//	'left-sidebar' => array('sidebars' => array('left')),
	'right-sidebar' => array('sidebars' => array('right')),
//	'two-sidebars' => array('sidebars' => array('left', 'right')),
);

wTheme::$layout = 'right-sidebar';

$wSidebar = new wSidebar(wTheme::prefix('sidebar'));
$wPage = new wPage('page');
$wSlider = new wSlider('slide');
$wCase = new wCase(wTheme::prefix('case'));
$wCaseCategory = new wCaseCategory(wCase::$post_type.'_category', wCase::$post_type);
$wEvent = new wEvent(wTheme::prefix('event'));