<?php

final class ITSEC_Malware_Scheduling_Settings_Page extends ITSEC_Module_Settings_Page {
	private $version = 1;
	
	
	public function __construct() {
		$this->id = 'malware-scheduling';
		$this->title = __( 'Malware Scan Scheduling', 'it-l10n-ithemes-security-pro' );
		$this->description = __( 'Protect your site with automated malware scans. When this feature is enabled, the site will be automatically scanned each day. If a problem is found, an email is sent to select users.', 'it-l10n-ithemes-security-pro' );
		$this->type = 'recommended';
		$this->pro = true;
		
		parent::__construct();
	}
	
	public function enqueue_scripts_and_styles() {
		wp_enqueue_style( 'itsec-malware-scheduling-admin-style', plugins_url( 'css/settings-page.css', __FILE__ ), array(), $this->version );
	}
	
	protected function render_description( $form ) {
		
?>
	<p><?php _e( 'This malware scan is powered by <a href="https://ithemes.com/sitecheck">Sucuri SiteCheck</a>. It checks for known malware, blacklisting status, website errors, and out-of-date software. Although the Sucuri team does its best to provide the best results, 100% accuracy is not realistic and is not guaranteed.', 'it-l10n-ithemes-security-pro' ); ?></p>
	<p><?php printf( __( 'Results of previous malware scans can be found on the <a href="%s">logs page</a>.', 'it-l10n-ithemes-security-pro' ), ITSEC_Core::get_logs_page_url( 'malware' ) ); ?></p>
<?php
		
	}
	
	protected function render_settings( $form ) {
		$validator = ITSEC_Modules::get_validator( $this->id );
		
		$users_and_roles = $validator->get_available_admin_users_and_roles();
		
		$users = $users_and_roles['users'];
		$roles = $users_and_roles['roles'];
		
		natcasesort( $users );
		
		
		$contacts = $form->get_option( 'email_contacts' );
		
		if ( empty( $contacts ) || ! is_array( $contacts ) ) {
			$form->set_option( 'email_contacts', array_keys( $roles ) );
		}
		
?>
	<table class="form-table itsec-settings-section">
		<tr>
			<th scope="row"><label for="itsec-malware-scheduling-email_notifications"><?php _e( 'Email Notifications', 'it-l10n-ithemes-security-pro' ); ?></label></th>
			<td>
				<?php $form->add_checkbox( 'email_notifications' ); ?>
				<label for="itsec-malware-scheduling-email_notifications"><?php _e( 'Send email notifications when an issue is found.', 'it-l10n-ithemes-security-pro' ); ?></label>
			</td>
		</tr>
		<tr>
			<th scope="row"><?php _e( 'Email Contacts', 'it-l10n-ithemes-security-pro' ); ?></th>
			<td>
				<p><?php _e( 'Select which users should get an email if an issue is found during a malware scan.', 'it-l10n-ithemes-security-pro' ); ?></p>
				
				<ul>
					<?php foreach ( $roles as $role => $name ) : ?>
						<li>
							<?php $form->add_multi_checkbox( 'email_contacts', $role ); ?>
							<label for="itsec-malware-scheduling-email_contacts-role-<?php echo esc_attr( preg_replace( '/^role:/', '', $role ) ); ?>"><?php echo esc_html( sprintf( _x( 'All %s users', 'role', 'it-l10n-ithemes-security-pro' ), $name ) ); ?></label>
						</li>
					<?php endforeach; ?>
				</ul>
				
				<ul>
					<?php foreach ( $users as $id => $name ) : ?>
						<li>
							<?php $form->add_multi_checkbox( 'email_contacts', $id ); ?>
							<label for="itsec-malware-scheduling-email_contacts-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $name ); ?></label>
						</li>
					<?php endforeach; ?>
				</ul>
			</td>
		</tr>
	</table>
<?php
		
	}
}

new ITSEC_Malware_Scheduling_Settings_Page();
