<?php
$theme_support = get_option(wTheme::prefix('theme_support'));
$theme_slider = @$theme_support['Slider']['settings'];
if (empty($theme_slider))
	return;

$option = wThemeSettings::get_option('Slider')['settings'];
$args = array();

$order_direction = 'ASC';
if ('asc' == $option['order_direction'])
	$order_direction = 'ASC';
if ('desc' == $option['order_direction'])
	$order_direction = 'DESC';

$order = 'menu_order ID';
if ('menu_order' == $option['order_field'])
	$order = 'menu_order ID';
if ('post_date' == $option['order_field'])
	$order = 'date';
if ('rand' == $option['order_field'])
	$order = 'rand';

$args['orderby'] = $order;
$args['order'] = $order_direction;

$query = wSlider::wp_query($args);

if(!$query->have_posts())
	return;

//add cycle2 script && style
wp_enqueue_script(wTheme::prefix('cycle'));
if ('scrollVert' == $option['transition'])
	wp_enqueue_script(wTheme::prefix('cycle_scroll_vert'));
if ('tile' == $option['transition'])
	wp_enqueue_script(wTheme::prefix('cycle_tile'));
if ('blind' == $option['transition'])
	wp_enqueue_script(wTheme::prefix('cycle_tile'));

//slider settings for init
$slider_options = array();
$slider_options['slides'] = '> li';
//use swipe
if ('1' == $option['use_swipe']) {
	wp_enqueue_script(wTheme::prefix('cycle_swipe'));
	$slider_options['swipe'] = true;
	$slider_options['swipeFx'] = 'scrollHorz';
}
//slider transitions
$slider_options['fx'] = 'fade';
switch ($option['transition']) {
	case 'fade':
		$slider_options['fx'] = 'fade';
		break;
	case 'fadeout':
		$slider_options['fx'] = 'fadeout';
		break;
	case 'scrollHorz':
		$slider_options['fx'] = 'scrollHorz';
		break;
	case 'scrollVert':
		$slider_options['fx'] = 'scrollVert';
		break;
	case 'tile':
		$slider_options['fx'] = 'tileSlide';
		$slider_options['tileCount'] = intval($option['tile_count']);
		break;
	case 'blind':
		$slider_options['fx'] = 'tileBlind';
		$slider_options['tileCount'] = intval($option['tile_count']);
		break;
}
//prev, next buttons
if ('1' == $option['show_navigation']) {
	$slider_options['prev'] = '#prev';
	$slider_options['next'] = '#next';
}
//timeout
if (!empty($option['timeout'])) {
	$slider_options['timeout'] = intval($option['timeout']);
} else {
	$slider_options['timeout'] = 0;
}
//speed
if (!empty($option['speed'])) {
	$slider_options['speed'] = intval($option['speed']);
} else {
	$slider_options['speed'] = 600;
}
//pause on hover
if ('1' == $option['pause']) {
	$slider_options['pauseOnHover'] = true;
}
//pager
if ('1' == $option['show_pagination']) {
	$slider_options['pager'] = '.pager';
	$slider_options['pagerTemplate'] = '<li></li>';
	$slider_options['pagerActiveClass'] = 'active';
}
//disable console.log for slider actions
$slider_options['log'] = false;

//fix slider height
if (!empty($option['height'])) {
	?><style>.slider_wrap .slider {max-height: <?php echo $option['height']; ?>px;}</style> <?php
}
?>
<div class="slider_wrap">
	<ul class="slider">
		<?php $navigate_menu = ''; ?>
		<?php while ($query->have_posts()) { $query->the_post(); ?>
			<?php
				$meta = wSlider::get_all_meta(get_the_ID());
				$class = @$meta['class'];
				$title = @$meta['slide_title'];
				$title_color = @$meta['title_color'];
				$desc = @$meta['slide_text'];
				$url = @$meta['url'];
				$is_url = ('' != $url);
				$is_open_in_new_tab = @$meta['is_open_in_new_tab'];
				$open_in_new_tab = $is_open_in_new_tab ? ' onclick="this.target=\'_blank\';"' : '';
				$link = $is_url ? sprintf('<a href="%s"%s>%s</a>', esc_url($url), '%s', '%s') : '';
				$read_more_text = @$meta['read_more_text'];
				$navigation_menu_title = @$meta['navigation_menu_title'];
				$navigation_class = @$meta['navigation_class'];
				$slide_template = @$meta['slide_template'];
				$attr_id = 'slide_'.get_the_ID();
				$is_show_in_navigation_menu = @$option['show_navigation_menu'];

				//navigation menu items
				if ('' != $title && !empty($is_show_in_navigation_menu)) {
					if ('' == $navigation_menu_title)
						$navigation_menu_title = $title;

					if (0 == $query->current_post)
						$navigation_class .= ' current';

					$navigate_menu .= '<li class="'.$navigation_class.'"><a href="#" rel="'.$attr_id.'">'.$navigation_menu_title.'</a></li>'."\n";
				}
			?>
			<li class="slide <?php if (!empty($class)) echo $class; ?> <?php if (!empty($slide_template)) echo $slide_template; ?>" id="<?php echo $attr_id; ?>">
				<?php if (has_post_thumbnail()) { ?>
					<span><?php the_post_thumbnail(wTheme::prefix('slide')); ?></span>
				<?php } ?>
				<?php echo $is_url ? sprintf($link, $open_in_new_tab, '') : ''; ?>
				<?php if (!empty(@$option['show_slide_text']) && (!empty($title) || !empty($desc))) { ?>
					<div class="slide_text">
						<h2 <?php if (!empty($title_color)) echo "style='color:{$title_color};'" ?>><?php echo $is_url ? sprintf($link, $open_in_new_tab, $title) : $title; ?></h2>
						<p><?php echo $desc; ?></p>
						<?php echo $is_url ? sprintf($link, $open_in_new_tab.' class="read_more"', $read_more_text) : ''; ?>
					</div>
				<?php } ?>
			</li>
		<?php } ?>
		<?php wp_reset_postdata(); ?>
	</ul>
	<?php
		if ($query->post_count > 1) {
			//slider pager
			if ('1' == $option['show_pagination']) {
				echo '<ul class="pager"></ul>';
			}
			//prev && next
			if ('1' == $option['show_navigation']) {
				echo '<a class="navigation prev" id="prev" href="javascript:void(0);"><span></span></a>';
				echo '<a class="navigation next" id="next" href="javascript:void(0);"><span></span></a>';
			}
		}
	?>
	<?php
		if (!empty($is_show_in_navigation_menu) && '' != $navigate_menu) {
			//navigation menu wrapper
			echo '<ul class="navigation_menu">'.$navigate_menu.'</ul>';
		}
	?>
</div>
<script>
	jQuery(function () {
		var $slider = jQuery('.slider');
		$slider.cycle(<?php echo json_encode($slider_options); ?>);
		<?php if (!empty($option['show_navigation_menu'])) { ?>
			jQuery('.navigation_menu li a').click(function() {
				var rel = jQuery(this).attr('rel');
				var index = $slider.find('li[id="'+rel+'"]').index();
				$slider.cycle('goto', index-1);
				return false;
			});
			$slider.on('cycle-before', function (event, optionHash, outgoingSlideEl, incomingSlideEl, forwardFlag) {
				var slide_id = jQuery(incomingSlideEl).attr('id');
				var $li = jQuery(this).closest('.slider_wrap').find('.navigation_menu li').removeClass('current');
				$li.find('a[rel="'+slide_id+'"]').parent().addClass('current');
			});
		<?php } ?>
	});
</script>
