<?php
/**
 * Template Name: Contact
 * Layout: full-width
 */

the_post();
$content = wTheme::get_the_content();
$map_settings = get_post_meta(get_the_ID(), wTheme::prefix('map_settings'), true);
if (!empty($map_settings['type'])) {
	$class = '';
	if ('left' == $map_settings['position'])
		$class = 'left';
	if ('right' == $map_settings['position'])
		$class = 'right';
	ob_start();
	if ('embed_code' === $map_settings['type'] && !empty($map_settings['embed_code'])) {
		echo wtheme_media_wrapper($map_settings['embed_code']);
	} else {
		$latitude = $longitude = null;
		if ('address' === $map_settings['type']) {
			$latitude = @$map_settings['address_latitude'];
			$longitude = @$map_settings['address_longitude'];
		} else if ('coordinates' === $map_settings['type']) {
			$latitude = @$map_settings['latitude'];
			$longitude = @$map_settings['longitude'];
		}
		if (!empty($latitude) && !empty($longitude)) {
			$zoom = empty($map_settings['zoom']) ? '20' : $map_settings['zoom'];
			$map_height = @$map_settings['map_height'];
			$map_height_style = empty($map_height) ? '' : 'style="height: '.$map_height.'px;"';

			$info_window_title = @$map_settings['info_window_title'];
			$info_window_description = @$map_settings['info_window_description'];
			$info_window_width = @$map_settings['info_window_width'];
			$info_window_height = @$map_settings['info_window_height'];

			$info_window_width_style = empty($info_window_width) ? '' : 'style="width: '.$info_window_width.'px;"';
			$info_window_height_style = empty($info_window_height) ? '' : 'style="height: '.$info_window_height.'px;"';
			ob_start();
			?>
			<div class="info_window" <?php echo $info_window_width_style; ?>>
				<h1><?php echo $info_window_title; ?></h1>
				<div <?php echo $info_window_height_style; ?>>
					<?php echo $info_window_description; ?>
				</div>
			</div>
			<?php
			$info_window_content = ob_get_clean();

			$api_key = wGoogleMaps::get_api_key();
			$map_params = array('v'=>'3.exp');
			if (!empty($api_key))
				$map_params['key'] = $api_key;
			$api_map_url = add_query_arg($map_params, 'https://maps.googleapis.com/maps/api/js?');
			wp_enqueue_script(wTheme::prefix('google-maps'), $api_map_url);
			?>
			<div class="map" <?php echo $map_height_style; ?>></div>
			<script>
				jQuery(window).load(function(){
					function initialize_map() {
						var mapCenterLatLng = new google.maps.LatLng(<?php echo $latitude.', '.$longitude; ?>);
						var mapOptions = {
							zoom: <?php echo $zoom; ?>,
							center: mapCenterLatLng
						};

						var map = new google.maps.Map(jQuery('.content .map_wrap .map').get(0), mapOptions);

						var marker = new google.maps.Marker({
							position: mapCenterLatLng,
							map: map,
							title: <?php echo json_encode($info_window_title); ?>
						});

						<?php if (!empty($info_window_title)) { ?>
							var infowindow = new google.maps.InfoWindow({
								autopan: true,
								content: <?php echo json_encode($info_window_content); ?>
							});
							google.maps.event.addListener(marker, 'click', function() {
								infowindow.open(map, marker);
							});
							<?php if ('1' === @$map_settings['info_window_auto_open']) { ?>
								google.maps.event.addListenerOnce(map, 'tilesloaded', function() {
									infowindow.open(map, marker);
								});
							<?php } ?>
						<?php } ?>
					}
					initialize_map();
				});
			</script>
			<?php
		}
	}
	$map_content = ob_get_clean();
	if ('' != trim($map_content)) {
		$map = '<div class="map_wrap '.$class.'">'.$map_content.'</div>';
		$content = 'bottom' == $map_settings['position'] ? $content.$map : $map.$content;
		$content = '<div class="clear">'.$content.'</div>';
	}
}
?>
<article>
	<header class="entry_header">
		<h1 class="entry_title"><?php the_title(); ?></h1>
	</header>
	<?php echo wTheme::part('entry-content', compact('content')); ?>
</article>