jQuery(function() {
	var $link_to_image = jQuery('a').filter(function() {
		var href = jQuery(this).attr('href');
		if(href && jQuery(this).prop('rel'))
			return href.match(/\.(jpg|png|gif|jpeg)/);
	});

	wtheme_initPrettyPhoto($link_to_image);

	jQuery('.entry_content .shortcode__read_more_button').click(function() {
		var $button_wrap = jQuery(this).parent();
		$button_wrap.hide();
		$button_wrap.prev('.shortcode__hidden_content').slideDown(300);
		$button_wrap.prevAll('.shortcode__visible_content').removeClass('gradient');
		return false;
	});

	jQuery('.entry_content .shortcode_hidecontent').click(function() {
		var $this = jQuery(this);
		$this.next().show();
		jQuery('.'+$this.attr('href').substr(1)).show();
		$this.hide();
		return false;
	});

	jQuery('.entry_content .shortcode_showcontent').click(function() {
		var $this = jQuery(this);
		jQuery('.'+$this.attr('href').substr(1)).hide();
		$this.hide();
		$this.prev().show();
		return false;
	});

	jQuery('.entry_content .shortcode_question').click(function() {
		var $this = jQuery(this);
		var $answer = $this.nextAll('.shortcode_answer:first');
		$answer.slideToggle(function() {
			$this.toggleClass('expand', $answer.is(":visible"));
		});
	});

	jQuery('.entry_content .shortcode_answer:visible').each(function() {
		jQuery(this).prevAll('.shortcode_question:first').addClass('expand');
	});

	var $main_menu = jQuery('nav.main_menu');

	$main_menu.find('> .menu_button').click(function() {
		jQuery(this).parent().toggleClass('active').find('> ul').slideToggle(500);
	});

	var $svg_search_icon = jQuery('#wsvg_search');
	var $svg_close_icon = jQuery('#wsvg_close');
	var $search_icon = jQuery('.site_header .search .icon');
	var search_open = $svg_search_icon.find('path').attr('d');
	var search_close = $svg_close_icon.find('path').attr('d');
	$search_icon.append($svg_search_icon);

	var $header_search = jQuery('.site_header .search');
	var $search_popup = jQuery('.search_popup');
	var is_open_popup = false;

	$header_search.find('.open').click(function () {
		if (is_open_popup)
			return false;

		$search_popup.fadeIn(600, function () {
			is_open_popup = true;
		});
		jQuery(this).hide();
		$header_search.find('.close').fadeIn(300);
		anime({
			targets: '.site_header .search path',
			d: search_close,
			duration: 600,
		});
		$search_popup.find('.search-field').focus();
		$search_popup.find('div, h4').click(function () {
			jQuery('.search-field').focus();
		});
		return false;
	});
	$header_search.find('.close').click(function () {
		if (!is_open_popup)
			return false;

		$search_popup.fadeOut(600, function () {
			is_open_popup = false;
		});
		jQuery(this).hide();
		$header_search.find('.open').fadeIn(300);
		anime({
			targets: '.site_header .search path',
			d: search_open,
			duration: 600,
		});
		return false;
	});
});

jQuery.get(template_directory_uri+'/images/sprite.svg', function (svgFileData) {
	var $svgTag = jQuery(svgFileData.documentElement);
	$svgTag.hide();
	jQuery('body').append($svgTag);
});

jQuery(window).load(function() {
	if (jQuery(window).width() < 768) {
		wtheme_responsiveMenu();
	}
	jQuery(window).resize(function() {
		if (jQuery(window).width() > 767) {
			wtheme_responsiveMenu();
		}
		wtheme_clickMenu();
	}).trigger('resize');
});

function wtheme_initPrettyPhoto($list) {
	$list.prettyPhoto({social_tools: false});
}

function wtheme_responsiveMenu() {
	var existingWidth = jQuery(document).data('resize-width');
	var newWidth = jQuery(document).width();
	if (existingWidth != newWidth) {
		var $main_menu = jQuery('nav.main_menu');

		if (jQuery(window).width() < 768) {
			$main_menu.removeClass('active').addClass('responsive').find('> ul').hide();
		} else {
			$main_menu.removeClass('responsive active').find('> ul').show();
		}

		if (768 <= jQuery(window).width() &&  jQuery(window).width() <= 1024) {
			var $items = $main_menu.find('> ul > li');
			var max_width = $main_menu.width();
			var width = 0;

			$items.each(function() {
				if (width + jQuery(this).outerWidth(true) >= max_width) {
					$main_menu.addClass('responsive').find('> ul').hide();
					return false;
				} else {
					$main_menu.removeClass('responsive active').find('> ul').show();
					width += jQuery(this).outerWidth(true);
				}
			});
		}

		jQuery(document).data('resize-width', newWidth);
	}
}

function wtheme_clickMenu() {
	var is_touch = (('ontouchstart' in document.documentElement) || ('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0));
	if (is_touch && (!jQuery('.main_menu').hasClass('responsive'))) {
		jQuery('.main_menu .menu-item-has-children > a').click(function() {
			if (!jQuery(this).data('click')) {
				jQuery(this).data('click', 1).parent().addClass('active').siblings().removeClass('active').find('a').data('click', 0);
				jQuery(this).parent().siblings().find('.active').removeClass('active');
				return false;
			}
		});

		jQuery('body').click(function(e) {
			if (jQuery(e.target).parents('.main_menu').length === 0) {
				jQuery('.main_menu li').removeClass('active').find('a').data('click', 0);
			}
		});
	}
}
