<?php if (have_posts()) {
	if (is_home() && get_option('page_for_posts') > 0)
		echo '<header class="entry_header"><h1 class="entry_title">'.get_the_title(get_option('page_for_posts')).'</h1></header>';
	else if (is_search())
		echo '<header class="entry_header"><h1 class="entry_title">'.sprintf(wTheme::__('Search Results for: %s'), get_search_query()).'</h1></header>';

	while (have_posts()) { the_post();
		echo wTheme::part('content');
	}
	wTheme::pagination('pagination');
?>
<?php } else { ?>
	<article>
		<header class="entry_header">
			<h1 class="entry_title"><?php wTheme::_e('Nothing Found'); ?></h1>
		</header>
		<div class="entry_content_wrap">
			<div class="entry_content">
				<p><?php wTheme::_e('Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.'); ?></p>
			</div>
		</div>
	</article>
<?php } ?>