<?php

function wtheme_action_in_widget_form($wp_widget, $return, $instance) {
	$defaults = array('class'=>'');
	$instance = wp_parse_args((array) $instance, $defaults);
	$class = $instance['class'];
	?>
	<p>
		<label for="<?php echo $wp_widget->get_field_id('class'); ?>"><?php wTheme::_e('Class'); ?>:</label>
		<input class="widefat" id="<?php echo $wp_widget->get_field_id('class'); ?>" name="<?php echo $wp_widget->get_field_name('class'); ?>" type="text" value="<?php echo $class; ?>" />
	</p>
	<?php
	return array($wp_widget, $return, $instance);
}
add_action('in_widget_form', 'wtheme_action_in_widget_form', 10, 3);

function wtheme_filter_widget_update_callback($instance, $new_instance) {
	$instance['class'] = strip_tags($new_instance['class']);
	return $instance;
}
add_filter('widget_update_callback', 'wtheme_filter_widget_update_callback', 10, 2);

function wtheme_filter_dynamic_sidebar_params($params) {
	global $wp_registered_widgets;

	$sidebar_index = $params[0]['id'];
	$sidebars_widgets = wp_get_sidebars_widgets();
	if (!isset($sidebars_widgets[$sidebar_index]) || empty($sidebars_widgets[$sidebar_index]))
		return $params;

	$widget_id = $params[0]['widget_id'];
	$widget_obj = @$wp_registered_widgets[$widget_id];
	$widget_opt = get_option(@$widget_obj['callback'][0]->option_name);
	$widget_num = @$widget_obj['params'][0]['number'];
	$classes = array();
	if (!empty($widget_opt[$widget_num]['class']))
		$classes[] = $widget_opt[$widget_num]['class'];
	$widgets = $sidebars_widgets[$sidebar_index];

	$key = array_search($widget_id, $widgets);
	$count = count($widgets);
	if (false !== $key && $count > 1 && ($key + 1) == $count)
		$classes[] .= 'last';

	if (!empty($classes))
		$params[0]['before_widget'] = preg_replace('/(class\s*=\s*"|\')([^"|\']+)("|\')/i', '$1$2 '.implode(' ',  $classes).'$3', $params[0]['before_widget']);
	return $params;
}
add_filter('dynamic_sidebar_params', 'wtheme_filter_dynamic_sidebar_params');

class wTheme_Widget_Children_Pages extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_child_pages widget_nav_menu',
			'description' => wTheme::__('This widget will show children pages if any when standing on a parent page.'),
		);
		parent::__construct(wTheme::prefix('child_pages'), wTheme::__('Children pages'), $widget_ops);
	}

	function widget($args, $instance) {
		$page = get_queried_object();
		if (!is_page() || !$page || 'page' != $page->post_type)
			return;

		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
		$order_by = empty($instance['order_by']) ? 'menu_order' : $instance['order_by'];
		$show_siblings = $instance['show_siblings'];

		if (empty($title)) {
			$title = $page->post_title;
			if (!empty($page->ancestors)){
				$title = get_the_title($page->ancestors[count($page->ancestors)-1]);
			}
		}

		if ('menu_order' == $order_by)
			$order_by = 'menu_order, post_title';

		$pages_args = array('title_li'=>'', 'echo'=>0, 'sort_column'=>$order_by, 'child_of' => $page->ID, 'depth'=>1);
		$out = wp_list_pages(apply_filters('widget_pages_args', $pages_args));
		if (empty($out) && $show_siblings) {
			$pages_args['child_of'] = $page->post_parent;
			//$pages_args['exclude'] = $page->ID;
			$out = wp_list_pages(apply_filters('widget_pages_args', $pages_args));
		}

		if (!empty($out)) {
			echo $before_widget;
			if (!empty($title))
				echo $before_title.$title.$after_title;
			echo '<ul class="menu">'.$out.'</ul>';
			echo $after_widget;
		}
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['order_by'] = 'post_title';
		if (in_array($new_instance['order_by'], array('post_title', 'menu_order', 'ID'))) {
			$instance['order_by'] = $new_instance['order_by'];
		}
		$instance['show_siblings'] = $new_instance['show_siblings'];

		return $instance;
	}

	function form($instance) {
		$defaults = array('order_by'=>'post_title', 'title'=>'', 'show_siblings'=>'0');
		$instance = wp_parse_args((array) $instance, $defaults);
		$title = esc_attr($instance['title']);
		$show_siblings = $instance['show_siblings'];
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('order_by'); ?>"><?php _e('Sort by:'); ?></label>
			<select name="<?php echo $this->get_field_name('order_by'); ?>" id="<?php echo $this->get_field_id('order_by'); ?>" class="widefat">
				<option value="post_title" <?php selected($instance['order_by'], 'post_title'); ?>><?php _e('Page title'); ?></option>
				<option value="menu_order" <?php selected($instance['order_by'], 'menu_order'); ?>><?php _e('Page order'); ?></option>
				<option value="ID" <?php selected($instance['order_by'], 'ID'); ?>><?php _e('Page ID'); ?></option>
			</select>
		</p>
		<p>
			<input type="hidden" name="<?php echo $this->get_field_name('show_siblings'); ?>" value="0" />
			<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('show_siblings'); ?>" name="<?php echo $this->get_field_name('show_siblings'); ?>" <?php checked($show_siblings); ?> value="1" />
			<label for="<?php echo $this->get_field_id('show_siblings'); ?>"><?php wTheme::_e('Show page siblings if no childrens'); ?></label>
		</p>
		<?php
	}
}

class wTheme_Widget_Google_Map extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_google_map', 'description' => wTheme::__('Your location on the google map'));
		parent::__construct(wTheme::prefix('google_map'), wTheme::__('Google Map'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$latitude = empty( $instance['latitude'] ) ? '' : $instance['latitude'];
		$longitude = empty( $instance['longitude'] ) ? '' : $instance['longitude'];
		$zoom = empty( $instance['zoom'] ) ? '' : $instance['zoom'];
		$map_height = empty( $instance['map_height'] ) ? '' : $instance['map_height'];
		$info_window_title = empty( $instance['info_window_title'] ) ? '' : $instance['info_window_title'];
		$info_window_description = empty( $instance['info_window_description'] ) ? '' : $instance['info_window_description'];
		$info_window_width = empty( $instance['info_window_width'] ) ? '' : $instance['info_window_width'];
		$info_window_height = empty( $instance['info_window_height'] ) ? '' : $instance['info_window_height'];

		if (!empty($latitude) && !empty($longitude)) {
			echo $before_widget;
			if (!empty($title)) {
				echo $before_title . $title . $after_title;
			}

			$info_window_width_style = empty($info_window_width) ? '' : 'style="width: '.$info_window_width.'px;"';
			$info_window_height_style = empty($info_window_height) ? '' : 'style="height: '.$info_window_height.'px;"';
			ob_start();
			?>
			<div class="info_window" <?php echo $info_window_width_style; ?>>
				<h1><?php echo $info_window_title; ?></h1>
				<div <?php echo $info_window_height_style; ?>>
					<?php echo $info_window_description; ?>
				</div>
			</div>
			<?php
			$info_window_content = ob_get_clean();
			//todo send json for widget and init via widget id
			//todo refactor render like on contact page template
			$api_key = wThemeSettings::get_option('Integrations.GoogleMaps.api_key');
			$map_params = array('v'=>'3.exp');
			if (!empty($api_key))
				$map_params['key'] = $api_key;
			$api_map_url = add_query_arg($map_params, 'https://maps.googleapis.com/maps/api/js?');
			wp_enqueue_script(wTheme::prefix('google-maps'), $api_map_url);
			?>
			<?php if (!empty($map_height)) $map_height = 'style="height: '.$map_height.'px;"'; ?>
			<div class="map" <?php echo $map_height; ?>></div>
			<script>
				jQuery(window).load(function(){
					function initialize() {
						var myLatlng = new google.maps.LatLng(<?php echo $latitude.', '.$longitude; ?>);
						var mapOptions = {
							zoom: <?php echo $zoom; ?>,
							center: myLatlng
						};

						var map = new google.maps.Map(jQuery('#<?php echo $widget_id; ?> .map').get(0), mapOptions);

						var marker = new google.maps.Marker({
							position: myLatlng,
							map: map,
							title: <?php echo json_encode($info_window_title); ?>
						});

						<?php if (!empty($info_window_title)) { ?>
							var infowindow = new google.maps.InfoWindow({
								content: <?php echo json_encode($info_window_content); ?>
							});
							google.maps.event.addListener(marker, 'click', function() {
								infowindow.open(map, marker);
							});
						<?php } ?>
					}
					initialize();
				});
			</script>
			<?php
			echo $after_widget;
		}
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['latitude'] = strip_tags($new_instance['latitude']);
		$instance['longitude'] = strip_tags($new_instance['longitude']);
		$instance['zoom'] = strip_tags($new_instance['zoom']);
		$instance['map_height'] = strip_tags($new_instance['map_height']);
		$instance['info_window_title'] = strip_tags($new_instance['info_window_title']);
		$instance['info_window_description'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['info_window_description'])));
		$instance['info_window_width'] = strip_tags($new_instance['info_window_width']);
		$instance['info_window_height'] = strip_tags($new_instance['info_window_height']);
		return $instance;
	}

	function form($instance) {
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'latitude' => '',
			'longitude' => '',
			'zoom' => '14',
			'map_height' => '200',
			'info_window_title' => '',
			'info_window_description' => '',
			'info_window_width' => '',
			'info_window_height' => ''
		));
		$title = $instance['title'];
		$latitude = $instance['latitude'];
		$longitude = $instance['longitude'];
		$zoom = $instance['zoom'];
		$map_height = $instance['map_height'];
		$info_window_title = $instance['info_window_title'];
		$info_window_description = $instance['info_window_description'];
		$info_window_width = $instance['info_window_width'];
		$info_window_height = $instance['info_window_height'];
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<div style="overflow: hidden">
			<p style="float: left; width: 34%; margin: 0;">
				<label for="<?php echo $this->get_field_id('latitude'); ?>"><?php wTheme::_e('Latitude'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('latitude'); ?>" name="<?php echo $this->get_field_name('latitude'); ?>" type="text" value="<?php echo esc_attr($latitude); ?>" />
			</p>
			<p style="float: left; width: 34%; margin: 0 0 0 6%;">
				<label for="<?php echo $this->get_field_id('longitude'); ?>"><?php wTheme::_e('Longitude'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('longitude'); ?>" name="<?php echo $this->get_field_name('longitude'); ?>" type="text" value="<?php echo esc_attr($longitude); ?>" />
			</p>
			<p style="float: right; width: 20%; margin: 0;">
				<label for="<?php echo $this->get_field_id('zoom'); ?>"><?php wTheme::_e('Zoom'); ?>:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('zoom'); ?>" name="<?php echo $this->get_field_name('zoom'); ?>" type="number" min="1" max="20" value="<?php echo esc_attr($zoom); ?>" />
			</p>
		</div>
		<p>
			<label for="<?php echo $this->get_field_id('map_height'); ?>"><?php wTheme::_e('Map height'); ?>:</label>
			<span style="position: relative; padding-right: 25px; display: block;">
				<input class="widefat" id="<?php echo $this->get_field_id('map_height'); ?>" name="<?php echo $this->get_field_name('map_height'); ?>" type="number" min="0" value="<?php echo esc_attr($map_height); ?>" />
				<span style="position: absolute; right: 0; top: 0; line-height: 28px;">px</span>
			</span>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('info_window_title'); ?>"><?php wTheme::_e('Info window title'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('info_window_title'); ?>" name="<?php echo $this->get_field_name('info_window_title'); ?>" type="text" value="<?php echo esc_attr($info_window_title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('info_window_description'); ?>"><?php wTheme::_e('Info window description'); ?>:</label>
			<textarea class="widefat" rows="5" cols="20" id="<?php echo $this->get_field_id('info_window_description'); ?>" name="<?php echo $this->get_field_name('info_window_description'); ?>"><?php echo esc_textarea($info_window_description); ?></textarea>
		</p>
		<div style="overflow: hidden">
			<p style="float: left; width: 47%; margin: 0;">
				<label for="<?php echo $this->get_field_id('info_window_width'); ?>"><?php wTheme::_e('Info window width'); ?>:</label>
				<span style="position: relative; padding-right: 25px; display: block;">
					<input class="widefat" id="<?php echo $this->get_field_id('info_window_width'); ?>" name="<?php echo $this->get_field_name('info_window_width'); ?>" type="number" min="0" value="<?php echo esc_attr($info_window_width); ?>" />
					<span style="position: absolute; right: 0; top: 0; line-height: 28px;">px</span>
				</span>
			</p>
			<p style="float: right; width: 47%; margin: 0;">
				<label for="<?php echo $this->get_field_id('info_window_height'); ?>"><?php wTheme::_e('Info window height'); ?>:</label>
				<span style="position: relative; padding-right: 25px; display: block;">
					<input class="widefat" id="<?php echo $this->get_field_id('info_window_height'); ?>" name="<?php echo $this->get_field_name('info_window_height'); ?>" type="number" min="0" value="<?php echo esc_attr($info_window_height); ?>" />
					<span style="position: absolute; right: 0; top: 0; line-height: 28px;">px</span>
				</span>
			</p>
		</div>
		<?php
	}
}

class wTheme_Widget_Featured_Text extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_featured_text',
			'description' => wTheme::__('This widget can display text, image and link to pages you want to promote.'),
		);
		parent::__construct(wTheme::prefix('featured_text'), wTheme::__('Featured text'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
		$text = apply_filters('widget_text', empty($instance['text']) ? '' : $instance['text'], $instance);
		$img = wp_get_attachment_image($instance['attachment_id'], $instance['image_size']);

		echo $before_widget;
		?>
		<div>
			<?php
				if (!empty($title))
					echo $before_title.$title.$after_title;
				if ($img)
					echo '<div class="img_wrap"><div>'.$img.'</div></div>';
			?>
			<div class="textwidget"><?php echo !empty($instance['filter']) ? wpautop($text) : $text; ?></div>
			<?php
				if ('' != $instance['link_url']) {
					if ('' != $instance['link_text'])
						echo '<div class="read_more_wrap"><a href="'.$instance['link_url'].'" class="read_more">'.$instance['link_text'].'</a></div>';
					if ($instance['is_full_link'])
						echo '<a href="'.$instance['link_url'].'" class="full_link"></a>';
				}
			?>
		</div>
		<?php
		echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['attachment_id'] = intval($new_instance['attachment_id']);
		$instance['image_size'] = $new_instance['image_size'];
		if (current_user_can('unfiltered_html'))
			$instance['text'] =  $new_instance['text'];
		else
			$instance['text'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['text'])));
		$instance['filter'] = ! empty($new_instance['filter']);
		$instance['link_url'] = strip_tags($new_instance['link_url']);
		$instance['link_text'] = $new_instance['link_text'];
		$instance['is_full_link'] = (boolean) intval($new_instance['is_full_link']);
		return $instance;
	}

	function form($instance) {
		global $_wp_additional_image_sizes;

		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
			'attachment_id' => '',
			'image_size' => 'thumbnail',
			'text' => '',
			'link_url' => '',
			'link_text' => wTheme::__('Read more'),
			'is_full_link' => '1',
		));

		$image_sizes = array();
		$all_image_sizes = apply_filters('image_size_names_choose', array('full' => wTheme::__('Full size')));
		foreach($all_image_sizes as $size=>$label) {
			if (in_array($size, array('thumbnail', 'medium', 'large'))) {
				$width = get_option($size.'_size_w');
				$height = get_option($size.'_size_h');
				$image_sizes[$size] = "{$label} {$width} x {$height}";
			} else if (isset($_wp_additional_image_sizes[$size])) {
				$width = $_wp_additional_image_sizes[$size]['width'];
				$height = $_wp_additional_image_sizes[$size]['height'];
				$image_sizes[$size] = "{$label} {$width} x {$height}";
			} else if ('full' == $size) {
				$image_sizes[$size] = $label;
			}
		}

		$attachment_field_id = $this->get_field_id('attachment_id');
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<?php echo wTheme::get_media_popup_field($this->get_field_name('attachment_id'), @$instance['attachment_id'], wTheme::__('Image').':', array('id'=>$attachment_field_id)); ?>
		<?php if ('__i__' == $this->number) { //@hack after add new widget media dont init ?>
			<span class="widget_number_after_drop" rel="__i__" style="display: none;"></span>
			<script>
				jQuery(function() {
					var attachment_field_id = '<?php echo $attachment_field_id; ?>';
					var $span = jQuery('.widget-liquid-right .widget_number_after_drop');
					var widget_number = $span.attr('rel');
					if (widget_number && '__i__' != widget_number) {
						attachment_field_id = attachment_field_id.replace('__i__', widget_number);
						wtheme_media_popup_attachment_button(jQuery('#'+attachment_field_id+' .button-set'), jQuery('#'+attachment_field_id+' .button-remove'));
						$span.remove();
					}
				});
			</script>
		<?php } ?>
		<p>
			<label for="<?php echo $this->get_field_id('image_size'); ?>"><?php wTheme::_e('Image size'); ?>:</label>
			<select name="<?php echo $this->get_field_name('image_size'); ?>" id="<?php echo $this->get_field_id('image_size'); ?>">
				<?php foreach ($image_sizes as $k=>$label) { ?>
				<option value="<?php echo $k; ?>" <?php selected($instance['image_size'], $k); ?>><?php echo $label; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('text'); ?>"><?php wTheme::_e('Content'); ?>:</label>
			<textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo esc_textarea($instance['text']); ?></textarea>
		</p>
		<p><input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php _e('Automatically add paragraphs'); ?></label></p>
		<p>
			<label for="<?php echo $this->get_field_id('link_url'); ?>"><?php wTheme::_e('Link url'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('link_url'); ?>" name="<?php echo $this->get_field_name('link_url'); ?>" type="text" value="<?php echo esc_attr($instance['link_url']); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('link_text'); ?>"><?php wTheme::_e('Link text'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('link_text'); ?>" name="<?php echo $this->get_field_name('link_text'); ?>" type="text" value="<?php echo esc_attr($instance['link_text']); ?>" />
		</p>
		<p>
			<input type="hidden" name="<?php echo $this->get_field_name('is_full_link'); ?>" value="0" />
			<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('is_full_link'); ?>" name="<?php echo $this->get_field_name('is_full_link'); ?>" <?php checked(@$instance['is_full_link']); ?> value="1" />
			<label for="<?php echo $this->get_field_id('is_full_link'); ?>"><?php wTheme::_e('Make full box link'); ?></label>
		</p>
		<?php
	}
}

//widget with wpml plugin integration
class wTheme_Widget_Featured_Text_Icl extends wTheme_Widget_Featured_Text {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_featured_text_icl',
			'description' => wTheme::__('This widget can display text, image and link to pages you want to promote.'),
		);
		WP_Widget::__construct(wTheme::prefix('widget_featured_text_icl'), wTheme::__('Multi language featured text'), $widget_ops);
	}

	function widget($args, $instance) {
		if ($instance['icl_language'] != 'multilingual' && $instance['icl_language'] != ICL_LANGUAGE_CODE)
			return;
		parent::widget($args, $instance);
	}

	function update($new_instance, $old_instance) {
		$old_instance = parent::update($new_instance, $old_instance);
		$instance = $old_instance;

		if ($new_instance['icl_language'] == 'multilingual') {
			global $wpdb;
			$string = $wpdb->get_row($wpdb->prepare("SELECT id, value, status FROM {$wpdb->prefix}icl_strings WHERE context=%s AND name=%s", 'Widgets', 'widget body - ' . $this->id));
			if ($string) {
				icl_st_update_string_actions('Widgets', 'widget body - ' . $this->id, $old_instance['text'], $instance['text']);
			} else {
				icl_register_string('Widgets', 'widget body - ' . $this->id, $instance['text']);
			}
		}
		$instance['icl_language'] = $new_instance['icl_language'];
		return $instance;
	}

	function form($instance) {
		parent::form($instance);
		$instance = wp_parse_args((array) $instance, array(
			'icl_language' => 'multilingual',
		));
		$language = $instance['icl_language'];
		?>
		<p><?php icl_widget_text_language_selectbox($language, $this->get_field_name('icl_language')); ?></p>
		<?php
	}
}

class wTheme_Widget_Latest_Events extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_latest_events',
			'description' => wTheme::__('This widget can display latest events.'),
		);
		parent::__construct(wTheme::prefix('latest_events'), wTheme::__('Latest events'), $widget_ops);
	}

	function widget($args, $instance) {
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);


		$args = array(
			'post_type' => wEvent::$post_type,
			'posts_per_page' => 2,
			'post_status'	 => 'publish',
			'orderby'    => 'meta_value',
			'meta_key'  => 'start_date',
			'post_parent'	=> 0,
			'order'      => 'ASC',
			'meta_query' => array(
				array(
					'key'     => 'start_date',
					'value'   => current_time('mysql'),
					'type'	  =>'DATETIME',
					'compare' => '>=',
				),
			),
		);
		$post_query = new WP_Query( $args );
		if (!$post_query->have_posts()) {
			return;
		}
		echo $before_widget;
		echo $before_title.'<span>'.$title.'</span>'.$after_title;

		?>
		<div class="list">
			<?php
				while ($post_query->have_posts()) { $post_query->the_post();
					$id = get_the_ID();
					$all_meta = wEvent::get_all_meta($id);
					$start_date = mysql2date('j.', $all_meta['start_date']);
					$start_date_month = mysql2date('F', $all_meta['start_date']);
					?>
					<div class="item">
						<?php if (!empty($start_date)) { ?>
							<span class="time">
								<span><?php echo $start_date; ?></span>
								<span><?php echo $start_date_month; ?></span>
							</span>
						<?php } ?>
						<div class="content_wrap <?php if (empty($start_date)) echo 'full_width'; ?>">
							<h4><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
							<div class="item_content">
								<?php echo wTheme::truncate(wTheme::get_the_excerpt(), 100); ?>
							</div>
						</div>
					</div>
					<?php
				}
			?>
		</div>
		<div class="more"><a class="read_more" href="#<?php //echo wTheme::get_url_by_template('event_list'); ?>"><?php wTheme::_e('Se alle begivenheder'); ?><span></span></a></div>
		<?php
		echo $after_widget;

		wp_reset_postdata();
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		return $instance;
	}

	function form($instance) {
		$instance = wp_parse_args((array) $instance, array(
			'title' => '',
		));

		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget title:'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<?php
	}
}

class wTheme_Widget_Recent_Post extends WP_Widget_Recent_Posts {

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;

		/**
		 * Filters the arguments for the Recent Posts widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true
		) ) );

		if ($r->have_posts()) :
			?>
			<?php echo $args['before_widget']; ?>
			<?php if ( $title ) {
			echo $args['before_title'].'<span>'.$title.'</span>'.$args['after_title'];
		} ?>
			<div class="list">
				<?php while ( $r->have_posts() ) : $r->the_post(); ?>
					<div class="item">
						<?php if (has_post_thumbnail()) { ?>
							<span class="thumb">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(wTheme::prefix('post_thumb_widget')); ?></a>
							</span>
						<?php } ?>
						<div class="content_wrap <?php if (!has_post_thumbnail()) echo 'full_width'; ?>">
							<?php if ( $show_date ) : ?>
								<span class="time"><?php echo get_the_date('d M Y'); ?></span>
							<?php endif; ?>
							<h4><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h4>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
			<div class="more"><a class="read_more" href="<?php echo get_permalink(get_option('page_for_posts')); ?>"><?php wTheme::_e('Se alle nyheder'); ?><span></span></a></div>
			<?php echo $args['after_widget']; ?>
			<?php
			// Reset the global $the_post as this query will have stomped on it
			wp_reset_postdata();

		endif;
	}
}

class wTheme_Widget_Footer_Content extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_footer_content',
			'description' => wTheme::__('This widget display footer content from theme settings.'),
		);
		parent::__construct(wTheme::prefix('footer_content'), wTheme::__('Footer content'), $widget_ops);
	}

	public function widget( $args, $instance ) {
		?>
		<?php echo $args['before_widget']; ?>
		<?php echo wTheme::part('logo', array('type'=>'footer')); ?>
		<?php $copyright = wThemeSettings::get_option('Footer.content'); ?>
		<?php if ('' !== trim($copyright)) { ?>
			<div class="copyright">
				<?php echo $copyright; ?>
			</div>
		<?php } ?>
		<?php echo $args['after_widget']; ?>
		<?php
	}
}
