<?php

class wPage extends wCustomPostType {

	static $post_type = '';

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		$post_type = $this->post_type();

		add_meta_box(wTheme::prefix('map_settings'), wTheme::__('Map settings'), array($this, 'meta_box__map_settings'), $post_type, 'advanced', 'low');
	}

	function add_hooks() {
		parent::add_hooks();
		add_action('manage_pages_custom_column', array($this, 'wtheme_action__manage_pages_custom_column'), 10, 2);
		add_filter('manage_pages_columns', array($this, 'wtheme_filter__manage_pages_columns'));
	}

	function meta_box__map_settings($post) {
		$meta_key = wTheme::prefix('map_settings');
		$data = get_post_meta($post->ID, $meta_key, true);
		$this->nonce_field($meta_key);
		?>
		<p class="type">
			<?php $field = 'type'; $value = isset($data[$field]) ? $data[$field] : 'embed_code'; ?>
			<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="embed_code" />
			<label style="margin-right: 20px;"><input type="radio" name="<?php $this->field_name($field, $meta_key); ?>" value="embed_code" <?php checked($value, 'embed_code'); ?> /><?php wTheme::_e('Embed code'); ?></label>
			<label style="margin-right: 20px;"><input type="radio" name="<?php $this->field_name($field, $meta_key); ?>" value="address" <?php checked($value, 'address'); ?> /><?php wTheme::_e('Address'); ?></label>
			<label><input type="radio" name="<?php $this->field_name($field, $meta_key); ?>" value="coordinates" <?php checked($value, 'coordinates'); ?> /><?php wTheme::_e('Coordinates'); ?></label>
		</p>
		<div class="embed_code toggle" style="display: none;">
			<p>
				<?php $field = 'embed_code'; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Embed code'); ?></label><br />
				<textarea name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>" rows="5" cols="80" class="widefat"><?php echo esc_textarea($value); ?></textarea>
			</p>
		</div>
		<div class="address_coordinates toggle" style="display: none;">
			<div class="address" style="display: none;">
				<?php $field = 'address_latitude'; $value = @$data[$field]; ?>
				<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" />
				<?php $field = 'address_longitude'; $value = @$data[$field]; ?>
				<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" />
				<p>
					<?php $field = 'address'; $value = @$data[$field]; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Address'); ?></label><br />
					<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="large-text" style="width: 50%;" />
				</p>
				<div style="clear: both; overflow: hidden;">
					<p style="float: left; margin-right: 20px;">
						<?php $field = 'zip'; $value = @$data[$field]; ?>
						<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Zip code'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 60px;" />
					</p>
					<p style="float: left;">
						<?php $field = 'city'; $value = @$data[$field]; ?>
						<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('City'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" class="middle-text" />
					</p>
				</div>
				<?php
					if (!empty($data['address_latitude']) && !empty($data['address_longitude'])) {
						$map_args = array(
							'latitude' => $data['address_latitude'],
							'longitude' => $data['address_longitude'],
						);
						if ('' != $data['zoom'])
							$map_args['zoom'] = $data['zoom'];
						echo wGoogleMaps::get_static_map($map_args);
					}
				?>
			</div>
			<div class="coordinates" style="display: none;">
				<div style="overflow: hidden;">
					<p style="float: left; margin-right: 20px;">
						<?php $field = 'latitude'; $value = @$data[$field]; ?>
						<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Latitude'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
					</p>
					<p style="float: left;">
						<?php $field = 'longitude'; $value = @$data[$field]; ?>
						<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Longitude'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
					</p>
				</div>
				<?php
					if (!empty($data['latitude']) && !empty($data['longitude'])) {
						$map_args = array(
							'latitude' => $data['latitude'],
							'longitude' => $data['longitude'],
						);
						if ('' != $data['zoom'])
							$map_args['zoom'] = $data['zoom'];
						echo wGoogleMaps::get_static_map($map_args);
					}
				?>
			</div>
			<div style="overflow: hidden;">
				<p style="float: left; margin-right: 20px;">
					<?php $field = 'map_height'; $value = @$data[$field]; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Map height'); ?></label><br />
					<span style="display: block;">
						<input type="number" min="0" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 80px;" />
						<span class="description">px</span>
					</span>
				</p>
				<p style="float: left;">
					<?php $field = 'zoom'; $value = @$data[$field]; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Zoom'); ?></label><br />
					<input type="number" min="1" max="20" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 60px;" />
				</p>
			</div>
			<hr />
			<h3><?php wTheme::_e('Info window'); ?></h3>
			<p>
				<?php $field = 'info_window_title'; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Title'); ?></label><br />
				<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
			</p>
			<p>
				<?php $field = 'info_window_description'; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Description'); ?></label><br />
				<textarea name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>" rows="5" cols="40"><?php echo esc_textarea($value); ?></textarea>
			</p>
			<div style="overflow: hidden">
				<p style="float: left; margin-right: 20px;">
					<?php $field = 'info_window_width'; $value = @$data[$field]; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Width'); ?></label><br />
					<span style="display: block;">
						<input type="number" min="0" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 80px;" />
						<span class="description">px</span>
					</span>
				</p>
				<p style="float: left;">
					<?php $field = 'info_window_height'; $value = @$data[$field]; ?>
					<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Height'); ?></label><br />
					<span style="display: block;">
						<input type="number" min="0" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr($value); ?>" id="<?php $this->field_id($field, $meta_key); ?>" style="width: 80px;" />
						<span class="description">px</span>
					</span>
				</p>
			</div>
			<p>
				<?php $field = 'info_window_auto_open'; $value = @$data[$field]; ?>
				<input type="hidden" name="<?php $this->field_name($field, $meta_key); ?>" value="0" />
				<label><input type="checkbox" name="<?php $this->field_name($field, $meta_key); ?>" value="1" <?php checked(@$value, '1'); ?> /> <?php wTheme::_e('Auto open'); ?></label>
			</p>
		</div>
		<hr />
		<p>
			<?php $field = 'position'; $value = @$data[$field]; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Position'); ?></label><br />
			<select name="<?php $this->field_name($field, $meta_key); ?>" id="<?php $this->field_id($field, $meta_key); ?>">
				<option value="top" <?php selected($value, 'top'); ?>><?php wTheme::_e('Top'); ?></option>
				<option value="right" <?php selected($value, 'right'); ?>><?php wTheme::_e('Right'); ?></option>
				<option value="bottom" <?php selected($value, 'bottom'); ?>><?php wTheme::_e('Bottom'); ?></option>
				<option value="left" <?php selected($value, 'left'); ?>><?php wTheme::_e('Left'); ?></option>
			</select>
		</p>
		<script>
			(function() {
				var $metaBoxMapSettings = jQuery('#<?php echo wTheme::prefix('map_settings'); ?>');
				jQuery('#page_template').change(function() {
					$metaBoxMapSettings.toggle('page-templates/contact.php' === jQuery(this).val());
				}).change();

				var $block_for_hide = $metaBoxMapSettings.find('div.toggle, .address_coordinates .address, .address_coordinates .coordinates');
				$metaBoxMapSettings.find('.type input:radio').change(function () {
					var $this = jQuery(this);
					if ($this.prop('checked')) {
						$block_for_hide.hide();
						var $parent = $metaBoxMapSettings.find('div[class*="'+$this.val()+'"]');
						$parent.show();
						$parent.find('div.'+$this.val()).show();
					}
				}).change();
			})();
		</script>
		<?php
	}

	function save_map_settings($post_id) {
		$meta_key = wTheme::prefix('map_settings');
		$old_data = get_post_meta($post_id, $meta_key, true);
		$data = &$_POST['data'][$meta_key];
		$location_by_address = wGoogleMaps::get_location_by_address_for_save($data, $old_data);
		$data['address_latitude'] = $location_by_address['latitude'];
		$data['address_longitude'] = $location_by_address['longitude'];
		$location_by_coordinates = wGoogleMaps::get_location_by_coordinates_for_save(@$data['latitude'], @$data['longitude']);
		$data['latitude'] = $location_by_coordinates['latitude'];
		$data['longitude'] = $location_by_coordinates['longitude'];
		$this->save_meta_data($post_id, $meta_key, false);
	}

	function action__save_post($post_id) {
		parent::action__save_post($post_id);
		$this->save_map_settings($post_id);
	}

	function wtheme_filter__manage_pages_columns($columns) {
		return array_merge($columns, array('page_template'=>wTheme::__('Page Template')));
	}

	function wtheme_action__manage_pages_custom_column($column_name, $post_id) {
		if ('page_template' === $column_name) {
			$template_name = __('Default Template');
			$templates = get_page_templates($post_id);
			$template = get_post_meta($post_id, '_wp_page_template', true);
			if ($_template_name = array_search($template, $templates)) {
				$template_name = $_template_name;
				if (WP_DEBUG)
					$template_name .= '<br /><span class="description">'.str_replace('page-templates/', '', $template).'</span>';
			}
			echo $template_name;

			global $wSidebar;
			$sidebars = $wSidebar->get_sidebars_names($post_id);

			if (empty($sidebars))
				return;

			echo '<br /><span class="description" style="font-size:10px;">'.implode(', ', $sidebars).'</span>';
		}
	}
}