<?php
/**
 * Version: 0.0.1
 */

/*
<p>
	<?php $field_name = 'from'; ?>
	<label for="<?php self::field_id($field_name, $meta_key); ?>"><?php wTheme::_e("From"); ?></label><br />
	<input type="text" name="<?php self::field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field_name]); ?>" id="<?php self::field_id($field_name, $meta_key); ?>" class="datetimepicker" autocomplete="off" maxlength="16" />
</p>
<p>
	<?php $field_name = 'to'; ?>
	<label for="<?php self::field_id($field_name, $meta_key); ?>"><?php wTheme::_e("To"); ?></label><br />
	<input type="text" name="<?php self::field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field_name]); ?>" id="<?php self::field_id($field_name, $meta_key); ?>" class="datetimepicker" autocomplete="off" maxlength="16" />
</p>


<p>
	<?php $field_name = 'date'; ?>
	<label for="<?php self::field_id($field_name, $meta_key); ?>"><?php wTheme::_e("Date"); ?></label><br />
	<input type="text" name="<?php self::field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field_name]); ?>" id="<?php self::field_id($field_name, $meta_key); ?>" class="datepicker" autocomplete="off" maxlength="10" />
</p>

<script>
	jQuery(function () {
		jQuery('.datetimepicker').datetimepicker();
		jQuery('.datepicker').datepicker();
	});
</script>

$meta_key = wTheme::prefix('additional_fields');
if (self::can_save_meta_data($post_id, $meta_key))
	wDatePicker::prepare_save_fields(array('start_date', 'end_date'), $meta_key, true, true);
self::save_meta_data($post_id, $meta_key);
*/
class wDatePicker {

	static $filename = '';

	static $datepicker_post_types = array();

	static $datetimepicker_post_types = array();

	static function construct() {
		self::$filename = get_template_directory_uri().'/js/jquery-ui-timepicker-addon.min.js';
	}

	static function datepicker($post_types) {
		self::$datepicker_post_types = array_unique(array_merge(self::$datepicker_post_types, (array) $post_types));
		add_action('admin_head-post.php', array(__CLASS__, 'action__admin_head_load_datepicker'));
		add_action('admin_head-post-new.php', array(__CLASS__, 'action__admin_head_load_datepicker'));
	}

	static function action__admin_head_load_datepicker() {
		$screen = get_current_screen();
		if ($screen->post_type === $screen->id && in_array($screen->post_type, self::$datepicker_post_types)) {
			wDatePicker::load_datepicker();
		}
	}

	static function load_datepicker() {
		global $wp_scripts;

		wp_enqueue_script('jquery-ui-datepicker');

		$version = $wp_scripts->registered['jquery-ui-datepicker']->ver;
		$base = "//ajax.googleapis.com/ajax/libs/jqueryui/{$version}";
		$theme = version_compare($version, '1.10', '<') ? 'base' : 'smoothness';
		wp_enqueue_style('jquery-ui-datepicker-css', "{$base}/themes/{$theme}/jquery-ui.min.css", false, $version);

		$locale = current(explode('_', get_locale()));
		if ('en' !== $locale) {
			wp_enqueue_script('jquery-ui-datepicker-locale-js', "{$base}/i18n/datepicker-{$locale}.min.js", false, $version, true);
		}
		?>
		<script>
			jQuery(function ($) {
				var _connectDatepicker = $.datepicker._connectDatepicker;
				$.datepicker._connectDatepicker = function (target, inst) {
					var $target = $(target);
					var $altField = $target.clone(false).appendTo($target.parent()).hide();
					inst.settings.altField = $altField;
					inst.settings.dateFormat = inst.settings.altFormat = "yy-mm-dd";
					inst.settings.firstDay = 1;

					_connectDatepicker.call(this, target, inst);
					$target.removeAttr("name").datepicker("option", "dateFormat", "dd.mm.yy").bind('change paste keyup blur', function () {
						if ('' == $target.val())
							$altField.val('');
					});
				};
			});
		</script>
		<?php
	}

	static function datetimepicker($post_types) {
		self::$datetimepicker_post_types = array_unique(array_merge(self::$datetimepicker_post_types, (array) $post_types));
		add_action('admin_head-post.php', array(__CLASS__, 'action__admin_head_load_datetimepicker'));
		add_action('admin_head-post-new.php', array(__CLASS__, 'action__admin_head_load_datetimepicker'));
	}

	static function action__admin_head_load_datetimepicker() {
		$screen = get_current_screen();
		if ($screen->post_type === $screen->id && in_array($screen->post_type, self::$datetimepicker_post_types)) {
			wDatePicker::load_datetimepicker();
		}
	}

	static function load_datetimepicker_scripts_styles() {
		global $wp_scripts;

		wp_enqueue_script('jquery-ui-datepicker', false, array('jquery'));
		wp_enqueue_script('jquery-ui-slider', false, array('jquery'));
		wp_enqueue_script('jquery-ui-spinner', false, array('jquery'));
		wp_enqueue_script('jquery-ui-timepicker-addon', self::$filename);

		$version = $wp_scripts->registered['jquery-ui-datepicker']->ver;
		$version = version_compare($version, '1.10', '<') ? '1.10.3' : $version;
		$theme = version_compare($version, '1.10', '<') ? 'base' : 'smoothness';
		$base = "//ajax.googleapis.com/ajax/libs/jqueryui/{$version}";
		wp_enqueue_style('jquery-ui-datepicker-css', "{$base}/themes/{$theme}/jquery-ui.min.css", false, $version);

		$locale = current(explode('_', get_locale()));
		if ('en' != $locale) {
			wp_enqueue_script('jquery-ui-datepicker-locale-js', "{$base}/i18n/datepicker-{$locale}.min.js", false, $version, true);
		}
		?>
		<style>
			/* css for timepicker */
			.ui-timepicker-div .ui-widget-header { margin-bottom: 8px; }
			.ui-timepicker-div dl { text-align: left; }
			.ui-timepicker-div dl dt { float: left; clear:left; padding: 0 0 0 5px; }
			.ui-timepicker-div dl dd { margin: 0 10px 10px 45%; }
			.ui-timepicker-div td { font-size: 90%; }
			.ui-timepicker-div .ui_tpicker_unit_hide { display: none; }
			.ui-timepicker-div .ui_tpicker_time .ui_tpicker_time_input { background: none; color: inherit; border: none; box-shadow: none !important; outline: none; border-bottom: solid 1px #555; width: 95%; }
			.ui-tpicker-grid-label { background: none; border: none; margin: 0; padding: 0; }

			.ui-timepicker-rtl{ direction: rtl; }
			.ui-timepicker-rtl dl { text-align: right; padding: 0 5px 0 0; }
			.ui-timepicker-rtl dl dt{ float: right; clear: right; }
			.ui-timepicker-rtl dl dd { margin: 0 45% 10px 10px; }
		</style>
		<?php
	}

	static function load_datetimepicker() {
		wDatePicker::load_datetimepicker_scripts_styles();
		$locale = current(explode('_', get_locale()));
		?>
		<script>
			jQuery(function ($) {
				var controls = {
					create: function (tp_inst, obj, unit, val, min, max, step) {
						$('<input class="ui-timepicker-input" value="' + val + '" style="width:50%">')
								.appendTo(obj)
								.spinner({
									min: min,
									max: max,
									step: step,
									change: function (e, ui) { // key events
										// don't call if api was used and not key press
										if (e.originalEvent !== undefined)
											tp_inst._onTimeChange();
										tp_inst._onSelectHandler();
									},
									spin: function (e, ui) { // spin events
										tp_inst.control.value(tp_inst, obj, unit, ui.value);
										tp_inst._onTimeChange();
										tp_inst._onSelectHandler();
									}
								});
						return obj;
					},
					options: function (tp_inst, obj, unit, opts, val) {
						if (typeof(opts) == 'string' && val !== undefined)
							return obj.find('.ui-timepicker-input').spinner(opts, val);
						return obj.find('.ui-timepicker-input').spinner(opts);
					},
					value: function (tp_inst, obj, unit, val) {
						if (val !== undefined)
							return obj.find('.ui-timepicker-input').spinner('value', val);
						return obj.find('.ui-timepicker-input').spinner('value');
					}
				};

				jQuery.timepicker.regional['en'] = {
					currentText: 'Current time'
				};

				jQuery.timepicker.regional['da'] = {
					currentText: 'Aktuel tid',
					closeText: 'Godkend',
					timeOnlyTitle: 'Vælg tid',
					timeText: 'Tidspunkt:',
					hourText: 'Time',
					minuteText: 'Minut',
					secondText: 'Sekund',
					millisecText: 'Millisekund',
					microsecText: 'Microsekund',
					timezoneText: 'Tidszone'
				};

				jQuery.timepicker.setDefaults(jQuery.timepicker.regional['<?php echo $locale; ?>']);

				var _connectDatepicker = $.datepicker._connectDatepicker;
				$.datepicker._connectDatepicker = function (target, inst) {
					var $target = $(target);
					var $altField = inst.settings.altField;
					if (!$altField) {
						$altField = $target.clone(false).appendTo($target.parent()).hide();
						inst.settings.altField = $altField;
					}

					var originalOptions = inst.settings.originalOptions ? inst.settings.originalOptions : {};
					originalOptions.dateFormat = inst.settings.dateFormat ? inst.settings.dateFormat : 'dd.mm.yy';

					inst.settings.dateFormat = inst.settings.altFormat = "yy-mm-dd";
					inst.settings.firstDay = 1;

					_connectDatepicker.call(this, target, inst);
					for (var option_name in originalOptions)
						$target.datepicker("option", option_name, originalOptions[option_name]);

					$target.removeAttr("name").bind('change paste keyup blur', function () {
						if ('' == $target.val())
							$altField.val('');
					});
				};

				var _newInst = $.timepicker._newInst;
				$.timepicker._newInst = function ($target, o) {
					var $altField = $target.clone(false).appendTo($target.parent()).hide();

					var defaults = {
						altField: $altField,
						altFormat: "yy-mm-dd",
						timeFormat: "HH:mm:ss",
						altTimeFormat: "HH:mm:ss",
						firstDay: 1,
						controlType: controls,
						showMillisec: false,
						showMicrosec: false,
						showTimezone: false,
						altFieldTimeOnly: false,
						originalOptions: {
							timeFormat: o.timeFormat ? o.timeFormat : "HH:mm:ss"
						}
					};

					var inst = $.extend({}, defaults, o);

					return _newInst.call(this, $target, inst);
				};
			});
		</script>
		<?php
	}

	static function prepare_save_fields($fields, $meta_key, $is_add_time = true, $is_period = false) {
		$data = stripslashes_deep($_POST['data'][$meta_key]);

		$from_time = $to_time = '';
		if ($is_add_time) {
			$from_time = ' 00:00:00';
			$to_time = ' 23:59:59';
		}

		if ($is_period && 2 === count($fields)) {
			$from_meta_key = $fields[0];
			$to_meta_key = $fields[1];
			$from_date = $data[$from_meta_key];
			if ('' === $from_date)
				$from_date = $data[$to_meta_key];
			if ('' !== $from_date)
				$data[$from_meta_key] = $from_date.$from_time;

			$to_date = $data[$to_meta_key];
			if ('' === $to_date) {
				$to_date_format = 'Y-m-d';
				if (count(explode(':', $data[$from_meta_key])) > 1) {
					$to_date_format .= ' 23:59:59';
					$to_time = '';
				}
				$to_date = date($to_date_format, strtotime($data[$from_meta_key]));
			}

			if ('' !== $to_date)
				$data[$to_meta_key] = $to_date.$to_time;
		} else {
			foreach ((array) $fields as $field) {
				$value = $data[$field];
				if ('' !== $value)
					$data[$field] = $value.$from_time;
			}
		}
		$_POST['data'][$meta_key] = $data;
	}

	static function get_datetime($post_id, $meta_key_from = 'from', $meta_key_to = 'to') {
		$from = get_post_meta($post_id, $meta_key_from, true);
		$to = get_post_meta($post_id, $meta_key_to, true);
		$from_date = date('d-m-Y', strtotime($from));
		$out = date('d-m-Y H:i', strtotime($from));
		if ($from !== $to) {
			$to_date = date('d-m-Y', strtotime($to));
			if ($from_date === $to_date) {
				$out .= ' - '.date('H:i', strtotime($to));
			} else {
				$out .= ' - '.date('d-m-Y H:i', strtotime($to));
			}
		}

		return $out;
	}

	static function show_datetime($post_id) {
		echo self::get_datetime($post_id);
	}
}
wDatePicker::construct();