<?php
$inc_dir = get_template_directory().'/inc';
$wLib_dir = "{$inc_dir}/wLib";
$wLibApp_dir = "{$inc_dir}/wLibApp";
$wClasses_dir = "{$inc_dir}/wClasses";

require_once "{$wLib_dir}/wTheme.php";
require_once "{$wLib_dir}/wCustomPostType.php";
require_once "{$wLib_dir}/wCustomTaxonomy.php";
require_once "{$wLib_dir}/wSidebar.php";
require_once "{$wLib_dir}/wThemeSettings.php";
require_once "{$wLib_dir}/wGoogleMaps.php";
require_once "{$wLib_dir}/wSlider.php";
require_once "{$wLib_dir}/wDatePicker.php";

require_once "{$inc_dir}/widgets.php";

require_once "{$wLibApp_dir}/wPage.php";
require_once "{$wLibApp_dir}/wEvent.php";
require_once "{$wLibApp_dir}/wEventCategory.php";
require_once "{$wLibApp_dir}/wInspiration.php";
require_once "{$wLibApp_dir}/wInspirationCategory.php";

//Classes
require_once "{$wClasses_dir}/wAccommodation.php";
require_once "{$wClasses_dir}/wAccommodationCategory.php";
require_once "{$wClasses_dir}/wDiscover.php";
require_once "{$wClasses_dir}/wDiscoverCategory.php";
require_once "{$wClasses_dir}/wFood.php";
require_once "{$wClasses_dir}/wFoodCategory.php";
require_once "{$wClasses_dir}/wShop.php";
require_once "{$wClasses_dir}/wShopCategory.php";

wTheme::$layout_options = array(
	'full-width' => array('sidebars' => false),
	'left-sidebar' => array('sidebars' => array('left')),
//	'right-sidebar' => array('sidebars' => array('right')),
//	'two-sidebars' => array('sidebars' => array('left', 'right')),
);

wTheme::$layout = 'left-sidebar';

$wSidebar = new wSidebar(wTheme::prefix('sidebar'));
$wPage = new wPage('page');
$wSlider = new wSlider('slide');

$wEvent = new wEvent(wTheme::prefix('event'));
$wEventCategory = new wEventCategory(wEvent::$post_type . '_cat', wEvent::$post_type);

$wInspiration = new wInspiration(wTheme::prefix('inspiration'));
$wInspirationCategory = new wInspirationCategory(wInspiration::$post_type . '_cat', wInspiration::$post_type);

//Classes
$wAccommodation = new wAccommodation(wTheme::prefix('accommodation'));
$wAccommodationCategory = new wAccommodationCategory(wAccommodation::$post_type . '_cat', wAccommodation::$post_type);
$wDiscover = new wDiscover(wTheme::prefix('discover'));
$wDiscoverCategory = new wDiscoverCategory(wDiscover::$post_type . '_cat', wDiscover::$post_type);
$wFood = new wFood(wTheme::prefix('food'));
$wFoodCategory = new wFoodCategory(wFood::$post_type . '_cat', wFood::$post_type);
$wShop = new wShop(wTheme::prefix('shop'));
$wShopCategory = new wShopCategory(wShop::$post_type . '_cat', wShop::$post_type);

wDatePicker::datetimepicker(array(wEvent::$post_type));