<!DOCTYPE html>
<!--[if lte IE 7]><html id="ie7" <?php language_attributes(); ?>><![endif]-->
<!--[if IE 8]><html id="ie8" <?php language_attributes(); ?>><![endif]-->
<!--[if gte IE 9]><!--><html <?php language_attributes(); ?>><!--<![endif]-->
<head itemscope itemtype="http://schema.org/WebSite">
	<meta charset="<?php bloginfo('charset'); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta name="format-detection" content="telephone=no" />
	<title><?php wp_title('|', true, 'right'); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<meta itemprop="name" content="<?php echo get_bloginfo('name'); ?>" />
	<meta itemprop="url" content="<?php echo get_home_url('/');?>" />
	<script>template_directory_uri = <?php echo json_encode(get_template_directory_uri()); ?>;</script>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> id="site" itemscope itemtype="http://schema.org/WebPage">
<?php wThemeSettings::show_option('General.Body.top_custom_code'); ?>
<div class="container">
	<div class="site_header_wrap">
		<header class="site_header" id="site_header" itemscope itemtype="http://schema.org/WPHeader">
			<div class="left">
				<?php echo wTheme::part('logo', array('type'=>'header')); ?>
			</div>
			<div class="right">
				<div class="clear">
					<div class="burger_menu">
						<div class="menu_button">
							<span>
								<span></span><span class="center"></span><span></span>
							</span>
							<?php wTheme::_e('Menu'); ?>
						</div>
					</div>
					<div class="search">
						<span class="search_button close"><?php wTheme::_e('Luk'); ?></span>
						<span class="search_button open"><?php wTheme::_e('Søg'); ?></span>
						<span class="icon"></span>
					</div>
				</div>
				<nav class="main_menu" id="main_menu" itemscope itemtype="http://schema.org/SiteNavigationElement">
					<div class="menu_button">
						<span></span>
						<?php wTheme::_e('Menu'); ?>
					</div>
					<?php wp_nav_menu(array('theme_location' => 'main_menu', 'container' => '', 'menu_class' => '')); ?>
				</nav>
			</div>
		</header>
	</div>