<?php
	if ($saved)
		echo '<div id="message" class="updated"><p><strong>'.self::__('Settings saved.').'</strong></p></div>';
?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"><br></div>
	<h2><?php self::_e('Settings'); ?></h2>

	<form action="" method="post">
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><label for=""><?php self::_e('Title'); ?></label></th>
				<td>
					<input type="text" name="data[title]" value="<?php echo esc_attr(@$data['title']); ?>" class="regular-text" id="title" />
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="content"><?php self::_e('Content'); ?></label></th>
				<td>
					<div style="width: 50em;">
						<?php wp_editor(@$data['content'], 'content', array('textarea_name'=>'data[content]', 'textarea_rows'=>12)); ?>
					</div>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="read_more_url"><?php self::_e('Read more url'); ?></label></th>
				<td>
					<input type="text" name="data[read_more_url]" value="<?php echo esc_attr(@$data['read_more_url']); ?>" class="regular-text" id="read_more_url" />
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="button_accept_label"><?php self::_e("Text label on accept cookies politics button"); ?></label></th>
				<td>
					<input type="text" name="data[button_accept_label]" value="<?php echo esc_attr(@$data['button_accept_label']); ?>" class="regular-text" id="button_accept_label" />
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="button_leave_site_label"><?php self::_e("Text label on leave site button"); ?></label></th>
				<td>
					<input type="text" name="data[button_leave_site_label]" value="<?php echo esc_attr(@$data['button_leave_site_label']); ?>" class="regular-text" id="button_leave_site_label" />
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="leave_site_url"><?php self::_e('Leave site url'); ?></label></th>
				<td>
					<input type="text" name="data[leave_site_url]" value="<?php echo esc_attr(@$data['leave_site_url']); ?>" class="regular-text" id="leave_site_url" />
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="position"><?php self::_e('Position'); ?></label></th>
				<td>
					<select name="data[position][horizontal]" id="position">
						<option value="left" <?php selected(@$data['position']['horizontal'], 'left'); ?>><?php self::_e('Left'); ?></option>
						<option value="right" <?php selected(@$data['position']['horizontal'], 'right'); ?>><?php self::_e('Right'); ?></option>
					</select>
					<select name="data[position][vertical]">
						<option value="top" <?php selected(@$data['position']['vertical'], 'top'); ?>><?php self::_e('Top'); ?></option>
						<option value="bottom" <?php selected(@$data['position']['vertical'], 'bottom'); ?>><?php self::_e('Bottom'); ?></option>
					</select>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><label for="custom_css"><?php self::_e('Custom styles code'); ?></label></th>
				<td>
					<textarea name="data[custom_css]" id="custom_css" class="code" cols="80" rows="10"><?php echo esc_textarea(@$data['custom_css']); ?></textarea>
					<p class="description"><?php self::_e('Paste custom CSS code here.'); ?></p>
				</td>
			</tr>
		</table>
		<p class="submit">
			<input type="submit" name="submit" class="button-primary" value="<?php self::_e("Save changes"); ?>"/>
			<input type="submit" name="data[reset_settings]" class="button" value="<?php self::_e("Reset settings"); ?>" onclick="return confirm('<?php self::_e("Are you sure that you want to reset settings?"); ?>');" />
		</p>
	</form>
</div>