<?php
/**
 * Plugin Name: WebCoders CF7 Antispam
 * Plugin URI: http://webcoders.dk/
 * Description: The WebCoders Anti-SPAM add-on for Contact Form 7 plugin, will prevent SPAM from most SPAM-bots.
 * Version: 1.0.0
 * Author: WebCoders.dk
 * Author URI: http://webcoders.dk/
 * License: You can read more about our general license agreement on http://webcoders.dk/terms-and-conditions/
 */

//Compatibility with cf7 3.2+ and wp 3.2+

class WebCoders_WPCF7_AntiSpam {

	static $field_name = 'website2';

	static function init() {
		add_filter('wpcf7_form_elements', array(__CLASS__, 'filter_form_elements'), 1);
		add_filter('wpcf7_validate', array(__CLASS__, 'filter_validate'), 10, 5);
	}

	static function filter_form_elements($form_elements) {
		ob_start();
		?>
		<p style="display:none !important;">Website (required)<br />
			<span class="wpcf7-form-control-wrap website2">
				<input class="wpcf7-form-control wpcf7-text wpcf7-validates-as-required" type="text" aria-required="true" size="40" value="<?php echo esc_attr(@$_REQUEST[self::$field_name]); ?>" name="<?php echo self::$field_name; ?>" />
			</span>
		</p>
		<?php
		return ob_get_clean().$form_elements;
	}

	static function filter_validate($result) {
		if(!isset($_REQUEST[self::$field_name]) || '' != @$_REQUEST[self::$field_name]) {
			if (version_compare(WPCF7_VERSION, '4.1', '<')) {
				$result['valid'] = false;
			} else {
				$arg_list = func_get_args();
				if (empty($arg_list[1]))
					return $result;

				$tags = $arg_list[1];
				foreach ($tags as $tag) {
					if (!empty($tag['name'])) {
						$tag = new WPCF7_Shortcode($tag);
						$result->invalidate($tag, 'Invalid field.');
						break;
					}
				}
			}
		}
		return $result;
	}
}

add_action('wpcf7_init', array('WebCoders_WPCF7_AntiSpam', 'init'), 10);
