<?php
	if (empty($ids))
		return;

?>
<div class="staff_list">
	<?php
	foreach ($ids as $id) {
		$meta = wStaff::get_all_meta($id);
		$job_title = @$meta['job_title'];
		$phone = @$meta['phone'];
		$email = @$meta['email'];
		$departments = get_the_terms($id, wDepartment::$taxonomy);
		?>
		<div class="staff_item">
			<span class="thumb">
				<?php if (has_post_thumbnail($id)) { ?>
					<?php echo get_the_post_thumbnail($id, wTheme::prefix('staff_thumb')); ?>
				<?php } ?>
			</span>
			<div>
				<?php if (!empty($departments)) { ?>
					<span class="departments">
						<?php foreach ($departments as $department) {
							echo '<span>'.$department->name.'</span>';
						} ?>
					</span>
				<?php } ?>
				<span><?php echo get_the_title($id); ?></span>
				<?php if (!empty($job_title)) { ?>
					<span class="job_title"><?php echo $job_title; ?></span>
				<?php } ?>
				<?php if (!empty($phone)) { ?>
					<span><?php echo wTheme::__('Mobile').': '; ?><a class="phone" href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a></span>
				<?php } ?>
				<?php if (!empty($email)) { ?>
					<span><?php echo wTheme::__('Email').': '; ?><a class="email" href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></span>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
</div>