<?php
/**
 * Template Name: Page sections
 * Layout: full-width
 */

the_post();

?>
<header class="entry_header">
	<h1 class="entry_title"><?php the_title(); ?></h1>
</header>
<?php
$args = array(
	'post_type' => wPageSection::$post_type,
	'post_status' => 'publish',
	'post_parent' => get_the_ID(),
	'orderby' => 'menu_order ID',
	'order' => 'ASC',
	'suppress_filters' => true,
	'posts_per_page' => -1,
);

$section_query = new WP_Query($args);
if(!$section_query->have_posts())
	return;

?>
<div class="page_sections_wrap">
	<?php
	while ($section_query->have_posts()) { $section_query->the_post();
		$post_section_id = get_the_ID();
		$meta = wPageSection::get_all_meta($post_section_id);
		$layout = $meta['layout'];

		//settings from bg_color_settings()
		$bg_color = @$meta['background_color'];
		$is_parallax = @$meta['is_parallax'];
		$text_color = @$meta['text_color'];
		$bg_image = @$meta['bg_thumbnail_id'];
		$padding_top = @$meta['padding_top'];
		$padding_bottom = @$meta['padding_bottom'];
		$offset_top = @$meta['offset_top'];
		$offset_bottom = @$meta['offset_bottom'];
		$additional_classes = @$meta['additional_classes'];
		$class = 'clear';
		$class .= " {$layout}";
		if (!empty($additional_classes))
			$class .= " {$additional_classes}";

		$slide_box_script = false;

		$min_height = @$meta['min_height'];

		$style = '';
		$fixed_bg = (!empty($is_parallax) && '1' == $is_parallax) ? ' fixed' : '';
		$bg = !empty($bg_image) ? ' url('.wp_get_attachment_url($bg_image).') no-repeat 50% 50% / cover'.$fixed_bg : '';

		if (!empty($bg_color) || !empty($bg))
			$style = 'background:'.$bg_color.$bg.';';

		if (!empty($text_color))
			$style .= 'color:'.$text_color.';';

		if (!empty($min_height))
			$style .= "min-height:{$min_height}px;";

		if (!empty($offset_top))
			$style .= "margin-top:{$offset_top}px;";

		if (!empty($offset_bottom))
			$style .= "margin-bottom:{$offset_bottom}px;";

		if (!empty($padding_top))
			$style .= "padding-top:{$padding_top}px;";

		if (!empty($padding_bottom))
			$style .= "padding-bottom:{$padding_bottom}px;";

		if (!empty($style))
			$style = 'style="'.$style.'"';

		?>
		<article class="<?php echo $class; ?>" id="section-<?php echo $post_section_id; ?>" <?php echo $style; ?>>
			<?php if ('default' == $layout) { ?>
				<div>
					<?php echo wTheme::part('section/default', compact('meta')); ?>
				</div>
			<?php } elseif ('slider_box_pagination' == $layout) { ?>
				<div <?php echo "style='min-height: {$min_height}px;'"; ?>>
					<?php echo wTheme::part('section/slider_box_pagination', compact('meta', 'post_section_id')); ?>
					<?php if (false == $slide_box_script) { ?>
						<?php
						wp_enqueue_script(wTheme::prefix('cycle2'));
						wp_enqueue_script(wTheme::prefix('cycle_swipe'));
						$slide_box_script = true;
						?>
					<?php } ?>
				</div>
			<?php } elseif ('two_blocks' == $layout) { ?>
				<div>
					<?php echo wTheme::part('section/two_blocks', compact('meta')); ?>
				</div>
			<?php } ?>

		</article>
	<?php } ?>
</div>
<?php wp_reset_postdata(); ?>
