jQuery(function() {
	var $link_to_image = jQuery('a').filter(function() {
		var href = jQuery(this).attr('href');
		if(href && !jQuery(this).prop('rel'))
			return href.match(/\.(jpg|png|gif|jpeg|svg)/);
	});

	wtheme_initPrettyPhoto($link_to_image);

	jQuery('.entry_content .shortcode__read_more_button').click(function() {
		var $button_wrap = jQuery(this).parent();
		$button_wrap.hide();
		$button_wrap.prev('.shortcode__hidden_content').slideDown(300);
		$button_wrap.prevAll('.shortcode__visible_content').removeClass('gradient');
		return false;
	});

	jQuery('.entry_content .shortcode_hidecontent').click(function() {
		var $this = jQuery(this);
		$this.next().show();
		jQuery('.'+$this.attr('href').substr(1)).show();
		$this.hide();
		return false;
	});

	jQuery('.entry_content .shortcode_showcontent').click(function() {
		var $this = jQuery(this);
		jQuery('.'+$this.attr('href').substr(1)).hide();
		$this.hide();
		$this.prev().show();
		return false;
	});

	jQuery('.entry_content .shortcode_question').click(function() {
		var $this = jQuery(this);
		var $answer = $this.nextAll('.shortcode_answer:first');
		$answer.slideToggle(function() {
			$this.toggleClass('expand', $answer.is(":visible"));
		});
	});

	jQuery('.entry_content .shortcode_answer:visible').each(function() {
		jQuery(this).prevAll('.shortcode_question:first').addClass('expand');
	});

	var $main_menu = jQuery('nav.main_menu');

	// $main_menu.find('> .menu_button').click(function() {
	// 	jQuery(this).parent().toggleClass('active').find('> ul').slideToggle(500);
	// });

	$main_menu.find('> .menu_button').click(function() {
		jQuery(this).parent().toggleClass('active').find('> ul').slideToggle(500);
		jQuery(this).parent().find('.close').toggle();
	});
	jQuery(".main_menu > ul > li.menu-item-has-children > a").click(function(){
		var $this = jQuery(this);
		if (jQuery($this).parent().hasClass('open')) {
			$this.parent().removeClass('open').find("> .sub-menu").slideUp(500);
			return false;
		}
		jQuery(".main_menu > ul > li.menu-item-has-children").not($this).removeClass('open').find("> .sub-menu").slideUp(500);
		jQuery(this).parent().toggleClass('open').find("> .sub-menu").stop(true, true).slideToggle(500);
		return false;
	});

	jQuery('.scroll_top > a').click(function(){
		jQuery("html, body").animate({scrollTop: 0}, 600);
		return false;
	});
});

jQuery(window).on('load', function() {
	wtheme_two_blocks_fix();
	wtheme_slider_responsive_fix();
	jQuery(window).resize(function() {
		wtheme_slider_responsive_fix();
		if (jQuery(window).width() > 767) {
			wtheme_two_blocks_fix();
		}
		wtheme_clickMenu();
	}).trigger('resize');
});

function wtheme_initPrettyPhoto($list) {
	var settings = {social_tools: false};
	$list.prettyPhoto(settings);
	jQuery("[rel^='prettyPhoto']").prettyPhoto(settings);
}

function wtheme_responsiveMenu() {
	var existingWidth = jQuery(document).data('resize-width');
	var newWidth = jQuery(document).width();
	if (existingWidth != newWidth) {
		var $main_menu = jQuery('nav.main_menu');

		if (jQuery(window).width() < 768) {
			$main_menu.removeClass('active').addClass('responsive').find('> ul').hide();
		} else {
			$main_menu.removeClass('responsive active').find('> ul').show();
		}

		if (768 <= jQuery(window).width() &&  jQuery(window).width() <= 1024) {
			var $items = $main_menu.find('> ul > li');
			var max_width = $main_menu.width();
			var width = 0;

			$items.each(function() {
				if (width + jQuery(this).outerWidth(true) >= max_width) {
					$main_menu.addClass('responsive').find('> ul').hide();
					return false;
				} else {
					$main_menu.removeClass('responsive active').find('> ul').show();
					width += jQuery(this).outerWidth(true);
				}
			});
		}

		jQuery(document).data('resize-width', newWidth);
	}
}

function wtheme_clickMenu() {
	var is_touch = (('ontouchstart' in document.documentElement) || ('ontouchstart' in window) || (navigator.maxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0));
	if (is_touch && (!jQuery('.main_menu').hasClass('responsive'))) {
		jQuery('.main_menu .menu-item-has-children > a').click(function() {
			if (!jQuery(this).data('click')) {
				jQuery(this).data('click', 1).parent().addClass('active').siblings().removeClass('active').find('a').data('click', 0);
				jQuery(this).parent().siblings().find('.active').removeClass('active');
				return false;
			}
		});

		jQuery('body').click(function(e) {
			if (jQuery(e.target).parents('.main_menu').length === 0) {
				jQuery('.main_menu li').removeClass('active').find('a').data('click', 0);
			}
		});
	}
}

function wtheme_two_blocks_fix() {
	var $two_blocks = jQuery('.two_blocks_wrap > div');
	$two_blocks.outerHeight($two_blocks.outerWidth());
}

function wtheme_slider_responsive_fix() {
	var $slider_div = jQuery('.slider_wrap > div');
	var $slider_text = jQuery('.slider_wrap .slider .slide_text');
	var ww = jQuery(window).width();
	$slider_div.css('left', (ww-1920)/2);
	if (ww < 1080) {
		$slider_text.width(ww-40).css('margin-left', -ww/2);
	} else {
		$slider_text.width(1080).css('margin-left', -540);
	}
}
