<?php

class wStaff extends wCustomPostType {

	static $post_type = '';

	function register_post_type($args = array()) {
		parent::register_post_type(
			array(
				'public' => false,
				'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
				'rewrite' => array('slug' => 'staff', 'with_front' => false),
			)
		);
	}

	function add_hooks() {
		parent::add_hooks();
		add_shortcode('staff', array(__CLASS__, 'action__shortcode'));
	}

	function get_labels($singular = '', $plural = '') {
		return parent::get_labels('Staff', 'Staff');
	}

	function action__add_meta_boxes($post) {
		parent::action__add_meta_boxes($post);
		add_meta_box(wTheme::prefix('additional_fields'), wTheme::__('Additional fields'), array($this, 'meta_box_additional_fields'), $this->post_type(), 'side', 'low');
	}

	function meta_box_additional_fields($post) {
		$meta_key = wTheme::prefix('additional_fields');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID);
		?>
		<p>
			<?php $field = 'job_title'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Job title'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'phone'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Phone'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<p>
			<?php $field = 'email'; ?>
			<label for="<?php $this->field_id($field, $meta_key); ?>"><?php wTheme::_e('Email'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field, $meta_key); ?>" />
		</p>
		<?php
	}

	function action__save_post($post_id) {
		$this->save_meta_data($post_id, wTheme::prefix('additional_fields'));
	}

	static function action__shortcode($atts) {
		if (empty($atts['id']))
			return '';

		$ids = explode(',', $atts['id']);
		return wTheme::part('staff_box', compact('ids'));
	}

}
