<?php

require_once get_template_directory().'/inc/wLib/wSection.php';

class wPageSection extends wSection {

	static $post_type;

	var $layouts = array(
		'default' => array('label' => 'Default'),
		'slider_box_pagination' => array('label' => 'Slider box with pagination'),
		'two_blocks' => array('label' => 'Box with two blocks by row'),
	);

	function section_slider_box_pagination($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);

		$slide_box_columns_count = 5;

		if (!isset($data['slide_count']))
			$data['slide_count'] = '0';

		?>
		<p>
			<?php $field = 'title'; $field_name = $section_post->ID.'.'.$field; ?>
			<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Title').' '; ?></label><br />
			<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
		</p>
		<p class="slide_box_slide_count-<?php echo $section_post->ID; ?>">
			<span><?php wTheme::_e('How many slide do you need?'); ?></span>
			<?php $field = 'slide_count'; $field_name = $section_post->ID.'.'.$field; ?>
			<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
			<?php for ($i = 0; $i < $slide_box_columns_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<label style="margin-left:10px;" for="slide_box-column-<?php echo $i.'-'.$section_post->ID; ?>"><input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo $i; ?>" id="slide_box-column-<?php echo $i.'-'.$section_post->ID; ?>" <?php checked(@$data[$field], $i); ?> /> <?php echo $k; ?></label>
			<?php } ?>
		</p>
		<div class="slide_box_columns_wrap-<?php echo $section_post->ID; ?>" style="clear:both;overflow:hidden;">
			<?php for ($i = 0; $i < $slide_box_columns_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<div style="vertical-align: top;margin: 1% 2% 0 0;display: none;">
					<span><strong><?php echo wTheme::__('Slide').' №'.$k; ?></strong></span>
					<p>
						<?php $field = 'title_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Title'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
					</p>
					<p>
						<?php $field = 'sub_title_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Sub title'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
					</p>
					<p>
						<?php $field = 'url_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Url'); ?></label><br />
						<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
					</p>
					<?php /*
					<div>
						<?php $field = 'description_'.$i; $field_name = $section_post->ID.'.'.$field; $value = @$data[$field]; ?>
						<?php wp_editor($value, $this->field_id($field_name, $meta_key, true), array('textarea_name'=>$this->field_name($field_name, $meta_key, true), 'editor_height'=>'280')); ?>
					</div>
					*/ ?>
					<p>
						<?php echo wTheme::get_media_popup_field($this->field_name($section_post->ID.'.pagination_thumbnail_id_'.$i, $meta_key, true), @$data['pagination_thumbnail_id_'.$i], wTheme::__('Pagination featured image').':'); ?>
					</p>
				</div>
			<?php } ?>
		</div>
		<p>
			<?php $field = 'show_navigation'; $field_name = $section_post->ID.'.'.$field; ?>
			<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field_name, $meta_key); ?>" value="1" <?php checked(@$data[$field]); ?> /> <?php wTheme::_e('Show navigation?'); ?></label>
		</p>
		<p>
			<?php $field = 'colored_background'; $field_name = $section_post->ID.'.'.$field; ?>
			<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
			<label><input type="checkbox" name="<?php $this->field_name($field_name, $meta_key); ?>" value="1" <?php checked(@$data[$field]); ?> /> <?php wTheme::_e('Slider with colored background?'); ?></label>
		</p>
		<script>
			jQuery('.slide_box_slide_count-<?php echo $section_post->ID; ?> input:radio').change(function() {
				var $this = jQuery(this);
				if (!$this.is(':checked'))
					return;

				var val = $this.val();
				var $columns = jQuery('.slide_box_columns_wrap-<?php echo $section_post->ID; ?> > div');
				var column_class = 'active ';
				/*if ('0' === val)
					column_class += ' col-1';
				else if ('1' === val)
					column_class += ' col-2';
				else if ('2' === val)
					column_class += ' col-3';
				else if ('3' === val)
					column_class += ' col-4';
				else
					column_class += ' col-4';*/

				$columns.removeClass();
				$columns.eq(val).addClass(column_class).prevAll().addClass(column_class);
			}).change();
		</script>
		<style>
			.slide_box_columns_wrap-<?php echo $section_post->ID; ?> > div.active {
				display: block !important;
			}
		</style>
		<?php
	}

	function bg_color_settings($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		?>
		<hr style="margin-top:20px;" />
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php echo wTheme::get_media_popup_field($this->field_name($section_post->ID.'.bg_thumbnail_id', $meta_key, true), @$data['bg_thumbnail_id'], wTheme::__('Select background image')); ?>
			</p>
			<p>
				<?php $field = 'is_parallax'; $field_name = $section_post->ID.'.'.$field; ?>
				<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
				<label><input type="checkbox" name="<?php $this->field_name($field_name, $meta_key); ?>" value="1" <?php checked(@$data[$field]); ?> /> <?php wTheme::_e('Parallax background?'); ?></label>
			</p>
		</div>
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php $field = 'background_color'; $field_name = $section_post->ID.'.'.$field; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php _e('Background color'); ?></label><br />
				<input class="middle-text color_picker" id="<?php $this->field_id($field_name, $meta_key); ?>" name="<?php $this->field_name($field_name, $meta_key); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
			</p>
		</div>
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php $field = 'min_height'; $field_name = $section_post->ID.'.'.$field; ?>
				<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Section height in px (desktop)'); ?></label><br />
				<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
			</p>
		</div>
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php $field = 'text_color'; $field_name = $section_post->ID.'.'.$field; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php _e('Text color'); ?></label><br />
				<input class="middle-text color_picker" id="<?php $this->field_id($field_name, $meta_key); ?>" name="<?php $this->field_name($field_name, $meta_key); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
			</p>
		</div>
		<div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'offset_top'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section top offset'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'offset_bottom'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section bottom offset'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
		</div>
		<div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'padding_top'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section top padding'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'padding_bottom'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section bottom padding'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
		</div>
		<script>
			jQuery(function() {
				jQuery('.color_picker').each(function(){
					jQuery(this).wpColorPicker();
				});
			});
		</script>
		<?php
	}

	function section_two_blocks($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);

		$two_blocks_section_items_count = 8;

		if (!isset($data['items_count']))
			$data['items_count'] = '0';

		?>
		<p>
			<?php $field = 'title'; $field_name = $section_post->ID.'.'.$field; ?>
			<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Title').' '; ?></label><br />
			<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
		</p>
		<p class="two_blocks_section_items_count-<?php echo $section_post->ID; ?>">
			<span><?php wTheme::_e('How many items do you need?'); ?></span>
			<?php $field = 'items_count'; $field_name = $section_post->ID.'.'.$field; ?>
			<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
			<?php for ($i = 0; $i < $two_blocks_section_items_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<label style="margin-left:10px;" for="two_blocks_item-<?php echo $i.'-'.$section_post->ID; ?>"><input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo $i; ?>" id="two_blocks_item-<?php echo $i.'-'.$section_post->ID; ?>" <?php checked(@$data[$field], $i); ?> /> <?php echo $k.'-'.wTheme::__('item'); ?></label>
			<?php } ?>
		</p>
		<div class="two_blocks_section_items_wrap-<?php echo $section_post->ID; ?>" style="clear:both;overflow:hidden;">
			<?php for ($i = 0; $i < $two_blocks_section_items_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<div style="display: none; margin-top: 20px;">
					<div>
						<hr>
						<h3>
							<?php
								$n = $i+1;
								echo wTheme::__("Item").' '.$n;
							?>
						</h3>
					</div>
					<?php $field = 'item_type_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
					<?php
						if ('' == @$data[$field])
							@$data[$field] = 'text';
					?>
					<div class="select_type">
						<label for="two_blocks_item_type_text-<?php echo $i.'-'.$section_post->ID; ?>">
							<input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="text" id="two_blocks_item_type_text-<?php echo $i.'-'.$section_post->ID; ?>" <?php checked(@$data[$field], 'text'); ?> /> Text
						</label> / <label for="two_blocks_item_type_image-<?php echo $i.'-'.$section_post->ID; ?>">
							<input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="image" id="two_blocks_item_type_image-<?php echo $i.'-'.$section_post->ID; ?>" <?php checked(@$data[$field], 'image'); ?> /> Image
						</label>
					</div>
					<div class="type_wrap">
						<div class="text" style="display: none;">
							<p>
								<?php $field = 'title_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
								<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Title'); ?></label><br />
								<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
							</p>
							<div>
								<?php wp_editor(@$data['post_content_'.$i], $this->field_id("post_content_{$i}_{$section_post->ID}", $meta_key, true), array('textarea_name'=>$this->field_name($section_post->ID.'][post_content_'.$i, $meta_key, true), 'editor_height'=>'280')); ?>
							</div>
						</div>
						<div class="image" style="display: none;">
							<p>
								<?php echo wTheme::get_media_popup_field($this->field_name($section_post->ID.'.thumbnail_id_'.$i, $meta_key, true), @$data['thumbnail_id_'.$i], wTheme::__('Image').':'); ?>
							</p>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
		<script>
			jQuery('.two_blocks_section_items_count-<?php echo $section_post->ID; ?> input:radio').change(function() {
				var $this = jQuery(this);
				if (!$this.is(':checked'))
					return;

				var val = $this.val();
				var $columns = jQuery('.two_blocks_section_items_wrap-<?php echo $section_post->ID; ?> > div');
				$columns.removeClass('active');
				$columns.eq(val).addClass('active').prevAll().addClass('active');
			}).change();

			// sub items
			jQuery('.two_blocks_section_items_wrap-<?php echo $section_post->ID; ?> .select_type input:radio').change(function() {
				var $this = jQuery(this);
				if (!$this.is(':checked'))
					return;
				var val = $this.val();
				var $items = $this.parent().parent().next().find('>div');
				$items.removeClass('active');
				$items.filter('.'+val).addClass('active');
			}).change();
		</script>
		<style>
			.two_blocks_section_items_wrap-<?php echo $section_post->ID; ?> div.active {
				display: block !important;
			}
		</style>
		<?php
	}
}
