<?php
/**
 * Version: 0.0.4
 */
class wSection extends wCustomPostType {

	/**
	 * override or add new section layouts in $layouts array.
	 * example for create section layout - function section_{section_name}($section_post, $meta_key) {}
	 */
	var $layouts = array(
		'default' => array('label'=>'Default'),
		//'section_name' => array('label'=>'Section label'),
	);

	//write page-templates where need use section logic
	var $page_templates = array('page-templates/page_sections.php');

	static $duplicate_action = 'duplicate';

	function add_hooks() {
		parent::add_hooks();
		foreach ($this->get_post_types() as $post_type) {
			add_action("add_meta_boxes_{$post_type}", array($this, 'action__add_meta_boxes'));
		}
		add_filter('page_row_actions', array($this, 'filter__row_actions'), 10, 2);
		add_filter('post_row_actions', array($this, 'filter__row_actions'), 10, 2);
		add_action('admin_action_'.self::$duplicate_action, array($this, 'admin_action__duplicate'));
		add_action('after_delete_post', array($this, 'action__after_delete_post'));
		//wpml duplicate fix
		add_action('icl_make_duplicate', array($this, 'action__icl_make_duplicate'), 10, 4);
	}

	function get_post_types() {
		return array('page');
	}

	function check_post($post) {
		if (!in_array($post->post_type, $this->get_post_types(), true))
			return false;

		if ('page' !== $post->post_type)
			return true;

		$page_template = get_post_meta($post->ID, '_wp_page_template', true);
		return in_array($page_template, $this->page_templates);
	}

	function register_post_type($args = array()) {
		parent::register_post_type(array('public'=>false, 'show_ui'=>false));
	}

	function action__add_meta_boxes($post) {
		$this->delete_section();

		$post_type = $post->post_type;

		$sections = get_posts(array(
			'fields' => 'ids',
			'post_type' => $this->post_type(),
			'post_status' => 'publish',
			'post_parent' => $post->ID,
			'orderby' => 'menu_order ID',
			'order' => 'ASC',
			'posts_per_page' => -1,
		));

		if (count($sections) > 0) {
			$id = wTheme::prefix('sections');
			add_meta_box($id, wTheme::__('Sections'), array($this, 'meta_box__render_sections'), $post_type, 'normal', 'low');
			add_filter("postbox_classes_{$post_type}_".$id, array($this, 'filter__page_classes'));
		}
		$id = wTheme::prefix('add_new_section');
		add_meta_box($id, wTheme::__('Add new section'), array($this, 'meta_box__add_section'), $post_type, 'normal', 'low');
		add_filter("postbox_classes_{$post_type}_".$id, array($this, 'filter__page_classes'));
	}

	function filter__page_classes($classes) {
		global $post;
		if ('page' !== $post->post_type)
			return $classes;

		$page_template = get_post_meta($post->ID, '_wp_page_template', true);
		if (!in_array($page_template, $this->page_templates))
			$classes[] = 'hidden';

		return $classes;
	}

	function meta_box__add_section($post) {
		$meta_key = wTheme::prefix('add_section');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($post->ID, true, true);
		$default_layout = key($this->layouts);
		if (!isset($data['layout']))
			$data['layout'] = $default_layout;
		?>
		<div id="section_create">
			<div style="overflow: hidden;">
				<p>
					<?php foreach ($this->layouts as $layout=>$options) { ?>
						<label>
							<input type="radio" name="<?php $this->field_name('layout', $meta_key); ?>" value="<?php echo $layout; ?>" <?php checked(@$data['layout'], $layout); ?> />
							<?php wTheme::_e($options['label']); ?>
						</label>
					<?php } ?>
				</p>
			</div>
			<?php
				submit_button(wTheme::__('Add section'), 'primary', $meta_key, false);
				$reset_order_url = admin_url('post.php?post='.$post->ID.'&action=edit&amp;reset_sections_order=1');
			?>
			<a href="<?php echo $reset_order_url; ?>" class="button reset_order" onclick="return confirm('<?php wTheme::_e('Are you sure you want to reset order on all sections?'); ?>');"><?php wTheme::_e('Reset order on all sections'); ?></a>
		</div>
		<script>
			jQuery(function () {
				var $main_submit = jQuery('#save-action input:submit');
				if (0 == $main_submit.size())
					$main_submit = jQuery('#publishing-action input:submit');
				jQuery('.section input:submit').click(function () {
					$main_submit.trigger('click');
					return false;
				});

				var $metaBoxAddSection = jQuery('#<?php echo wTheme::prefix('add_new_section'); ?>');
				var $metaBoxSections = jQuery('#<?php echo wTheme::prefix('sections'); ?>');
				jQuery('#page_template').change(function() {
					var is_section_template = jQuery.inArray(jQuery(this).val(), <?php echo json_encode($this->page_templates); ?>) > -1;
					$metaBoxAddSection.toggle(is_section_template);
					$metaBoxSections.toggle(is_section_template);
				}).change();
			});
		</script>
		<style>
			#section_create {
				padding-top: 6px;
			}
			#section_create label {
				margin-right: 20px;
				display: inline-block;
				margin-bottom: 20px;
			}
			#section_create .reset_order {
				margin-left: 10px;
			}

			/*- Section -*/
			.section {
				margin-top: 20px;
				padding-bottom: 10px;
				position: relative;
			}
			.section:before {
				content: '';
				top: -20px;
				left: -1%;
				width: 102%;
				height: 20px;
				background: #f1f1f1;
				position: absolute;
			}
			.section.first:before {
				display: none;
			}
			.section > .wtheme-media_attachment {
				display: inline-block;
				margin: 15px 20px 0 0;
				vertical-align: top;
			}
			.section > .order {
				display: inline-block;
				margin: 15px 20px 0 0;
			}
			.section .button.delete {
				margin-left: 10px;
			}
			.section .col-1 {
				width: 100%;
			}
			.section .col-2 {
				width: 47%;
			}
			.section .col-3 {
				width: 30%;
			}
			.section .col-4 {
				width: 22%;
			}
		</style>
		<?php
	}

	function meta_box__render_sections($post) {
		$sections = get_posts(array(
			'post_type' => $this->post_type(),
			'post_status' => 'publish',
			'post_parent' => $post->ID,
			'orderby' => 'menu_order ID',
			'order' => 'ASC',
			'posts_per_page' => -1,
		));

		foreach ($sections as $i=>$section) {
			$this->_render_section($section, $i);
		}
	}

	function _render_section($section_post, $i) {
		$meta_key = wTheme::prefix('save_sections');
		$this->nonce_field($meta_key);
		$data = self::get_all_meta($section_post->ID);
		$data['menu_order'] = $section_post->menu_order;
		?>
		<div class="section <?php if ($i == 0) echo 'first'; ?>">
			<?php
				$layout = $data['layout'];
				$layout_label = $this->layouts[$layout]['label'];
			?>
			<h3 class="hndle"><?php printf(wTheme::__('Section %s (%s)'), $i + 1, $layout_label); ?></h3>
			<?php
				$function_name = "section_{$layout}";
				if (method_exists($this, $function_name)) {
					$this->{$function_name}($section_post, $meta_key);
					$this->bg_color_settings($section_post, $meta_key);
				} else {
					$this->title_field($section_post, $meta_key);
					printf('<div>'.wTheme::__('Section layout "%s" does not exist').'</div>', $layout_label);
				}
			?>
			<p class="order">
				<label for="<?php $this->field_id('menu_order', $meta_key); ?>"><?php wTheme::_e('Order'); ?></label><br />
				<input type="number" step="1" min="1" name="<?php $this->field_name($section_post->ID.'.menu_order', $meta_key); ?>" value="<?php echo esc_attr(@$data['menu_order']); ?>" id="<?php $this->field_id('menu_order', $meta_key); ?>" class="small-text" />
			</p>
			<p>
				<?php
					submit_button(wTheme::__('Save'), 'primary', $meta_key, false);
					$delete_url = admin_url('post.php?post='.$section_post->post_parent.'&action=edit&amp;delete_section='.$section_post->ID);
				?>
				<a href="<?php echo $delete_url; ?>" class="button delete" onclick="return confirm('<?php wTheme::_e("Are you sure you want to delete this item?"); ?>');"><?php wTheme::_e('Delete'); ?></a>
			</p>
		</div>
		<?php
	}

	function title_field($section_post, $meta_key) {
		?><p>
		<label><?php wTheme::_e('Title'); ?></label><br />
		<input type="text" name="<?php $this->field_name($section_post->ID.'.post_title', $meta_key); ?>" value="<?php echo esc_attr($section_post->post_title); ?>" class="large-text" />
		</p><?php
	}

	function bg_color_settings($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_style('wp-color-picker');
		?>
		<hr style="margin-top:20px;" />
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php echo wTheme::get_media_popup_field($this->field_name($section_post->ID.'.bg_thumbnail_id', $meta_key, true), @$data['bg_thumbnail_id'], wTheme::__('Select background image')); ?>
			</p>
			<p>
				<?php $field = 'is_parallax'; $field_name = $section_post->ID.'.'.$field; ?>
				<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
				<label><input type="checkbox" name="<?php $this->field_name($field_name, $meta_key); ?>" value="1" <?php checked(@$data[$field]); ?> /> <?php wTheme::_e('Parallax background?'); ?></label>
			</p>
		</div>
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php $field = 'background_color'; $field_name = $section_post->ID.'.'.$field; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php _e('Background color'); ?></label><br />
				<input class="middle-text color_picker" id="<?php $this->field_id($field_name, $meta_key); ?>" name="<?php $this->field_name($field_name, $meta_key); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
			</p>
		</div>
		<div style="width: 32%;display:inline-block;vertical-align:top;">
			<p>
				<?php $field = 'text_color'; $field_name = $section_post->ID.'.'.$field; $value = @$data[$field]; ?>
				<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php _e('Text color'); ?></label><br />
				<input class="middle-text color_picker" id="<?php $this->field_id($field_name, $meta_key); ?>" name="<?php $this->field_name($field_name, $meta_key); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
			</p>
		</div>
		<div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'offset_top'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section top offset'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'offset_bottom'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section bottom offset'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
		</div>
		<div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'padding_top'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section top padding'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
			<div style="width: 33%;display:inline-block;vertical-align:top;">
				<p>
					<?php $field = 'padding_bottom'; $field_name = $section_post->ID.'.'.$field; ?>
					<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Set section bottom padding'); ?></label><br />
					<input type="number" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="small-text" /> px
				</p>
			</div>
		</div>
		<p>
			<?php $field = 'additional_classes'; $field_name = $section_post->ID.'.'.$field; ?>
			<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php wTheme::_e('Additional classes'); ?></label><br />
			<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
		</p>
		<script>
			jQuery(function() {
				jQuery('.color_picker').each(function(){
					jQuery(this).wpColorPicker();
				});
			});
		</script>
		<?php
	}

	function section_default($section_post, $meta_key) {
		$data = self::get_all_meta($section_post->ID);

		$default_section_columns_count = 4;

		if (!isset($data['column_count']))
			$data['column_count'] = '0';

		?>
		<p class="default_section_column_count-<?php echo $section_post->ID; ?>">
			<span><?php wTheme::_e('How many columns do you need?'); ?></span>
			<?php $field = 'column_count'; $field_name = $section_post->ID.'.'.$field; ?>
			<input type="hidden" name="<?php $this->field_name($field_name, $meta_key); ?>" value="0" />
			<?php for ($i = 0; $i < $default_section_columns_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<label style="margin-left:10px;" for="default-column-<?php echo $i.'-'.$section_post->ID; ?>"><input type="radio" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo $i; ?>" id="default-column-<?php echo $i.'-'.$section_post->ID; ?>" <?php checked(@$data[$field], $i); ?> /> <?php echo $k.'-'.wTheme::__('column'); ?></label>
			<?php } ?>
		</p>
		<div class="default_section_columns_wrap-<?php echo $section_post->ID; ?>" style="clear:both;overflow:hidden;">
			<?php for ($i = 0; $i < $default_section_columns_count; $i++) { ?>
				<?php $k = $i+1; ?>
				<div style="display: none;">
					<p>
						<?php $field = 'title_'.$i; $field_name = $section_post->ID.'.'.$field; ?>
						<label for="<?php $this->field_id($field_name, $meta_key); ?>"><?php echo wTheme::__('Title').' '.$k; ?></label><br />
						<input type="text" name="<?php $this->field_name($field_name, $meta_key); ?>" value="<?php echo esc_attr(@$data[$field]); ?>" id="<?php $this->field_id($field_name, $meta_key); ?>" class="large-text" />
					</p>
					<div>
						<?php wp_editor(@$data['post_content_'.$i], $this->field_id("post_content_{$i}_{$section_post->ID}", $meta_key, true), array('textarea_name'=>$this->field_name($section_post->ID.'][post_content_'.$i, $meta_key, true), 'editor_height'=>'280')); ?>
					</div>
				</div>
			<?php } ?>
		</div>
		<script>
			jQuery('.default_section_column_count-<?php echo $section_post->ID; ?> input:radio').change(function() {
				var $this = jQuery(this);
				if (!$this.is(':checked'))
					return;

				var val = $this.val();
				var $columns = jQuery('.default_section_columns_wrap-<?php echo $section_post->ID; ?> > div');
				$columns.removeClass('active');
				$columns.eq(val).addClass('active').prevAll().addClass('active');
			}).change();
		</script>
		<style>
			.default_section_columns_wrap-<?php echo $section_post->ID; ?> > div.active {
				display: block !important;
			}
		</style>
		<?php
	}

	function action__save_post($post_id) {
		$post = get_post($post_id);
		if (!$this->check_post($post))
			return;

		$meta_key = wTheme::prefix('add_section');
		if (!empty($_POST[$meta_key]) && $this->can_save_meta_data($post_id, $meta_key)) {
			$data = stripslashes_deep($_POST['data'][$meta_key]);
			if (!empty($data['layout'])) {
				$new_post = array(
					'post_type' => $this->post_type(),
					'post_status' => 'publish',
					'post_parent' => $post_id,
				);

				$sections = get_posts(array(
					'post_type' => $this->post_type(),
					'post_status' => 'publish',
					'post_parent' => $post_id,
					'orderby' => 'menu_order ID',
					'order' => 'DESC',
					'posts_per_page' => 1,
				));

				$new_post['menu_order'] = 1;
				if (!empty($sections))
					$new_post['menu_order'] = $sections[0]->menu_order + 1;

				remove_action('save_post', array($this, 'action__save_post'));
				$new_section_id = wp_insert_post($new_post, false);
				if (!is_wp_error($new_section_id) && $new_section_id > 0) {
					update_post_meta($new_section_id, 'layout', $data['layout']);
				}
				add_action('save_post', array($this, 'action__save_post'));
				//fix for wmpl
				if (!is_wp_error($new_section_id) && $new_section_id > 0) {
					global $wpdb;
					$wpdb->update($wpdb->posts, array('post_parent'=>$post_id), array('ID' => $new_section_id), array('%d'), array('%d'));
				}
			}
		}

		$meta_key = wTheme::prefix('save_sections');
		if (/*!empty($_POST[$meta_key]) && */$this->can_save_meta_data($post_id, $meta_key)) {
			$data = stripslashes_deep($_POST['data'][$meta_key]);
			foreach ($data as $section_post_id=>$fields) {
				$save_post_data = array();

				if (isset($fields['post_title'])) {
					$save_post_data['post_title'] = $fields['post_title'];
					unset($fields['post_title']);
				}
				if (isset($fields['post_content'])) {
					$save_post_data['post_content'] = $fields['post_content'];
					unset($fields['post_content']);
				}
				if (isset($fields['menu_order'])) {
					$save_post_data['menu_order'] = intval($fields['menu_order']);
					unset($fields['menu_order']);
				}

				if (!empty($save_post_data)) {
					$save_post_data['ID'] = $section_post_id;
					remove_action('save_post', array($this, 'action__save_post'));
					wp_update_post($save_post_data);
					add_action('save_post', array($this, 'action__save_post'));

					//fix for wpml
					global $wpdb;
					$wpdb->update($wpdb->posts, array('post_parent'=>$post_id), array('ID'=>$section_post_id), array('%d'), array('%d'));
				}

				if (!empty($fields)) {
					foreach ($fields as $_meta_key=>$meta_value)
						update_post_meta($section_post_id, $_meta_key, $meta_value);
				}

				$section_post_layout = get_post_meta($section_post_id, 'layout', true);
				do_action(wTheme::prefix("save_section_{$section_post_layout}"), $section_post_id, $fields, $meta_key);
				do_action(wTheme::prefix('save_section'), $section_post_id, $fields, $meta_key);
			}
		}
	}

	function delete_section() {
		if (isset($_GET['post']) && isset($_GET['delete_section'])) {
			if (current_user_can('delete_post', intval($_GET['delete_section']))) {
				$post_id = intval($_GET['post']);
				$section_post_id = intval($_GET['delete_section']);
				$item = get_post($section_post_id);
				if ($this->post_type() === $item->post_type)
					wp_delete_post($item->ID, true);

				redirect_post($post_id);
				exit();
			}
		}
		if (isset($_GET['post']) && isset($_GET['reset_sections_order'])) {
			$post_id = intval($_GET['post']);
			$this->reset_order($post_id);
			redirect_post($post_id);
			exit();
		}
	}

	function action__after_delete_post($post_id) {
		//@todo check is wpml for 'suppress_filters' => true
		$posts = get_posts(array('post_type'=>$this->post_type(), 'post_status'=>'any', 'post_parent'=>$post_id, 'suppress_filters'=>true, 'posts_per_page'=>-1));
		foreach ($posts as $post)
			wp_delete_post($post->ID, true);
	}

	function reset_order($post_parent_id) {
		$posts = get_posts(array('post_type'=> $this->post_type(), 'post_status'=>'any', 'post_parent'=>$post_parent_id, 'posts_per_page'=>-1, 'orderby' => 'menu_order ID', 'order'=>'ASC'));
		foreach ($posts as $i=>$post) {
			$save_post_data = array();
			$save_post_data['ID'] = $post->ID;
			$save_post_data['menu_order'] = $i+1;
			wp_update_post($save_post_data);
		}
	}

	function filter__row_actions($actions, $post) {
		if ($this->check_post($post) && current_user_can('edit_posts')) {
			$url = admin_url('admin.php?action='.self::$duplicate_action.'&amp;post='.$post->ID);
			$actions['duplicate'] = '<a href="'.$url.'">'.wTheme::__('Duplicate').'</a>';
		}
		return $actions;
	}

	function admin_action__duplicate() {
		if (self::$duplicate_action !== @$_REQUEST['action'] || !current_user_can('edit_posts') || !isset($_GET['post']))
			return;

		$post = get_post((int) $_GET['post']);
		if (!$post || !$this->check_post($post))
			return;

		$current_user = wp_get_current_user();

		$meta = self::get_all_meta($post->ID);
		$post_data = array();
		$post_data['post_author'] = $current_user->ID;
		$post_data['post_title'] = $post->post_title.' ('.wTheme::__('Duplicated').')';
		$post_data['post_status'] = 'draft';
		$post_data['comment_count'] = 0;
		$new_post_id = $this->duplicate_post($post->ID, $meta, $post_data);
		if ($new_post_id > 0) {
			$this->duplicate_sections($post->ID, $new_post_id);
		}

		wp_redirect(admin_url('post.php?post='.$new_post_id.'&action=edit'));
		exit;
	}

	function duplicate_post($id, $meta = array(), $post_data = array()) {
		if (!$post = get_post($id))
			return false;

		$save_data = (array) $post;
		$unset_fields = array('ID', 'post_name', 'guid');//, 'post_date', 'post_date_gmt', 'post_name', 'post_modified', 'post_modified_gmt', 'guid');
		foreach ($unset_fields as $field)
			unset($save_data[$field]);

		$save_data['post_title'] = $post->post_title.' ('.wTheme::__('Duplicated').')';
		$save_data['post_status'] = 'draft';
		$save_data['comment_count'] = 0;

		$save_data = wp_parse_args($post_data, $save_data);
		$new_post_id = wp_insert_post($save_data);
		if ($new_post_id > 0) {
			$taxonomies = get_object_taxonomies($post->post_type);
			foreach ($taxonomies as $taxonomy) {
				$post_terms = wp_get_object_terms($post->ID, $taxonomy, array('fields' => 'ids'));
				wp_set_object_terms($new_post_id, $post_terms, $taxonomy);
			}

			foreach ($meta as $k=>$v)
				update_post_meta($new_post_id, $k, $v);
		}
		return $new_post_id;
	}

	function action__icl_make_duplicate($master_post_id, $lang, $post_array, $id) {
		$this->duplicate_sections($master_post_id, $id);
	}

	function duplicate_sections($post_parent_id, $new_post_parent_id) {
		$posts_query = new WP_Query(array('post_type'=>$this->post_type(), 'post_status'=>'any', 'post_parent'=>$post_parent_id, 'posts_per_page'=>-1));
		if ($posts_query->have_posts()) {
			while ($posts_query->have_posts()) { $posts_query->the_post();
				$child_id = get_the_ID();
				$meta = self::get_all_meta($child_id);
				$post_data = array(
					'post_title' => get_the_title(),
					'post_parent' => $new_post_parent_id,
					'post_status' => get_post_status($child_id),
				);
				$this->duplicate_post($child_id, $meta, $post_data);
			}
			wp_reset_postdata();
		}
	}
}