<?php
/**
 * Version: 0.1.6
 */
class wCustomPostType {

	//static $post_type; Must be defined in children to use

	protected $_post_type = '';

	private static $post_types = array();

	private static $internal_post_types = array('page', 'post', 'attachment', 'revision', 'nav_menu_item');

	function __construct($post_type) {
		if (empty($post_type))
			throw new Exception('Empty post type');

		$class_name = get_called_class();
		if (!property_exists($class_name, 'post_type'))
			throw new Exception("{$class_name}::post_type property does not exist");

		if (in_array($post_type, self::$post_types))
			throw new Exception("Post type '{$post_type}' already registered");

		$this->post_type($post_type);
		$this->add_hooks();
	}

	function add_hooks() {
		$post_type = $this->post_type();
		//Fix updated page multiple times
		add_action('init', array($this, 'action__init'));
		add_action("add_meta_boxes_{$post_type}", array($this, 'action__add_meta_boxes'));
		add_action('save_post', array($this, 'action__save_post'));
		if (!$this->is_internal_post_type($post_type))
			remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10);

		add_action("manage_{$post_type}_posts_custom_column", array($this, 'action__manage_custom_column'), 10, 2);
		add_filter("manage_{$post_type}_posts_columns", array($this, 'filter__manage_columns'));
		//TODO add default sorting 'orderby' => array('menu_order' => 'ASC', 'date' => 'DESC')
	}

	function is_internal_post_type($post_type = null) {
		if (is_null($post_type))
			$post_type = $this->post_type();
		return in_array($post_type, self::$internal_post_types);
	}

	function action__init() {
		if (!$this->is_internal_post_type())
			$this->register_post_type();
	}

	function action__add_meta_boxes($post) {}

	function action__save_post($post_id) {
		$this->save_post($post_id);
	}

	function save_post($post_id) {}

	function action__manage_custom_column($column, $post_id) {
		echo esc_html(get_post_meta($post_id, $column, true));
	}

	function filter__manage_columns($columns) {
		return $columns;
	}

	function get_labels($singular = '', $plural = '') {
		if (!empty($singular) && !empty($plural)) {
			$singular = wTheme::__($singular);
			$plural = wTheme::__($plural);
		} else {
			$singular = _x('Post', 'post type singular name');
			$plural = _x('Posts', 'post type general name');
		}

		return array(
			'name' => $plural,
			'singular_name' => $singular,
			'add_new_item' => sprintf(wTheme::__('Add New %s'), $singular),
			'edit_item' => sprintf(wTheme::__('Edit %s'), $singular),
			'new_item' => sprintf(wTheme::__('New %s'), $singular),
			'view_item' => sprintf(wTheme::__('View %s'), $singular),
			'search_items' => sprintf(wTheme::__('Search %s'), $plural),
			'not_found' => sprintf(wTheme::__('No %s found.'), $plural),
			'not_found_in_trash' => sprintf(wTheme::__('No %s found in Trash.'), $plural),
			'all_items' => sprintf(wTheme::__('All %s'), $plural),
		);
	}

	function get_label($key) {
		$post_type = get_post_type_object($this->post_type());
		return $post_type->labels->{$key};
	}

	function register_post_type($args = array()) {
		$post_type = $this->post_type();
		if (post_type_exists($post_type))
			throw new Exception("Post type '{$post_type}' already registered");

		$defaults = array(
			'public' => true,
			'show_ui' => true,
			'hierarchical' => false,
			'capability_type' => 'post',
			'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
			'rewrite' => false,
		);

		if ($labels = $this->get_labels())
			$defaults['labels'] = $labels;

		$args = wp_parse_args($args, $defaults);
		register_post_type($post_type, $args);
	}

	function post_type($post_type = '') {
		if (!empty($post_type)) {
			$this->_post_type = $post_type;
			self::$post_types []= $post_type;

			if (property_exists(get_called_class(), 'post_type'))
				static::$post_type = $post_type;
		}

		return $this->_post_type;
	}

	private static function get_post_type() {
		return static::$post_type;
	}

	function field_name($field_name, $meta_key, $return = false) {
		$field_name = str_replace('.', '][', $field_name);
		$field = "data[{$meta_key}][{$field_name}]";
		if (!$return)
			echo $field;

		return $field;
	}

	function field_id($field_name, $meta_key, $return = false) {
		$field_id = str_replace('.', '_', "{$meta_key}_{$field_name}");
		if (!$return)
			echo $field_id;

		return $field_id;
	}

	function nonce_field($name = '_wpnonce', $action = 'save', $referer = true, $echo = true) {
		$post_type = $this->post_type();
		return wp_nonce_field("{$post_type}-{$name}-{$action}", "{$post_type}-{$name}_nonce", $referer, $echo);
	}

	function can_save_meta_data($post_id, $meta_key, $action = 'save') {
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || wp_is_post_revision($post_id))
			return false;

		$post_type = $this->post_type();
		if (!wp_verify_nonce(@$_POST["{$post_type}-{$meta_key}_nonce"], "{$post_type}-{$meta_key}-{$action}"))
			return false;

		$capability = 'page' === $post_type ? 'edit_page' : 'edit_post';
		if (!current_user_can($capability, $post_id))
			return false;

		if (empty($_POST['data'][$meta_key]))
			return false;

		return true;
	}

	function save_meta_data($post_id, $meta_key, $save_in_multiple = true, $is_add_prefix = null) {
		if (!$this->can_save_meta_data($post_id, $meta_key))
			return false;

		if (is_null($is_add_prefix)) {
			$is_add_prefix = $this->is_internal_post_type();
		}

		$data = stripslashes_deep($_POST['data'][$meta_key]);
		if ($save_in_multiple) {
			foreach ($data as $field=>$value)
				update_post_meta($post_id, $is_add_prefix ? wTheme::prefix($field) : $field, $value);
		} else {
			update_post_meta($post_id, $is_add_prefix ? $meta_key : wTheme::remove_prefix($meta_key), $data);
		}

		return true;
	}

	static function get_meta($post_id, $key = '', $is_add_prefix = false) {
		return get_post_meta($post_id, $is_add_prefix ? wTheme::prefix($key) : $key, true);
	}

	static function get_all_meta($post_id, $is_remove_prefix = false) {
		$data = array();
		$meta_data = get_post_meta($post_id, '', true);
		if (empty($meta_data))
			return $data;

		foreach ($meta_data as $meta_key=>$meta_value) {
			if ($is_remove_prefix)
				$meta_key = wTheme::remove_prefix($meta_key);
			$data[$meta_key] = maybe_unserialize($meta_value[0]);
		}

		return $data;
	}

	static function wp_query($args = array(), $settings = array()) {
		if (!isset($args['post_type'])) {
			$post_type = static::get_post_type();
		} else {
			$post_type = $args['post_type'];
		}

		$defaults = array(
			'post_type' => $post_type,
			'post_status' => 'publish',
			'posts_per_page' => -1,
		);

		$supports = get_all_post_type_supports($post_type);
		if (@$supports['page-attributes']) {
			$defaults['orderby'] = array('menu_order'=>'ASC', 'title' => 'ASC');
		}

		if (@$settings['use_pagination']) {
			$paged = get_query_var('paged');
			if (!empty($paged)) {
				$args['paged'] = $paged;
			}
		}

		$args = wp_parse_args($args, $defaults);
		return new WP_Query($args);
	}
}