<?php
/**
 * Version: 0.0.2
 */

if (!class_exists('PRO_EUCLP_wPlugin')) {
class PRO_EUCLP_wPlugin {

	static $prefix = 'plugin_prefix';

	static $domain = 'plugin_domain';

	static $plugin_basename = '';

	static $plugin_rel_path = '';

	static $plugin_dir_path = '';

	static $plugin_dir_url = '';

	function __construct() {
		$this->_hooks();
	}

	function _hooks() {}

	static function init($unique_name = 'default') {
		self::$plugin_basename = plugin_basename(__FILE__);
		self::$plugin_rel_path = rtrim(dirname(self::$plugin_basename), '/');
		self::$plugin_dir_path = rtrim(plugin_dir_path(__FILE__), '/');
		self::$plugin_dir_url = plugin_dir_url(__FILE__);
		self::$domain = self::$prefix = $unique_name;

		if(function_exists('load_plugin_textdomain'))
			load_plugin_textdomain(self::$domain, false, self::$plugin_rel_path.'/languages/');
	}

	static function prefix($text, $prefix = '', $delimiter = '_') {
		$prefix = '' == $prefix ? self::$prefix : $prefix;
		return $prefix.$delimiter.$text;
	}

	static function remove_prefix($text) {
		$prefix = self::prefix('');
		if(0 === strpos($text, $prefix))
			$text = substr($text, strlen($prefix)).'';
		return $text;
	}

	static function __($text, $domain = '') {
		$domain = ('' != $domain) ? $domain : self::$domain;
		return translate($text, $domain);
	}

	static function _e($text, $domain = '') {
		echo self::__($text, $domain);
	}

	static function excerpt($text, $length = 80, $more = '&#8230;') {
		$length = intval($length);
		$text = strip_shortcodes($text);
		$text = wp_strip_all_tags($text, true);
		if(strlen($text) <= $length)
			return $text;

		$text = mb_substr($text, 0, $length);
		return $text.$more;
	}
}
}
